/*
 * @(#)GenerateCSV.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Generator CSVt@C̏o
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/23
 */

package jp.co.nri.rid.generator;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import java.util.Random;
import org.w3c.dom.*;


/**
 * Rid CSVt@Co
 */
public class GenerateCSV extends GenerateParser {

    /** TCgXMLt@CuSite.xmlv           **/
    final static public String SITE_XML      = "Site.xml";
    /** \[XXMLt@CuResource.xmlv     **/
    final static public String RESOURCE_XML  = "Resource.xml";
    /** hLgXMLt@CuDocument.xmlv **/
    final static public String DOCUMENT_XML  = "Document.xml";

    /** ZoneUnit̒` **/
    final static public String ZONE_UNIT     = "<ZoneUnit>";
    /** PageUnit̒` **/
    final static public String PAGE_UNIT     = "<PageUnit>";
    /** ResourceUnit̒` **/
    final static public String RESOURCE_UNIT = "<ResourceUnit>";
    /** DocumentUnit̒` **/
    final static public String DOCUMENT_UNIT = "<DocumentUnit>";

    /** o̓t@CFileOutputStream **/
    protected FileOutputStream    outFileStream = null;
    /** o̓t@COutputStreamWriter **/
    protected OutputStreamWriter  outWriter = null;

/**
  * ftHgRXgN^
  */
    public GenerateCSV() {}



/**
  * Site.XMLCSV`ŏo
  *
  * @param  Document    doc             Site.XML̃hLg
  * @param  String      out_file        o̓t@CitpXj
  * @return void
  */
    public boolean csvSite(Document doc, String out_file) throws Exception {
        return (csv(SITE_XML, doc, out_file));
    }

/**
  * Resource.XMLCSV`ŏo
  *
  * @param  Document    doc             Resource.xml̃hLg
  * @param  String      out_file        o̓t@CitpXj
  * @return void
  */
    public boolean csvResource(Document doc, String out_file) throws Exception {
        return (csv(RESOURCE_XML, doc, out_file));
    }

/**
  * Document.XMLCSV`ŏo
  *
  * @param  Document    doc             Document.xml̃hLg
  * @param  String      out_file        o̓t@CitpXj
  * @return void
  */
    public boolean csvDocument(Document doc, String out_file) throws Exception {
        return (csv(DOCUMENT_XML, doc, out_file));
    }

/**
  * wlkt@Cbru`ŏo
  *
  * @param  String      xml_type        XMLt@C^Cv[Site.xml/Resource.xml/Document.xml]
  * @param  Document    doc             hLg
  * @param  String      out_file        o̓t@CitpXj
  */
    private boolean csv(String xml_type, Document doc, String out_file) throws Exception {

        //XMLDocument̉
        ProjectInfo  project_info = documentParser(doc, "", "");

        //CSVt@C
        return (generateCSV(xml_type, project_info, out_file));

    }

/**
  * CSV̐
  *
  * @param  Document    doc             hLg
  * @param  String      out_file        o̓t@C
  * @return void
  */
    private boolean generateCSV(String xml_type, ProjectInfo project_info, String out_file) throws Exception {

        boolean ret = false;

        // FILE OPEN
        outFileStream = new FileOutputStream(out_file);
        outWriter = new OutputStreamWriter(outFileStream);
            
        // WRITE CSV
        writeCSV(xml_type, project_info.zone);

        // FILE CLOSE
        outWriter.close();

        return true;
    }

/**
  * J}`ŏo
  *
  * @param  String    xml_type          XML̃^Cv
  * @param  ZoneInfo    zone            ZONE
  * @return void
  */
    private void writeCSV(String xml_type, ZoneInfo zone) throws Exception {

        // ZonȇSJ}`ŏo
        writeUnit(ZONE_UNIT, zone.attr_lst);

        // XML̃^Cv𔻒f
        if (xml_type.compareTo(SITE_XML) == 0) {

            //[Site.XML]CSVŏo   ...PageUnit̏o
            for ( int i = 0; i < zone.page_lst.size(); i++ ) {
                PageInfo page_info = (PageInfo)zone.page_lst.elementAt(i);
                writeUnit(PAGE_UNIT, page_info.attr_lst);
            }
        
        } else if (xml_type.compareTo(RESOURCE_XML) == 0) {

            //[Resource.XML]CSVŏo ...ResourceUnit̏o
            for ( int i = 0; i < zone.resource_lst.size(); i++ ) {
                ResourceInfo resource_info = (ResourceInfo)zone.resource_lst.elementAt(i);
                writeUnit(RESOURCE_UNIT, resource_info.attr_lst);
            }

        } else if (xml_type.compareTo(DOCUMENT_XML) == 0) {

            //[Document.XML]CSVŏo ...DocumentUnit̏o
            for ( int i = 0; i < zone.document_lst.size(); i++ ) {
                DocumentInfo document_info = (DocumentInfo)zone.document_lst.elementAt(i);
                writeUnit(DOCUMENT_UNIT, document_info.attr_lst);
            }

        }

        //J}`ŏo
        for ( int n = 0; n < zone.zone_lst.size(); n++ ) {
            ZoneInfo zone_info = (ZoneInfo)zone.zone_lst.elementAt(n);
            writeCSV(xml_type, zone_info);
        }
    }


/**
  * UNITPʂŃJ}`ŏo
  *
  * @param  String    @unitType        UNIT
  * @param  Vector    @attr_lst        Xg
  * @return void
  */
    private void writeUnit(String unitType, Vector attr_lst) throws Exception {

        String  buff = "";

        // J}`ŏo
        buff = unitType;
        for ( int i = 0; i < attr_lst.size(); i++ ) {
            Attribute attr = (Attribute)attr_lst.elementAt(i);
            if (attr.value.indexOf(",") != -1) {
                buff = buff + "," + "\"" + attr.value + "\"";
            } else {
                buff = buff + "," + attr.value;
            }
        }
        buff = buff + "\n";

        //o̓t@Cɏo
        outWriter.write(buff, 0, buff.length());
    }

}
