/*
 * @(#)GenerateNavibar.java
 *
 * RID-X    : Generator w/ŋ NaviBar
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/23
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */
package jp.co.nri.rid.generator;

import java.io.*;
import java.util.*;
import org.w3c.dom.*;


import jp.co.nri.rid.mapper.*;
import jp.co.nri.rid.error.*;
import jp.co.nri.rid.snapshot.*;

/**
 * Rid w/ŋ NaviBar
 */
public class GenerateNavibar extends GenerateParser {

    /** iro[^CvFw **/
    final   static public String PRODUCT = "Product";
    /** iro[^CvFŋ    **/
    final   static public String PRESENT = "Present";

    /** ev[gfBNg    **/
    private static String gn_templateDir = "";
    /** o̓fBNg    **/
    private static String gn_outDir      = "";
    /** iro[̃^Cv    **/
    private static String gn_type        = "";

    /** iro[  index.html  **/
    private static final String prAdminIndex  = "../Admin/index.html";
    /** iro[  index_1.html  **/
    private static final String prAdminIndex1 = "../Admin/index_1.html";
    /** iro[  index_2.html  **/
    private static final String prAdminIndex2 = "../Admin/index_2.html";
    /** iro[  index_3.html  **/
    private static final String prAdminIndex3 = "../Admin/index_3.html";
    /** iro[  index_4.html  **/
    private static final String prAdminIndex4 = "../Admin/index_4.html";
    /** iro[  index_5.html  **/
    private static final String prAdminIndex5 = "../Admin/index_5.html";

    /** iro[f[^  **/
    class NaviData {
        String        linkStart;
        String        name;
        String        linkEnd;
    }


/**
  * ftHgRXgN^
  */
    public GenerateNavibar() {}


/**
  * iro[̍쐬
  *
  * @param  String      type            w^ŋ̃^Cv
  * @param  String      template_dir    ev[gfBNg
  * @param  String      out_dir         o̓fBNg
  * @param  ZoneInfo    zone            Zonȅ
  * @param  ZoneInfo    parent          eZonȅ
  */
    public boolean generate(String type, String template_dir, String out_dir, ZoneInfo zone, ZoneInfo parent) throws Exception {

        boolean ret = false;

        //ev[gfBNg
        gn_templateDir = template_dir;
  
        //o͐
        gn_outDir = out_dir;

        //iro[̎
        gn_type = type;

        //iro[̍쐬
        generateNavi(zone, parent);

        return true;
    }


/**
  *  NaviData̐
  *
  * @param  String      link            linkHTMLt@C
  * @param  String      alt             <A>TagALT
  * @return MapData
  */
    private NaviData createNaviData(String href, String alt) throws Exception {

        NaviData mapData  = new NaviData();
        mapData.linkStart = replaceWebFileSeparator("<a href=\"" + href + "\" target=\"_top\">");
        mapData.name      = alt;
        mapData.linkEnd   = "</a>";
        return mapData;
    }


/**
  * wpNaviData쐬
  *
  * @param  ZoneInfo    zone            Zone
  * @return NaviData
  */
    private NaviData naviProductData(ZoneInfo zone) throws Exception {

        String link;
        if (gn_type.compareTo(PRODUCT) == 0) {
            //w̃iro[̏ꍇ
            link = zone.parent + puOutRefresh;
        } else {
            //ŋ̃iro[̏ꍇ
            link = zone.parent + "../" + puProductDir + "/" + puOutRefresh;
        }
       return (createNaviData(link,""));
    }


/**
  * ŋpNaviData쐬
  *
  * @param  ZoneInfo    zone            Zone
  * @return NaviData
  */
    private NaviData naviPresentData(ZoneInfo zone) throws Exception {

        String link;

        if (gn_type.compareTo(PRESENT) == 0) {
            //ŋ̃iro[̏ꍇ
            link = zone.parent + puOutRefresh;
        } else {
            //w̃iro[̏ꍇ
            link = zone.parent + "../" + puPresentDir + "/" + puOutRefresh;
        }
        return (createNaviData(link,""));
    }


/**
  * ir̐
  *   ZoneɊ܂܂PageUnit̂ǂ
@*   NaviBarpPage񃊃Xg쐬
  * 
  * @param  ZoneInfo    zone            Zone
  * @return Vector      PagẽXg
  */
    private Vector naviPageLst(ZoneInfo zone) throws Exception {

        Vector  lst = new Vector();

        for ( int i = 0; i < zone.page_lst.size(); i++ ) {
            PageInfo page_info = (PageInfo)zone.page_lst.elementAt(i);

            NaviData pageData = naviPage(page_info);
            if (pageData != null) lst.add(pageData);
        }

        return lst;
    }


/**
  * iro[̏izonej
  *
  * @param  PageInfo    page_info       Pagȅ
  * @return MapDatãXg
  * w̐
  */
    private NaviData naviPage(PageInfo page) throws Exception {
        return(createNaviData(page.name + puOutFrame, page.name));
    }


/**
  * ir̐
  *   ZoneɊ܂܂ZoneUnit̂ǂ
@*   NaviBarpZone񃊃Xg쐬
  * 
  * @param  ZoneInfo    zone            Zone
  * @return Vector      PagẽXg
  */
    private Vector naviZoneLst(ZoneInfo zone) throws Exception {

        Vector  lst = new Vector();

        for ( int n = 0; n < zone.zone_lst.size(); n++ ) {
            ZoneInfo zone_info = (ZoneInfo)zone.zone_lst.elementAt(n);

            //iro[̏iZonej
            NaviData zoneData = naviZone(zone_info);
            if (zoneData != null) lst.add(zoneData);
        }

        return lst;
  }


/**
  * iro[̏izonej
  *
  * @param  ZoneInfo    zone_info       Zonȅ
  * @return MapDatãXg
  */
    private NaviData naviZone(ZoneInfo zone) throws Exception {

        String href;

        //ZONEPage݂邩H
        if (zone.page_lst.size() > 0){
            // Page݂ꍇA擪̃y[W\
            PageInfo page_info = (PageInfo)zone.page_lst.elementAt(0);
            href = zone.name +"/" + page_info.name + puOutFrame;
            
        } else {
            // Page݂ȂꍇA󔒂̃y[W\
            href=  zone.name +"/" + puBlank + puOutFrame;
        }
        return(createNaviData(href, zone.name));
    }


/**
  * ir̐
  *   eZoneɊ܂܂ZoneUnit̂ǂ
@*   NaviBarpZone񃊃Xg쐬
  * 
  * @param  ZoneInfo    zone            eZone
  * @return Vector      ePagẽXg
  */
    private Vector naviParentLst(ZoneInfo parent) throws Exception {

        Vector  lst = new Vector();

        if (parent != null) {
            //iro[̏iparentj
            NaviData parentData = naviParent(parent);
            if (parentData != null) lst.add(parentData);
        }
        return lst;
  }


/**
  * iro[̏iparentj
  *
  * @param  ZoneInfo    zone_info       Zonȅ
  * @return MapDatãXg
  */
    private NaviData naviParent(ZoneInfo zone) throws Exception {

        String href;
        String alt;

        //ZONEPage݂邩H
        if (zone.page_lst.size() > 0){
            // Page݂ꍇA擪̃y[W\
            PageInfo page_info = (PageInfo)zone.page_lst.elementAt(0);
            href = "../" + page_info.name + puOutFrame;
            alt  = zone.name + "/" + page_info.name + puOutFrame;
        } else {
            // Page݂ȂꍇABlanky[W\
            href = "../" + puBlank + puOutFrame;
            alt  = zone.name + "/" + puBlank + puOutFrame;
        }
        return(createNaviData(href, alt));
    }


/**
  * ir̐
  *
  * @param  ZoneInfo    zone            Zonȅ
  * @param  ZoneInfo    parent          eZonȅ
  * @return boolean     trueij/ falseisj
  */
    private boolean generateNavi(ZoneInfo zone, ZoneInfo parent) throws Exception {
 
        boolean ret = false;
        String out = "";
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        // _navi,htmlLf
        String template = gn_templateDir + File.separator + puTemplNavi;
        if ( !xc.fileExists(template) ){
            throw new RidException(ridMsg.Error("E4001", template));
        }

        //o̓t@C TOP ZoneUnit̏ꍇ true
        if (zone.top) {
            out = gn_outDir + File.separator + zone.name + puOutNavi;
        } else {
            out = gn_outDir + File.separator + zone.file + File.separator + zone.name + puOutNavi;
        }

        //Map Data̐
        Document temp_data = generateNaviData(zone, parent);

        //XmlUtil xu = new XmlUtil();
        //xu.writeDocment2XMLFile(new File(".", "mapperType3.xml"), temp_data);

        //iro[HTML
        Mapper mapper = new Mapper();
        ret = mapper.Type3(template, temp_data, out);
        if (!ret) {
            throw new RidException(ridMsg.Error("E4002", mapper.getErrorString()));
        }
        return ret;
    }


/**
  * irf[^̐
  *
  * @param  ZoneInfo    zone            Zonȅ
  * @param  ZoneInfo    parent          eZonȅ
  * @return Document    hg
  */
    private Document generateNaviData(ZoneInfo zone, ZoneInfo parent) throws Exception {

        Document doc = new org.apache.xerces.dom.DocumentImpl();
        Element topElem = doc.createElement(puRootTag);
        doc.appendChild(topElem);

        // home
        NaviData homeData = createNaviData(zone.parent + prAdminIndex, "");
        writeNaviData(topElem, "HomeData", homeData);

        // index1
        NaviData index1Data = createNaviData(zone.parent + prAdminIndex1, "");
        writeNaviData(topElem, "Index1", index1Data);

        // index2
        NaviData index2Data = createNaviData(zone.parent + prAdminIndex2, "");
        writeNaviData(topElem, "Index2", index2Data);

        // index3
        NaviData index3Data = createNaviData(zone.parent + prAdminIndex3, "");
        writeNaviData(topElem, "Index3", index3Data);

        // index4
        NaviData index4Data = createNaviData(zone.parent + prAdminIndex4, "");
        writeNaviData(topElem, "Index4", index4Data);

        // index5
        NaviData index5Data = createNaviData(zone.parent + prAdminIndex5, "");
        writeNaviData(topElem, "Index5", index5Data);

        // w
        NaviData productData = naviProductData(zone);
        writeNaviData(topElem, "ProductData", productData);

        // ŋ
        NaviData presentData = naviPresentData(zone);
        writeNaviData(topElem, "PresentData", presentData);

        // eZone
        Vector parent_lst = naviParentLst(parent);
        for ( int i = 0; i < parent_lst.size(); i++ ) {
            NaviData parentData = (NaviData)parent_lst.elementAt(i);
            writeNaviData(topElem, "ParentData", parentData);
        }

        // y[W
        Vector page_lst = naviPageLst(zone);
        for ( int i = 0; i < page_lst.size(); i++ ) {
            NaviData pageData = (NaviData)page_lst.elementAt(i);
            writeNaviData(topElem, "PageData", pageData);
        }

        // qZone
        Vector zone_lst = naviZoneLst(zone);
        for ( int i = 0; i < zone_lst.size(); i++ ) {
            NaviData zoneData = (NaviData)zone_lst.elementAt(i);
            writeNaviData(topElem, "ZoneData", zoneData);
        }
        return doc;
    }


/**
  * irf[^̏o
  *
  * @param  Element     topElem         Element
  * @param  String      repeaNamet      s[g
  * @param  NaviData    naviData        irf[^
  * @return void
  */
    private void writeNaviData(Element topElem, String repeatName, NaviData naviData) throws Exception {

        XmlUtil xu = new XmlUtil();
        Element elem = xu.createSubElement(topElem, repeatName);
        xu.createOrSetTextValue(elem, "linkStart", naviData.linkStart);
        xu.createOrSetTextValue(elem, "imageAlt",  naviData.name);
        xu.createOrSetTextValue(elem, "linkEnd",   naviData.linkEnd);
    }
}
