/*
 * @(#)GeneratePage.java
 *
 * RID-X    : w^ŋ̃y[W
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/10/01
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */
package jp.co.nri.rid.generator;

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import jp.co.nri.Ridual;
import jp.co.nri.rid.mapper.*;
import jp.co.nri.rid.error.*;
import jp.co.nri.rid.snapshot.xcopy;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;


/**
 * Rid w^ŋ̃y[W
 */
public class GeneratePage extends GenerateParser {
    /** RCS ID */
    private static final String RCSID =
        "$Id: GeneratePage.java,v 1.3 2003/01/24 15:19:29 nsmr Exp $";

    /** rid.template.dirvpeB  **/
    final static public String RID_TEMPLATE_DIR = "rid.template.dir";
    /** rid.parts.dirvpeB  **/
    final static public String RID_PARTS_DIR    = "rid.parts.dir";
    /** rid.html.dirvpeB  **/
//    final static public String RID_HTML_DIR     = "rid.html.dir";

    /** gslkt@C̃fBNg  **/
    private static String pr_htmlDir;
    /** ev[gt@Ciprojectj̃fBNg  **/
    private static String pr_templateDir;
    /** ev[gt@CiPartsj̃fBNg  **/
    private static String pr_partsDir;


/**
  * ftHgRXgN^
  */
    public GeneratePage() {
        pr_htmlDir = "";                    // gslkt@C̃fBNg
        pr_templateDir = "";                // ev[gt@Ciprojectj̃fBNg
        pr_partsDir = "";                   // ev[gt@CiPartsj̃fBNg
    }


/**
  * y[W
  *
  * @param  Document    doc             hLg
  * @param  String      project_dir     vWFNgfBNg
  * @return boolean     true()/false(s)
  */
    public boolean generate(Document doc, String project_dir) throws RidException, Exception {

        boolean ret = false;
        RidMessage ridMsg = new RidMessage();

        //fBNg̎擾
        ZResource res = ZApp.getTheApp().getResource();
//        pr_htmlDir     = project_dir + File.separator + res.getString(RID_HTML_DIR);       // htmlfBNg
        pr_htmlDir     = Ridual.getHtmlDir();       // htmlfBNg
        pr_templateDir = project_dir + File.separator + res.getString(RID_TEMPLATE_DIR);   // ev[gfBNg
        pr_partsDir    = project_dir + File.separator + res.getString(RID_PARTS_DIR);      // ev[gfBNg

        //document̉
        ProjectInfo  project_info = new ProjectInfo();
        project_info = documentParser(doc, "", "");

        //y[W̐
        ret = pageZone(project_info.zone, null);

        return ret;
    }

/**
  * y[W@iZONE)
  *
  * @param  ZoneInfo    zone            Zone
  * @param  ZoneInfo    parent          Zone̐e
  * @return boolean     trueij/ falseisj
  */
    private boolean pageZone(ZoneInfo zone, ZoneInfo parent) throws Exception {

        boolean ret = true;
        xcopy xc = new xcopy();

        // Top][ȊO̎ 2002.10.01
        // ̃][łAfBNg쐬
        if (!zone.top) {
            // fBNgpX擾A
            String dir_name = web2SeparatorChar(pr_htmlDir + File.separator + zone.file);
            ret = xc.makeDir(dir_name);

            /* fBNg̐ɐꍇAExist Agr[g true
             * ɂB
             * t3-nishimura@nri
             */
            if (xc.fileExists(dir_name)) {
                zone.element.attribute("Exist", "true");
            }
        }

        // fBNg̐ɐꍇ̂
        if (ret){
            //Page
            if (zone.page_lst.size() > 0) {
                //ZoneɃy[W݂
                for ( int i = 0; i < zone.page_lst.size(); i++ ) {
                    PageInfo page_info = (PageInfo)zone.page_lst.elementAt(i);
                    ret = generatePage(zone, page_info);
                    //if (!ret) return false;@edit 2002.10.01
                }
            }
            //Zone
            for ( int n = 0; n < zone.zone_lst.size(); n++ ) {
                ZoneInfo zone_info = (ZoneInfo)zone.zone_lst.elementAt(n);
                ret = pageZone(zone_info, zone);  
                //if (!ret) return false;     edit 2002.10.01
            }
        }
        return ret;
    }



/**
  * y[W̐
  *
  * @param  PageInfo    page_info       y[W
  * @return boolean true() / false (s)
  */
    private boolean generatePage(ZoneInfo zone, PageInfo page) throws RidException, Exception {

        boolean ret = true;
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        //t@C̑݊mF
        String out = web2SeparatorChar(pr_htmlDir + File.separator + page.file);
        if (!xc.fileExists(out)) {

            // fBNgpX擾A݃`FbNs edit 2002.10.01
            String dir_name = out.substring(0, out.lastIndexOf(File.separatorChar));
            if (xc.fileExists(dir_name)){
                // Templatet@C擾
                String template = getPageTemplate(zone);
            
                //f[^̐
                Document data = generatePageData(page);

                // HTML̐@Mapper {template + date ==> out} 
                Mapper mapper = new Mapper();
                ret = mapper.Type2(template, data, out);
                if(!ret)  ZDebug.trace(ridMsg.Warning("W4001", out));

                //e|̃ev[gt@C̏ꍇ폜
                if (template.indexOf(puTemplPage) == -1) {
                    File  fTemp = new File(template);
                    fTemp.delete();
                }

                /* t@C̐ɐꍇAExist Agr[g true
                 * ɂB
                 *  t3-nishimura@nri
                 */
                if (xc.fileExists(out)) {
                    page.element.attribute("Exist", "true");
                }
            }
        }
        return ret;
    }

/**
  * Webn̋؂蕶u^vVXeftHgɕϊ
  *
  * @param  String      file            
  * @return ϊ̕
  */
    public String web2SeparatorChar(String file) {
        return file.replace('/', File.separatorChar);
    }

/**
  * f[^f[^̐
  *
  * @param  PageInfo    page            y[W
  * @return void
  *
  * <RidProject>
  *   <>l</>
  *   ...
  * </RidProject>
  */
    private Document generatePageData(PageInfo page) throws RidException, Exception {

        XmlUtil xu = new XmlUtil();

        // Document
        Document doc = new org.apache.xerces.dom.DocumentImpl();
        Element topElem = doc.createElement(puRootTag);
        doc.appendChild(topElem);

        // PageUnit̑So
        for ( int i = 0; i < page.attr_lst.size(); i++ ) {
            Attribute attr = (Attribute)page.attr_lst.elementAt(i);
            xu.createOrSetTextValue(topElem, attr.name, attr.value);
        }

        //<Rid_Progress>^Ȍo

        // Rid_Progress̑ꗗ擾
        ZProperties prop  = DocManager.loadProperty( DocManager.ELEMENT );
        String[] attrs = ZString.tokenize(prop.getProperty("RidProgress.attributes"));
        String ridProgress;
        String attrName;
        String attrValue;

        
        // 擾
        ridProgress = "<rid_progress";
        for (int n = 0 ; n < attrs.length ; n++) {
            attrName = attrs[n];
            attrValue = "";
            for ( int i = 0; i < page.attr_lst.size(); i++ ) {
                Attribute attr = (Attribute)page.attr_lst.elementAt(i);

                if (attrName.compareTo(attr.name) == 0) {
                    attrValue = attr.value;
                    break;
                }
            }
            ridProgress = ridProgress + " " + attrName.toLowerCase() + "=\"" + attrValue + "\"";
        }
        ridProgress = ridProgress + ">";

        xu.createOrSetTextValue(topElem, "RidProgress", ridProgress);
        return doc;
    }


/**
  * y[W̃ev[gt@C擾
  *
  * Zone[template1]/[template2]Ɏw肳Ă
@* ev[gt@C𑫂ăev[gt@CƂ
@* AA [template1]/[template2]w肳ĂȂꍇ̓ftHg_page.htmlƂ
  * @param  ZoneInfo    zone            y[W
  * @return String      ev[gt@C
  */
    private String getPageTemplate(ZoneInfo zone) throws RidException, Exception {

        String template;
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        // template1/2w肳ĂȂꍇ́AftHg_page.htmlgp
        if (isNullString(zone.template1) && isNullString(zone.template2)) {
            //template1template2ݒ肳ĂȂꍇ
            template = pr_templateDir + File.separator + puTemplPage;
        } else {
            //e|[t@C𐶐AIɍ폜
            File tempf = File.createTempFile("_ridTmp",null, new File(pr_partsDir));
            template = tempf.getAbsolutePath();

            //t@CI[v
            FileOutputStream outFileStream = new FileOutputStream(template);
            OutputStreamWriter outWriter = new OutputStreamWriter(outFileStream);

            //ev[gP
            if (!isNullString(zone.template1)){
                String temp1 = pr_partsDir + File.separator + zone.template1;
                //t@C̑݊mF
                if(xc.fileExists(temp1)) {
                    String temp1String = file2String(temp1);
                    outWriter.write(temp1String, 0, temp1String.length());
                } else {
                    ZDebug.trace(ridMsg.Warning("W4002",temp1));
                }
           }

            //ev[gQ
            if (!isNullString(zone.template2)){
                String temp2 = pr_partsDir + File.separator + zone.template2;
                //t@C̑݊mF
                if(xc.fileExists(temp2)) {
                    String temp2String = file2String(temp2);
                    outWriter.write(temp2String, 0, temp2String.length());
                } else {
                    ZDebug.trace(ridMsg.Warning("W4002",temp2));
                }
            }
            outWriter.close();
        }
        return template;
    }


/**
  * t@C̓ePoCgǂ݁AString^ɕϊ
  *
  * @param  String      file_name       t@C
  * @return String      t@C̓e
  */
    private String file2String(String file_name) throws RidException, IOException {

        String fileString = "";
        char str[]=new char[256];

        try{
            FileInputStream inFileStream = new FileInputStream(file_name);
            InputStreamReader InData=new InputStreamReader(inFileStream);
            while ((InData.read(str, 0, 1)) != -1) {
                fileString = fileString + str[0];
            }
            InData.close();
        }
        catch(IOException e){
            throw new RidException(e.getMessage());
        }
        return fileString;
   }

}
