/*
 * @(#)GeneratorDialog
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Generator Dialog
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/08/14
 */
package jp.co.nri.rid.generator;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.File;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import jp.co.nri.rid.environment.*;

/**
 * Rid Generator Dialog
 */

public class GeneratorDialog {

    /** generate.pagevpeB  **/
    final static public String GENERATE_PAGE          = "generate.page";
    /** generate.productvpeB  **/
//    final static public String GENERATE_PRODUCT       = "generate.product";
    /** generate.presentvpeB  **/
//    final static public String GENERATE_PRESENT       = "generate.present";
    /** generate.sitemapvpeB  **/
    final static public String GENERATE_SITEMAP       = "generate.sitemap";
    /** generate.browservpeB  **/
    final static public String GENERATE_BROWSER       = "generate.browser";
    /** generate.browser.execvpeB  **/
//    final static public String GENERATE_BROWSER_EXEC  = "generate.browser.exec";
    /** msg.generate.titlevpeB  **/
    final static public String MSG_GENERATE_TITLE     = "msg.generate.title";
    /** msg.generate.pagevpeB  **/
    final static public String MSG_GENERATE_PAGE      = "msg.generate.page";
    /** msg.generate.generatevpeB  **/
    final static public String MSG_GENERATE_GENERATE  = "msg.generate.generate";
    /** msg.generate.productvpeB  **/
//    final static public String MSG_GENERATE_PRODUCT   = "msg.generate.product";
    /** snapshot.commentvpeB  **/
//    final static public String MSG_GENERATE_PRESENT   = "msg.generate.present";
    /** snapshot.commentvpeB  **/
    final static public String MSG_GENERATE_SITEMAP   = "msg.generate.sitemap";
    /** snapshot.commentvpeB  **/
    final static public String MSG_GENERATE_BROWSER   = "msg.generate.browser";

    /** Cpl  **/
    protected JPanel      mPanel          = null;
    /** uEUs  **/
    protected JCheckBox   mBrowser        = null;
    /** uEUXg  **/
    protected JComboBox   mBrowserLst     = null;
    /** y[Ws  **/
    protected JCheckBox   mPage           = null;
    /** ws  **/
//    protected JCheckBox   mProduct        = null;
    /** ŋs **/
//    protected JCheckBox   mPresent        = null;
    /** TCg}bvs  **/
    protected JCheckBox   mSitemap        = null;
    /** WI{^  **/
//    protected ButtonGroup mGroup          = new ButtonGroup();
    /** WI{^iwj  **/
//    protected JRadioButton mRadioProduct  = null;
    /** WI{^iŋj **/
//    protected JRadioButton mRadioPresent  = null;
    /** WI{^iTCg}bvj  **/
//    protected JRadioButton mRadioSitemap  = null;

    /** s^Cv  **/
//    private static final String[] radioSelected = { "Product", "Present", "Sitemap"};

    /**
      * ftHgRXgN^
      */
      public GeneratorDialog() {  }

    /**
      * _CAO
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public boolean show() {

        ZResource res = ZApp.getTheApp().getResource();

        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog gdlg = new EnvDialog(frame, res.getString(MSG_GENERATE_TITLE));

        //CR|[lg
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints label_gbc = createLabelConstraints();
        GridBagConstraints compo_gbc = createComponentConstraints();

        // 
        label_gbc.gridy      = 0;
        label_gbc.gridx      = 0;
        JLabel label = new JLabel(res.getString(MSG_GENERATE_GENERATE));
        mLayout.setConstraints(label, label_gbc);
        mPanel.add( label );

        // `FbN{bNX
        compo_gbc.gridy      = 0;
        compo_gbc.gridx      = 1;
        JPanel panelGenerate = generateCheckBox();
        mLayout.setConstraints(panelGenerate, compo_gbc);
        mPanel.add( panelGenerate );

        //uEU
        label_gbc.gridy      = 1;
        label_gbc.gridx      = 0;
        label = new JLabel(res.getString(MSG_GENERATE_BROWSER));
        mLayout.setConstraints(label, label_gbc);
        mPanel.add( label );

        // uEUXg
        compo_gbc.gridy      = 1;
        compo_gbc.gridx      = 1;
        JPanel panelBrowser  = browserCheckBox();
        mLayout.setConstraints(panelBrowser, compo_gbc);
        mPanel.add( panelBrowser );

        //uEŨWI{^
/*
        compo_gbc.gridy      = 2;
        compo_gbc.gridx      = 1;
        JPanel panelBrowserRB  = browserRadioButton();
        mLayout.setConstraints(panelBrowserRB, compo_gbc);
        mPanel.add( panelBrowserRB );
*/
		
        // [CR|[lg][OK][CENCEL]
        gdlg.setControlPanel(mPanel);

        //{^̐
//        ctlInit();

        //_CAO\i[_j
        gdlg.doModal();

        // []{^ꂽꍇɕύX
        boolean ret = gdlg.isOK();
        if (ret){
            setGenerate();
        }   
        return ret;
    }


    /**
      * @ΏۑIiw^ŋ^TCg}bvj
      * @return JPanel 
      */
    private JPanel generateCheckBox() {

        //
        JPanel panelCB = new JPanel();
        GridBagLayout layoutCB = new GridBagLayout();
        panelCB.setLayout(layoutCB);

        // Layout̍쐬
        GridBagConstraints compo_gbc = createComponentConstraints();

        //y[W`FbN{bNX
        compo_gbc.gridy      = 0;
        compo_gbc.gridx      = 0;
        mPage = createGenerateCheckBox(MSG_GENERATE_PAGE, GENERATE_PAGE);
        layoutCB.setConstraints(mPage, compo_gbc);
        panelCB.add( mPage );

        //w`FbN{bNX
/*
        compo_gbc.gridy      = 0;
        compo_gbc.gridx      = 1;
        mProduct = createGenerateCheckBox(MSG_GENERATE_PRODUCT, GENERATE_PRODUCT);
        layoutCB.setConstraints(mProduct, compo_gbc);
        panelCB.add( mProduct );
*/
		
/*
        //ŋ`FbN{bNX
        compo_gbc.gridy      = 0;
        compo_gbc.gridx      = 2;
        mPresent = createGenerateCheckBox(MSG_GENERATE_PRESENT, GENERATE_PRESENT);
        layoutCB.setConstraints(mPresent, compo_gbc);
        panelCB.add( mPresent );
*/
		
        //TCg}bv`FbN{bNX
        compo_gbc.gridy      = 0;
//        compo_gbc.gridx      = 3;
        compo_gbc.gridx      = 1;
        mSitemap = createGenerateCheckBox(MSG_GENERATE_SITEMAP, GENERATE_SITEMAP);
        layoutCB.setConstraints(mSitemap, compo_gbc);
        panelCB.add( mSitemap );

/*
        //w̃Xi[
        mProduct.addActionListener(
          new ActionListener() {
              public void actionPerformed(ActionEvent e) { ctlProduct(); }
          }
        );
*/
/*
        //ŋ̃Xi[
        mPresent.addActionListener(
          new ActionListener() {
              public void actionPerformed(ActionEvent e) { ctlPresent(); }
          }
        );
*/
		
        //TCg}bṽXi[
/*
        mSitemap.addActionListener(
          new ActionListener() {
              public void actionPerformed(ActionEvent e) { ctlSitemap(); }
          }
        );
*/
        return panelCB;
    }


    /**
      * `FbN{bNX쐬
      * @param  String      res_label     x
      * @param  String      res_selected  \[X
      * @return JCheckBox 
      */
    private JCheckBox createGenerateCheckBox(String res_label, String res_selected) {
        ZResource res = ZApp.getTheApp().getResource();
        boolean selected = res.getBoolean(res_selected);
        String label = res.getString(res_label);
        JCheckBox chk = new JCheckBox(label);
        chk.setSelected(selected);
        return chk;
    }



    /**
      * uEU\@I^ΏۃuEUw
      * @return JPanel 
      */
    private JPanel browserCheckBox() {

        JPanel panelCB = new JPanel();
        GridBagLayout layoutCB = new GridBagLayout();
        panelCB.setLayout(layoutCB);

        // Layout̍쐬
        GridBagConstraints compo_gbc = createComponentConstraints();

        compo_gbc.gridy = 0;
        compo_gbc.gridx = 0;
        mBrowser = createBrowserCheckBox();
        layoutCB.setConstraints(mBrowser, compo_gbc);
        panelCB.add( mBrowser );

        compo_gbc.gridy = 0;
        compo_gbc.gridx = 1;
        compo_gbc.gridheight = 1;
        compo_gbc.gridwidth  = 2;
        mBrowserLst = createBrowserComboBox();
        layoutCB.setConstraints(mBrowserLst, compo_gbc);
        panelCB.add( mBrowserLst );
        
        return panelCB;

    }


    /**
      * uEŨ`FbN{bNX쐬
      */
    private JCheckBox createBrowserCheckBox() {
        ZResource res = ZApp.getTheApp().getResource();
        boolean browser = res.getBoolean(GENERATE_BROWSER);
        JCheckBox chk = new JCheckBox();
        chk.setSelected(browser);
        return chk;
    }

    /**
      * uEŨR{{bNX쐬
      */
    private JComboBox createBrowserComboBox() {

        // Create JComboBox
        JComboBox comboBox = new JComboBox();

        //\[Xt@CuEUR}h̃Xgݒ肷
        ZResource res = ZApp.getTheApp().getResource();
        for ( int i = 1; ; i++ ) {
            String  command = "generate.browser_command." + Integer.toString(i);
            String  browser_command = res.getString(command);
            if (browser_command == null) break;
            //ڂ̒ǉ
            comboBox.addItem(makeObj(browser_command));
        }
        return comboBox;
    }
   
    /**
      * StringObject֕ϊ
      */
    private Object makeObj(final String item)  {
        return new Object() { public String toString() { return item; } };
    }



    /**
      * uEU\@\ΏۑIiw^ŋ^TCg}bvj
      */
/*
    private JPanel browserRadioButton() {

        JPanel panelRB = new JPanel();
        GridBagLayout layoutRB = new GridBagLayout();
        panelRB.setLayout(layoutRB);

        // Layout̍쐬
        GridBagConstraints compo_gbc = createComponentConstraints();

         // WI{^Rg[̐
        ZResource res = ZApp.getTheApp().getResource();
        String browser_exec = res.getString(GENERATE_BROWSER_EXEC);

        //WI{^iwj
        compo_gbc.gridy = 0;
        compo_gbc.gridx = 0;
        mRadioProduct =  new JRadioButton(res.getString(MSG_GENERATE_PRODUCT));
        mGroup.add( mRadioProduct );
        layoutRB.setConstraints(mRadioProduct, compo_gbc);
        panelRB.add( mRadioProduct );
        // I
        if (browser_exec.equals(radioSelected[0])) {
            mRadioProduct.setSelected(true);
        }
        //WI{^iŋj
        compo_gbc.gridy = 0;
        compo_gbc.gridx = 1;
        mRadioPresent =  new JRadioButton(res.getString(MSG_GENERATE_PRESENT));
        mGroup.add( mRadioPresent );
        layoutRB.setConstraints(mRadioPresent, compo_gbc);
        panelRB.add( mRadioPresent );
        // I
        if (browser_exec.equals(radioSelected[1])) {
            mRadioPresent.setSelected(true);
        }
		
        //WI{^iTCg}bvj
        compo_gbc.gridy = 0;
        compo_gbc.gridx = 2;
        mRadioSitemap =  new JRadioButton(res.getString(MSG_GENERATE_SITEMAP));
        mGroup.add( mRadioSitemap );
        layoutRB.setConstraints(mRadioSitemap, compo_gbc);
        panelRB.add( mRadioSitemap );
        // I
        if (browser_exec.equals(radioSelected[2])) {
            mRadioSitemap.setSelected(true);
        }
        return panelRB;
    }
*/
	

    /**
      * [Resource]ݒ
      */
    private void setGenerate() {

        ZResource res = ZApp.getTheApp().getResource();

        /***  ***/
        /* [generate.page]ݒ */
        res.putBoolean(GENERATE_PAGE, mPage.isSelected());

        /* [generate.product]ݒ */
//        res.putBoolean(GENERATE_PRODUCT, mProduct.isSelected());

        /* [generate.present]ݒ */
//        res.putBoolean(GENERATE_PRESENT, mPresent.isSelected());

        /* [generate.sitemap]ݒ */
        res.putBoolean(GENERATE_SITEMAP, mSitemap.isSelected());

        /*** uEU ***/
        /* [generate.browser]ݒ */
        res.putBoolean(GENERATE_BROWSER, mBrowser.isSelected());

        /* [generate.browser_command]ݒ */
        /* I΂ꂽuEŨR}h擾Đݒ肷 */
        int index = mBrowserLst.getSelectedIndex();
        String command = "generate.browser_command." + Integer.toString(index+1);
        res.putString("generate.browser_command", res.getString(command));

        /* [generate.browser_exec]ݒ */
/*
        Enumeration elm = mGroup.getElements();
        int i =0;
        while ( elm.hasMoreElements() ) {
            JRadioButton radio = (JRadioButton)elm.nextElement();
            if ( radio.isSelected() ) break;
            i++;
        }
        res.putString(GENERATE_BROWSER_EXEC, radioSelected[i]);
*/
    }


    /**
      * xpCAEg̍쐬
      */
    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.weightx = 0.0 ;
        gbc.insets  = new Insets(10,10,0,10) ;
        return gbc;
    }


    /**
      * R|[lgpCAEg̍쐬
      */
    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0 ;
        gbc.insets    = new Insets(10,10,0,10) ;
        return gbc;
    }

    /**
      * `FbN{bNX^WI{^̐
      */
/*
    private void ctlInit() {
//        ctlProduct();
//        ctlPresent();
//        ctlSitemap();
    }
*/

    /**
      * w̃`FbN{bNX<br>
      *   IԂ̏ꍇ́A@uEU\̐wFL<br>
      *   IԂ̏ꍇ́AuEU\̐wF<br>
      */
/*
    private void ctlProduct() {
        if (mProduct.isSelected()) {
            mRadioProduct.setEnabled(true);
            mRadioProduct.setSelected(true);
        } else {
            mRadioProduct.setEnabled(false);
        }
        //uEU\̐
        ctlBrowser();       
    }
*/
	
    /**
      * ŋ̃`FbN{bNX<br>
      *   IԂ̏ꍇ́A@uEU\̎ŋFL<br>
      *   IԂ̏ꍇ́AuEU\̎ŋF<br>
      */
/*
    private void ctlPresent() {
        if (mPresent.isSelected()) {
            mRadioPresent.setEnabled(true);
            mRadioPresent.setSelected(true);
        } else {
            mRadioPresent.setEnabled(false);
        }
        //uEU\̐
        ctlBrowser();       
    }
*/
	
    /**
      * TCg}bṽ`FbN{bNX<br>
      *   IԂ̏ꍇ́A@uEU\̃TCg}bvFL<br>
      *   IԂ̏ꍇ́AuEU\̃TCg}bvF<br>
      */
/*
    private void ctlSitemap() {
        if (mSitemap.isSelected()) {
            mRadioSitemap.setEnabled(true);
            mRadioSitemap.setSelected(true);
        } else {
            mRadioSitemap.setEnabled(false);
        }
        //uEU\̐
        ctlBrowser();       
    }
*/
    /**
      * uEŨ`FbN{bNX^Xg̐<br>
      *   w^ŋ^TCg}bv̉ꂩȈꍇA@@uEŨ`FbN{bNX^XgFL<br>
      *   w^ŋ^TCg}bv̉ꂩȈꍇA@uEŨ`FbN{bNX^XgF<br>
      */
    private void ctlBrowser() {
//        if (mProduct.isSelected() || mPresent.isSelected() || mSitemap.isSelected()) {
        if (mSitemap.isSelected()) {
            mBrowser.setEnabled(true);
            //mBrowser.setSelected(true);
            mBrowserLst.setEnabled(true);
        } else {
            mBrowser.setEnabled(false);   
            mBrowser.setSelected(false);
            mBrowserLst.setEnabled(false);
        }
    }
}
