/*
 * @(#)MapperBase.java
 *
 * RID-X : Mapper
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/15
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */

package jp.co.nri.rid.mapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import java.util.Vector;

import org.w3c.dom.*;
import org.xml.sax.InputSource;

import jp.co.iti.fagot.doc.DocManager;

import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

/**
  * Mapper ̃x[XNX
  **/
public class MapperBase {
    /** Map̃NX **/
    class MapItem {
        String  srcTag;
        String  srcKey;
        String  dataTag;
        String  dataKey;
        String  inTag;
        String  outAttr;
    }

    /** DatãNX  **/
    class DataItem {
        String  tagName;
        String  keyName;
        String  outAttr;
        String  inData;
        Vector  mapData_lst;
    }

    /** ^ONX  **/
    class TagItem {
        String  tagName;
        String  keyName;
        String  tagString;
        int     sPos;
        int     ePos;
    }

    /** MapRepeat^ÕNX **/
    class MapRepeat {
        String  name;
        Vector  mapData;
    }


    /** MapDatãNX **/
    class MapData {
        String  name;
        String  data;
    }


    public MapperBase() {}


/**
  * Xml@Filep[XADocument߂
  *
  * @param  String      xml_file        XMLt@C
  * @return Document
  */
    public Document xmlFile2Document(String xml_file) throws Exception {

        Document document = null;
        // Parse
        org.apache.xerces.parsers.DOMParser
            parser = new org.apache.xerces.parsers.DOMParser();
        parser.setFeature("http://xml.org/sax/features/validation", true);
        //{̧ٖΉ
        InputSource in = DocManager.createInputSource(xml_file);
        parser.parse(in);

        //hLgIuWFNg
        document = parser.getDocument();
        return document;
    }



/**
  * Xml@Filep[XARootElemen߂
  *
  * @param  String      xml_file        XMLt@C
  * @param  String      roor_element    [gGg
  * @return Element
  */
    public Element xmlFile2RootElement(String xml_file, String roor_element) throws Exception {

        Document doc = null;
        Element root_elem = null;

        // MAP XML t@CDOMɕϊ
        doc = xmlFile2Document(xml_file);

        //
        if(doc != null) {
            //[g̃Gg擾
            root_elem = doc.getDocumentElement();
            if (!checkRootElement(root_elem, roor_element)) {
                return null;
            }
            return root_elem;
        }
        return null;
    }

/**
  * XMLt@CRIDpXMLt@CA[g^OŃ`FcNs
  *
  * @param  Element     root_elem       [gGg
  * @param  String      root_tag        [g^O
  *
  * @return boolean true / false
  */
    public boolean checkRootElement(Element root_elem, String root_tag)  {

        if ( root_elem.getNodeName().compareTo(root_tag) != 0 ) {
            return false;
        }
        return true;
    }


/**
  * HTML Parser
  *     ^O͂āA^OIuWFNg̔ziVectorj߂
  *
  * @param  String      filename        HTMLt@C
  * @param  Vector      tmpEl           Template Element
  * @return void
  */
    public boolean htmlParser(String filename, Vector mLstTag) throws Exception {

        boolean ret = false;

        boolean intag = false;        // ^O̒=trueA^O̊O=false
        int pos = 0;                  // t@C̈ʒu
        int start = 0;                // ^OJnʒu
        int end = 0;                  // ^OIʒu
        char str[] = new char[256];   // BUFF
        String data = "";             // ^O̓e

        InputStreamReader InData = new InputStreamReader(new FileInputStream(filename));

        // HTMLt@C1ǂݍ݁A͂
        while ((InData.read(str,0,1))!=-1){
            if (!intag) {
                if (str[0] == '<'){
                    intag = true;           //^O̊Jnʒuo
                    start = pos;            //Jnʒu
                    data = data + str[0];   //Rs[
                }
            } else {
                data = data + str[0];       //Rs[
                if (str[0] == '>') {
                    intag = false;          //HTML^O̒ȂA^ȌIʒuo
                    end = pos;              //Iʒu

                    TagItem item = new TagItem();
                    item.tagString  = data;
                    item.sPos       = start;
                    item.ePos       = end;
                    mLstTag.add(item);
                    data = "";
                    start = 0;
                    end = 0;
                }
            }
            pos++;
        }
        InData.close();
        return true;
    }



/**
  * w肳ꂽ̒l擾
  *
  * @param  String      tag             ^O̕
  * @param  String      name            
  * @return String      l
  */
    public String getAttrValue(String tag, String name) {

        String  retValue = "";
        int     pos = -1;
        int     sPos = -1;
        char    eChar = ' ';

        String buff = tag.toUpperCase();

        if ((pos = buff.indexOf(name.toUpperCase())) != -1) {
            buff = tag.substring(pos + name.length());

            // ÕXy[X폜
            buff = buff.trim();

            // 擪[=]f
            if (buff.charAt(0) == '=') {
                boolean inquote = false;
                int ind = 1;
                while (ind < buff.length()) {
                    char ch = buff.charAt(ind);
                    // Value
                    if (!inquote) {
                        // "́AXy[XłȂłȂꍇ
                        if (ch == '"' || ch !=' ') {
                            inquote = !inquote;
                            if (ch == '"') {
                                eChar = '"';
                                sPos = ind + 1;
                            } else if (ch != ' ') {
                                if (ch == '\'') {
                                    eChar = '\'';
                                    sPos = ind + 1;
                                } else {
                                    eChar = ' ';
                                    sPos = ind;
                                }
                            }
                        }
                    } else {
                        if (ch == eChar) break;
                    }
                    ind++;

                }
                retValue = buff.substring(sPos, ind);
            }
        }
        return retValue;
    }

/**
  * w肳ꂽt@C݂邩ǂAǂݍ݉\ǂmF
  *
  * @param  String      filename        t@C
  *
  * @return boolean true(݂) / false (݂Ȃ)
  */
    public boolean isFile(String filename) {

        File file = new File(filename);

        if (!file.exists() || !file.isFile()) {
            return false;
        }
        return true;
    }

/**
  * pX̋؂蕶"/"ɕϊ
  *
  * @param  String      navitePath      pX
  * @return void
  */
    public String replaceWebSeparator(String path) {
        return path.replace(File.separatorChar, '/');
    }

}
