/*
 * @(#)MapperType3.java
 *
 * RID-X : Mapper
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/15
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */

package jp.co.nri.rid.mapper;

import java.io.*;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.w3c.dom.*;
import org.apache.xpath.XPathAPI;

import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.*;


import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;


/**
 * Mapper(Type3)
 */
public class MapperType3 extends MapperBase {

    //
    private static String pr_errorString;   // G[bZ[W

    /*@ROOT@ELEMENT̒`FRID@*/
    /** RidProject̒` **/
    private static final String ROOT_ELEMENT  = "RidProject";
    /** MapAttr̒` **/
    private static final String MAP_ATTR      = "MapAttr";
    /** MapAttrData̒` **/
    private static final String MAP_ATTR_DATA = "MapAttrData";
    /** Rid_Tmp̒` **/
    private static final String RID_TMP       = "Rid_Tmp";
    /** MapData̒` **/
    private static final String MAPDATA       = "MapData";

    /*@̒`@*/
    /** srcTag̒` **/
    private static final String SRC_TAG       = "srcTag";
    /** srcKey̒` **/
    private static final String SRC_KEY       = "srcKey";
    /** dataTag̒` **/
    private static final String DATA_TAG      = "dataTag";
    /** dataKey̒` **/
    private static final String DATA_KEY      = "dataKey";
    /** inTag̒` **/
    private static final String IN_TAG        = "inTag";
    /** outAttr̒` **/
    private static final String OUT_ATTR      = "outAttr";
    /** name̒` **/
    private static final String NAME          = "name";


/**
  * RXgN^
  *
  */
    public MapperType3() {
        //NA
        pr_errorString = "";
    }


/**
  * (Mapper_Type3)
  *
  * ev[gt@CiHTML)<MapRepeat>^O
@* DATAhLg̒lɒuāAw肳ꂽt@Cɏo͂
  * <MapRepeat>---</MapRepeat>JԂ\
  *
  * @param  String      in_file         INPUTt@C   (HTML`)
  * @param  Document@  data_doc        DATAhLg(XML `)
  * @param  String      out_file        OUTPUTt@C  (HTML`)
  *
  * @return boolean     true() / false (s)
  */
    public boolean Type3(String in_file,  Document data_doc, String out_file) throws RidException {

        boolean ret = false;
        Vector  data_lst = new Vector();
        RidMessage ridMsg = new RidMessage();

        try{
            //t@CL
            if (checkFile(in_file)) {
                //DATAhLg̉
                ret = type3DataDomParser(data_doc, data_lst);
                if (ret) {
                    //
                    ret = type3Generate(in_file, data_lst, out_file);
                }
            }
            //C[Wt@C̃Rs[
            if (ret){
              MapperResource  mr = new MapperResource();
              mr.imageFileCopy(in_file, out_file);
            }
        }
        catch(Exception e){
            String err_msg = ridMsg.Error("E4002"," (Mapper) " + e.getMessage());
            if (err_msg.indexOf("Filename too long") != -1) {
                err_msg =  ridMsg.Error("E4003"," (Mapper) " + e.getMessage());
            }
            throw new RidException(err_msg);
        }
        return ret;
    }


/**
  * (Mapper_Type3)
  * f[^hLg̉
  *
  * @param  Document    data_doc        hLg
  * @param  Vector      data_lst        DataItemNX̔z
  *
  * @return boolean     true() / false(s)
  */
    public boolean type3DataDomParser(Document data_doc, Vector data_lst) throws Exception {


        XmlUtil xu = new XmlUtil();
        boolean ret = false;

        // f[^XMLt@C̃[gGg擾
        Element root_elem = root_elem = data_doc.getDocumentElement();
        if (!checkRootElement(root_elem, ROOT_ELEMENT)) {
            String msg = "Root element name is different.";
            setErrorString(msg);
            root_elem = null;
        }

        // f[^
        if(root_elem != null) {
            //SẴ^ÕXg擾
            NodeList data_elem_lst = XPathAPI.selectNodeList(root_elem, "*");
            for (int i =0; i < data_elem_lst.getLength(); i++) {
                Vector map_lst = new Vector();
                Element data_elem = (Element)data_elem_lst.item(i);

                //SĂMAPDATA擾(Xg쐬)
                NodeList attr_elem_lst = XPathAPI.selectNodeList(data_elem, "*");
                for (int n =0; n < attr_elem_lst.getLength(); n++) {
                    Element attr_elem = (Element)attr_elem_lst.item(n);
                    MapData map = new MapData();
                    map.name  = attr_elem.getNodeName();
                    map.data  = xu.getTextValue(attr_elem);
                    map_lst.add(map);
                }

                // ADD Data List
                DataItem data = new DataItem();
                data.tagName      = data_elem.getNodeName();
                data.mapData_lst  = map_lst;
                data_lst.add(data);
            }
            ret = true;
        }
        return ret;
    }


/**
  * (Mapper_Type3)
  * Type3 
  *
  * @param  String      in_file         ̓t@C
  * @param  Vector      data_lst        f[^iDataItem̔zj
  * @param  String      out_file        o̓t@C
  * @return boolean     true() / false(s)
  */
    private boolean type3Generate(String in_file, Vector data_lst, String out_file)  throws Exception{

        boolean ret = false;
        char str[]=new char[256];

        // ̓t@C}bṽ^O񂾂ʂ
        Vector repeatTag_lst = new Vector();
        inRepeatFileParser(in_file, repeatTag_lst);

        // INPUTt@C̃I[v
        InputStreamReader InData = new InputStreamReader(new FileInputStream(in_file));

        // OUTOUTt@C̃I[v
        OutputStreamWriter outWriter = new OutputStreamWriter(new FileOutputStream(out_file));

        int pos = 0;
        for ( int n = 0; n < repeatTag_lst.size(); n ++ ) {
            TagItem repeatTag = (TagItem)repeatTag_lst.elementAt(n);

            // <MapRepeat>^O̍ŏ̈ʒu܂ŏo͂
            while ((InData.read(str, 0, 1)) != -1) {
                if (pos < repeatTag.sPos) {
                    outWriter.write(str, 0, 1);
                } else {
                    pos++;
                    break;
                }
                pos++;
            }
            
            // <MapRepeat>...</MapRepeat>^Õs[g͈͂u
            String grpeatStrin = getRepeatString(repeatTag, data_lst);
            outWriter.write(grpeatStrin, 0, grpeatStrin.length());

            // </MapRepeat>^O܂łǔ΂
            while ((InData.read(str, 0, 1)) != -1) {
                if (pos < repeatTag.ePos) {
                    //ǂݔ΂
                } else {
                    pos++;
                    break;
                }
                pos++;
            }
        }
        // Ō܂œǍ
        while ((InData.read(str, 0, 1)) != -1) {
          outWriter.write(str, 0, 1);
        }

        // t@CN[Y
        InData.close();
        outWriter.close();

        return true;
   }



/**
  * (Mapper_Type3)
  * w肳ꂽAHTMLt@C̊JnʒuIʒu܂łStringŖ߂
  *
  * @param  String      in_file         HTMLt@C
  * @param  int         sPos            Jnʒu
  * @param  int         ePos            Iʒu
  *
  * @return String      w肵͈͂̕
  */
    public String getRepeat(String in_file, int sPos, int ePos) throws Exception{

        String repeatString = "";
        char str[] = new char[256];

        InputStreamReader InData = new InputStreamReader(new FileInputStream(in_file));
        int pos = 0;
        while ((InData.read(str, 0, 1)) != -1) {
            //Jnʒu܂œǂݔ΂
            if (pos >= sPos) {
                //Iʒu܂œǂݍ
                if (pos <= ePos) {
                    repeatString = repeatString + str[0];
                }
            }
            pos++;
        }
        InData.close();

        return repeatString;
   }

/**
  * (Mapper_Type3)
  * <MapRepeat>^O{MapData}f[^Œu
  *
  * @param  TagItem     repeatTag       s[g^O
  * @param  Vector      data_lst        f[^iDataItem̔zj
  * @return String      s[g
  */
    private String  getRepeatString(TagItem repeatTag, Vector data_lst) {

        // Repeat̃^O
        String repeatString = "";
        String buff = "";

        //O<MapRepeat>^O폜
        // begin-<MapRepeat>^ȌIend-<MapRepeat>̎n܂܂łRs[
        // 
        // <MapRepeat name="PresentData">
        //   {MapData name="linkStart"}<img src="img/Showmode.gif" alt="ŋ" height="27" width="27" border="0">{MapData name="linkEnd"}
        // </MapRepeat>
        buff = repeatTag.tagString.substring(repeatTag.tagString.indexOf(">") + 1, repeatTag.tagString.lastIndexOf("<"));

        // Repeat񂩂{MapData}^O
        Vector mapTag_lst = new Vector();
        mapDataParser(buff, mapTag_lst);

        // dataloop
        for ( int m = 0; m < data_lst.size(); m ++ ) {
            DataItem data = (DataItem)data_lst.elementAt(m);
            
            // <MapRepeat>  nameƓDatał邱
            if (repeatTag.keyName.compareToIgnoreCase(data.tagName) == 0) {
                int pos = 0;
                //{MapData}loop
                // {MapData}dataɒu
                for ( int n = 0; n < mapTag_lst.size(); n ++ ) {
                    TagItem tag = (TagItem)mapTag_lst.elementAt(n);
                    repeatString = repeatString + buff.substring(pos, tag.sPos);
                    for ( int i = 0; i < data.mapData_lst.size(); i ++ ) {
                        MapData map = (MapData)data.mapData_lst.elementAt(i);
                        if (map.name.compareToIgnoreCase(tag.keyName) == 0) {
                            repeatString = repeatString + map.data;
                        }
                    }
                    pos = tag.ePos + 1;
                }
                repeatString = repeatString + buff.substring(pos);
            }
        }
        return repeatString;
    }



/**
  * (Mapper_Type3)
  * <MapRepeat>^O̕񂩂A{...}^O͂
@* {MapData}^OɂA{MapData}Name̒lZbg
  *
  * @param  String      repeat          <MapRepeat>^O̕
  * @param  Vector      data_lst        DataItemNX̔z
  *
  * @return void
  */
    private void mapDataParser(String repeat, Vector inTag_lst) {

        //in_file@Parser
        Vector tag_lst = new Vector();
        htmlStringParser(repeat, tag_lst);

        // HTML^O̔z񂩂AMapItemsrcTag^O𔲏o
        for (int n = 0; n < tag_lst.size(); n ++ ) {
            // {MapData}^O̎擾
            TagItem htmlTag = (TagItem)tag_lst.elementAt(n);

            //啶ɕϊ
            String tagStringUp  = htmlTag.tagString.toUpperCase();
            String srcTagUp     = "{" + MAPDATA.toUpperCase();

            //啶ɕϊA{MAPDATA}f
            if (tagStringUp.indexOf(srcTagUp) != -1) {

                //Name̒l擾
                String srcKey = getAttrValue(htmlTag.tagString, NAME);

                //Namêǉ
                if (srcKey != ""){
                  TagItem srcTag = new TagItem();
                  srcTag.tagName     = MAPDATA;
                  srcTag.keyName     = srcKey;
                  srcTag.tagString   = htmlTag.tagString;
                  srcTag.sPos        = htmlTag.sPos;
                  srcTag.ePos        = htmlTag.ePos;
                  inTag_lst.add(srcTag);
                }
            }
        }
  }


/**
  * (Mapper_Type3)
  *     HTML̕񂩂A{ ... }^OATagItemNX̔z߂
  *
  * @param  String      html            HTMLt@C
  * @param  Vector      tmpEl           Template Element
  * @return void
  */
    public boolean htmlStringParser(String html, Vector mLstTag) {

        boolean intag = false;        // ^O̒=trueA^O̊O=false
        int pos = 0;                  // t@C̈ʒu
        int start = 0;                // ^OJnʒu
        int end = 0;                  // ^OIʒu
        String data = "";             // ^O̓e

        // HTMLt@C1ǂݍ݁A͂
        for (int i = 0; i < html.length(); i ++ ) {
            if (!intag) {
                if (html.charAt(i) == '{'){
                    intag = true;           //^O̊Jnʒuo
                    start = pos;            //Jnʒu
                    data = data + html.charAt(i);   //Rs[
                }
            } else {
                data = data + html.charAt(i);       //Rs[
                if (html.charAt(i) == '}') {
                    intag = false;          //HTML^O̒ȂA^ȌIʒuo
                    end = pos;              //Iʒu

                    TagItem item = new TagItem();
                    item.tagString  = data;
                    item.sPos       = start;
                    item.ePos       = end;
                    mLstTag.add(item);
                    data = "";
                    start = 0;
                     end = 0;
                }
            }
            pos++;
        }
        return true;
    }



/**
  * (Mapper_Type3)
  * ̓t@C}bṽ^O񂾂ʂ
  *
  *     <MAPREPEAT> .... </MAPREPEAT>
  *
  * @param  String      in_file         HTMLt@C
  * @param  Vector      inTag_lst       }bṽXg
  *
  * @return void
  */
     private void inRepeatFileParser(String in_file, Vector inTag_lst) throws Exception{

        String startTag = "<MAPREPEAT";
        String endTag   = "</MAPREPEAT";

        //in_file@Parser
        Vector tag_lst = new Vector();
        htmlParser(in_file, tag_lst);

        // START TAG
        for (int n = 0; n < tag_lst.size(); n ++ ) {
            int ePos=0;

            // HTML^O̎擾
            TagItem sTag = (TagItem)tag_lst.elementAt(n);

            //啶ɕϊ
            String startTagUp  = sTag.tagString.toUpperCase();

            // 擪
            if (startTagUp.indexOf(startTag) != -1) {

                String name = getAttrValue(sTag.tagString, "name");
                ePos  = sTag.ePos;
                // END TAG
                for (int m = n; m < tag_lst.size(); m ++ ) {

                    // HTML^O̎擾
                    TagItem eTag = (TagItem)tag_lst.elementAt(m);

                    //啶ɕϊ
                    String endTagUp  = eTag.tagString.toUpperCase();

                    // 擪
                    if (endTagUp.indexOf(endTag) != -1) {
                        ePos = eTag.ePos;
                        break;
                    }
                }
                TagItem srcTag = new TagItem();
                srcTag.tagName     = "MAPREPEAT";
                srcTag.keyName     = name;
                srcTag.sPos        = sTag.sPos;
                srcTag.ePos        = ePos;
                srcTag.tagString   = getRepeat(in_file, srcTag.sPos, srcTag.ePos);
                inTag_lst.add(srcTag);
            }
      }
  }


/**
  * t@C݂邩ǂAǂݍ݉\ǂmF
  *
  * @param  String      in_file         Lt@C
  *
  * @return boolean     true(݂) / false (݂Ȃ)
  */
    public boolean checkFile(String in_file) {

        boolean ret = true;

        if (!isFile(in_file)) {
            String msg = "no such source file: \"" + in_file + "\"";
            setErrorString(msg);
            ret =  false;
        }
        return ret;
    }


/**
  * G[bZ[W̐ݒ
  *
  * @param  String      errorString     G[bZ[W
  * @return void
  */
    private void setErrorString(String errorString) {
        pr_errorString = errorString;
    }

/**
  * G[bZ[W̎擾
  *
  * @return String      G[bZ[W
  */
    public String getErrorString() {
        return pr_errorString;
    }

}