package jp.co.nri.rid.search;

import java.awt.Component;
import java.awt.Color;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;

/** ʕ\e[ůeZ renderer */
class SPCellRenderer extends DefaultTableCellRenderer {
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPCellRenderer.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPCellRenderer.java,v 1.4 2003-07-07 21:03:33+09 nsmr Exp $";

    int target;


    /* RXgN^ */
    SPCellRenderer(int target) {
        super();
        this.target = target;
    }


    /** DefaultTableCellRenderer.getTableCellRendererComponent()
     *  ̃I[o[Ch
     */
    public Component getTableCellRendererComponent(JTable table, Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus, int row,
                                                   int column) {
        JTextField field = new JTextField(value.toString());
        /* FȂA 1 sNZ̃{[_AeZɂ */
        field.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1,
                                                                    1));

        int columnIndex = table.convertColumnIndexToModel(column);
        int columnID = SPColumnNames.getColumnID(target, columnIndex);

        /* ^̃JȂE */
        if (SPTableColumnModel.isIntegerColumn(columnID)) {
            field.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        }
 
        /* IԂȂAwiFύX */
        if (isSelected) {
            field.setBackground(table.getSelectionBackground());
            return field;
        }

        if (!(table.getModel() instanceof SPTableModel)) {
            return field;
        }


        SPTableModel tableModel = (SPTableModel)table.getModel();

        if (row < 0 && tableModel.resultVector.size() <= row) {
            return field;
        }

        if (tableModel.resultVector == null) {
            return field;
        }

        Object o = tableModel.resultVector.elementAt(row);
        if (!(o instanceof SPElementAndStrings)) {
            return field;
        }

        SPElementAndStrings rowObject = (SPElementAndStrings)o;
        if (rowObject.colors == null) {
            return field;
        }

        if (column < 0 || rowObject.colors.length <= column) {
            return field;
        }

        if (rowObject.colors[column] != null) {
            field.setBackground(rowObject.colors[column]);
        }
        return field;
    }
} /* class SPCellRenderer */
