package jp.co.nri.rid.search;

/* misc */
import java.util.Comparator;

/* Rid */
import jp.co.nri.rid.xml.elementBooster;


public class SPElementComparator implements Comparator{
    /** \[gΏۂ̃Agr[g */
    private String targetAttribute = null;

    /** \[gΏۂ̃J */
    private int targetColumn = 1;

    /** \[g̏ (: 1, ~; -1) */ 
    private int sortOrder;

    /** int ^Ƃ݂Ȃă\[gtO */ 
    private boolean intMode;


    /**
     * @param attribute \[gΏۂ̃Agr[g
     * @param order \[g̏ (: 1, ~; -1)
     * @param isInteger int ^Ƃ݂Ȃă\[gtO
     */ 
    public SPElementComparator(String attribute, int order, boolean isInt){
        targetAttribute = attribute;
        sortOrder = order;
        intMode = isInt;
    }


    /**
     * @param attribute \[gΏۂ̃Agr[g
     * @param order \[g̏ (: 1, ~; -1)
     * @param isInteger int ^Ƃ݂Ȃă\[gtO
     */ 
    public SPElementComparator(int column, int order, boolean isInt){
        targetColumn = column;
        sortOrder = order;
        intMode = isInt;
    }


    public int compare(Object a ,Object b){
        if (!(a.getClass().equals(b.getClass()))) {
            return 0;
        }

        String valueA = getKeyValue(a);
        String valueB = getKeyValue(b);

        if (valueA == null && valueB == null) {
            return 0;
        }
        if (valueA == null) {
            return -1 * sortOrder;
        }
        if (valueB == null) {
            return sortOrder;
        }

        if (intMode) {
            try {
                int intA, intB;
                intA = Integer.parseInt(valueA);
                intB = Integer.parseInt(valueB);
                return (intA - intB) * sortOrder;
            } catch (NumberFormatException e) {
                ;
            }
        }

        return sortOrder * valueA.compareTo(valueB);
    } /* compare */


    String getKeyValue(Object o) {
        if (o == null) {
            return null;
        }

        String[] strings = null;
        elementBooster element = null;

        if (o instanceof SPElementAndStrings) {
            SPElementAndStrings elementAndStrings = (SPElementAndStrings)o;
            strings = elementAndStrings.strings;
            element = elementAndStrings.element;
        } else if (o instanceof String[]) {
            strings = (String[])o;
        } else if (o instanceof elementBooster) {
            element = (elementBooster)o;
        }

        if (strings != null) {
            if (0 <= targetColumn && targetColumn < strings.length) {
                String cell = strings[targetColumn];
                if (cell != null) {
                    return cell;
                }
            }
        }

        if (element != null) {
            if (targetAttribute != null) {
                String cell = element.attribute(targetAttribute);
                if (cell != null) {
                    return cell;
                }
            }
        }

        return null;
    } /* getKeyValue */
} /* class SPElementComparator */
