package jp.co.nri.rid.search;

/* misc */
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

/* Rid */
import jp.co.nri.Rid;
import jp.co.nri.rid.xml.elementBooster;

/**
 * HTML Ƃ̒Ɋ܂܂CC\[X̃oCgvA
 * 傫ɕ\B
 */
class SPTableModelLarge extends SPTableModel{
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPTableModelLarge.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPTableModelLarge.java,v 1.10 2003-08-06 18:29:58+09 nsmr Exp $";

    SPElementStatusHash pageUnitHash;

    /**
     * RXgN^:
     */
    SPTableModelLarge() {
        target = SPTableModel.LARGE;

        /* ʕ\e[ũf[^ */
        resultVector = new Vector();
	    
        /* DOCUMENT_SITE  PaegUnit ׂĎ擾 */
        elementBooster[] pageUnits =
            getElementsFromDocument("PageUnit", Rid.DOCUMENT_SITE);
        if (pageUnits.length == 0) {
            /* y[WȂ΁Aʂ 0  */
            count = 0;
            return;
        }

        /* ݂Ȃy[W pageUnitHash Ɋ܂܂Ȃ */
        pageUnitHash = new SPElementStatusHash(pageUnits, true);

        /* DOCUMENT_RESOURCE  ResourceUnit ׂĎ擾 */
        elementBooster[] resourceUnits =
            getElementsFromDocument("ResourceUnit", Rid.DOCUMENT_RESOURCE);
        SPElementHash resourceUnitHash =
            new SPElementHash(resourceUnits, true);

        /* DOCUMENT_RESOURCE  LinkedPageUnit ׂĎ擾 */
        elementBooster[] linkedPageUnits =
            getElementsFromDocument("LinkedPageUnit", Rid.DOCUMENT_RESOURCE);

        /** 1 s̃f[^܂ޕ̔z */
        String[] rowStrings;

        int[] columnIDs = SPColumnNames.get(target);
        if (columnIDs == null){
            count = -1;
            return;
        }

        /* y[WpĂ郊\[X̃TCYvZ */
        for (int i = 0; i < linkedPageUnits.length; i++) {
            elementBooster linkedPageUnit = linkedPageUnits[i];
            String pageName = linkedPageUnit.attribute("Page");
            if (pageName == null) {
                continue;
            }
            SPElementStatus elementStatus = pageUnitHash.get(pageName, true);
            if (elementStatus == null) {
                continue;
            }
            int resourceSize = elementStatus.getStatus();

            String resource = linkedPageUnit.attribute("Resource");
            if (resource == null) {
                continue;
            }

            elementBooster element = resourceUnitHash.get(resource, true);
            if (element == null) {
                continue;
            }
            resourceSize += getFileSize(element);
            elementStatus.setStatus(resourceSize);
        }


        count = 0;
        for (Enumeration e = pageUnitHash.keys(); e.hasMoreElements();) {
            String fileName = (String)e.nextElement();
            SPElementStatus elementStatus = pageUnitHash.get(fileName);
            elementBooster pageUnit = elementStatus.getElement();

            /* y[WP̂̃t@CTCYvZ */
            int pageSize = getFileSize(pageUnit);

            /* łɌvZς݂́A\[X̍v擾 */
            int resourceSize = elementStatus.getStatus();

            /* sf[^ */
            rowStrings = new String[columnIDs.length];

            /* sɒlݒ */
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.TOTAL,
                                               String.valueOf(resourceSize
                                                              + pageSize));
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.HTML_ONLY,
                                               String.valueOf(pageSize));
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.RESOURCES,
                                               String.valueOf(resourceSize));

            /* 1s̃f[^ǉ */
            resultVector.add(new SPElementAndStrings(pageUnit, rowStrings));
            count++;
        } /* for (Enumeration e = pageUnitHash.keys(); e.hasMoreElements();) */

        /* resultVector  TOTAL L[ɂă\[g */
        int columnOfTotal =
            SPColumnNames.getColumnIndex(target, SPColumnNames.TOTAL);
        if (columnOfTotal != -1) {
            sort(columnOfTotal, false, DESCENDING);
        }
    } /* RXgN^ */


    /**
     * jbg̃t@CTCYԂ
     * @param jbg\vf
     * @return t@CTCY
     */
    int getFileSize(elementBooster element) {
        int fileSize;

        if (element == null) {
            return 0;
        }

        String fileSizeStr = element.attribute("Size");
        if (fileSizeStr == null) {
            return 0;
        }

        try {
            fileSize = Integer.parseInt(fileSizeStr);
        } catch (NumberFormatException e) {
            fileSize = 0;
        }
        return fileSize;
    } /* getFileSize */
} /* class SPTableModelLarge */
