package jp.co.nri.rid.search;

/* misc */
import java.util.Enumeration;
import java.util.Vector;

/* Rid */
import jp.co.nri.Rid;
import jp.co.nri.rid.xml.elementBooster;


/**
 * pĂȂ\[XT
 */
class SPTableModelUnused extends SPTableModel{
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPTableModelUnused.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPTableModelUnused.java,v 1.5 2003-07-17 15:41:42+09 nsmr Exp $";

    /**
     * RXgN^:
     */
    SPTableModelUnused() {
        target = SPTableModel.UNUSED;
        count = 0;

        /* ʕ\e[ũf[^ */
        resultVector = new Vector();

        /* site.xml  PaegUnit ׂĎ擾 */
        elementBooster[] pageUnits =
            getElementsFromDocument("PageUnit", Rid.DOCUMENT_SITE);
        SPElementHash pageUnitHash = new SPElementHash(pageUnits, true);

        /* resource.xml  ResourceUnit ׂĎ擾 */
        elementBooster[] resourceUnits =
            getElementsFromDocument("ResourceUnit", Rid.DOCUMENT_RESOURCE);
        if (resourceUnits == null) {
            return;
        }
        SPElementStatusHash resourceUnitHash =
            new SPElementStatusHash(resourceUnits, true);
        if (resourceUnitHash.size() <= 0) { 
            return;
        }

        /* resource.xml  LinkedPageUnit ׂĎ擾 */
        elementBooster[] linkedPageUnits =
            getElementsFromDocument("LinkedPageUnit", Rid.DOCUMENT_RESOURCE);

        /*
         * LinkedPageUnits STA
         * ꂽ ResourceUnit Ƀ`FbNς݃tO𗧂ĂB
         * AN PageUnit ݂Ȃ΃tO͗ĂȂB
         */
        if (linkedPageUnits != null) {
            for (int i = 0; i < linkedPageUnits.length; i++) {
                /* Qƌ page 擾 */
                String pageName = linkedPageUnits[i].attribute("Page");
                if (pageName == null) {
                    continue;
                }
                /*
                 * Qƌ PageUnit Apage ̎̂΁A
                 *  resource  unused Ƃ݂Ȃ
                 */
                elementBooster pageUnit = pageUnitHash.get(pageName, true);
                if (pageUnit == null) {
                    continue;
                }

                /* QƐ resource 擾 */
                String resource = linkedPageUnits[i].attribute("Resource");
                if (resource == null) {
                    continue;
                }
                SPElementStatus es = resourceUnitHash.get(resource, true);
                if (es == null) {
                    continue;
                }

                /* resource  used tO𗧂Ă */
                es.setStatus(SPElementStatus.DONE);
            }
        }

        /*
         * `FbNς݃tO̗ĂȂ ResourceUnit (= Ǘ\[X) 
         * ̕\
         */
        count = 0;
        for (Enumeration e = resourceUnitHash.keys(); e.hasMoreElements();) {
            String resource = (String)e.nextElement();
            SPElementStatus es = resourceUnitHash.get(resource);
            if (es.getStatus() != SPElementStatus.DONE) {
                resultVector.add(new SPElementAndStrings(es.getElement()));
                count++;
            }
        }
        sort(SPColumnNames.getColumnIndex(target, SPColumnNames.FILE), false);
    } /* RXgN^ */
} /* class SPTableModelUnused */
