/**
 * @(#)RSynchronizer.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Common Panel
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/08/09
 */
package jp.co.nri.rid.synchronizer;

import java.io.*;
import java.util.*;

// W3C DOM
import	org.w3c.dom.*;

import	jp.co.nri.*;
import	jp.co.nri.rid.xml.*;
import	jp.co.nri.rid.importer.*;
import	jp.co.iti.fagot.*;
import	jp.co.iti.fagot.util.*;
import	jp.co.iti.fagot.doc.DocManager;

/**
 * HTMLtH_̃t@C̗L`FbNAPageUnitExistɔfB
 * ۂ̃t@C̑ݏ󋵂PageUnitExsist̓ƂB
 */

public class RSynchronizer{
	private	static final String	UNITS	= ".unit";
	private	static final String	FILE	= "File";
	private	static final String	EXIST	= "Exist";
	private	static final String	TRUE	= "true";
	private	static final String	FALSE	= "false";
	private	static final String	PAGETYPE= "PageType";
	private	static final String	SERVER	= "server";
	private static final String	KEY_DIR	= "rid.html.dir";
	
	public	void	sync(String key ,Element element ,String dirkey){
		// HTML DIR
		File dir = null;
		if(dirkey.equals(KEY_DIR))	dir = new File(Ridual.getHtmlDir());
		else {
			String		projectdir	= ZInstance.prop().getProperty(Rid.PJ_DIR);
			ZResource	res			= ZApp.getTheApp().getResource();
			
			dir	= new File(projectdir ,res.getString(dirkey));
		}
		
		// UNITS
		ZProperties	properties	= DocManager.loadProperty(DocManager.ELEMENT);
		String[]	units		= ZString.tokenize(properties.getProperty(key+UNITS));
		
		elementBooster root = (new elementBooster(element)).child("ZoneUnit");
		
		if(null==root)	return;
		
		int mx = units.length;
		for(int i=0;i<mx;i++)	sync(units[i] ,root ,dir);
	}
	
	private	void	sync(String name ,elementBooster element ,File dir){
		elementBooster[] elements = element.offspring(name);
		if(null==elements)	return;
		
		File file;
		int mx = elements.length;
		for(int i=0;i<mx;i++){
			elementBooster	unit	= elements[i];
			
			if(SERVER.equals(unit.attribute(PAGETYPE)))	continue;
			
			String			fileattr= unit.attribute(FILE);
			if(RIgnoreFiles.ignorefile(fileattr))	continue;
			try{ file = new File(dir ,fileattr); }
			catch(NullPointerException e){ continue; }
			unit.attribute(EXIST ,file.exists() ? TRUE : FALSE);
		}
	}
}
