/**
 * @(#)aUnitTableModel.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : abstract Unit Table Model
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/01/09-2002/03/26
 */
package	jp.co.nri.rid.table;

/* JAVA */
import	java.util.*;
import	javax.swing.table.AbstractTableModel;

/* W3C */
import	org.w3c.dom.Document;

/* rid */
import	jp.co.nri.rid.xml.*;
import	jp.co.nri.rid.table.comparator.*;

/**
 * jbgRTableɕ\邽߂TableModelB
 */

abstract public class aUnitTableModel extends AbstractTableModel{
	/**
	 * w^OUnitWB
	 * @param	tagnames	^Oz
	 * @since	1.00
	 */
	abstract protected void collecting(String[] tagnames);
	
	protected ClmDefs			myClm;
	protected documentBooster	myDocument;
	protected ClmDef[]			myClmDefs;
	protected int				myClmDefCount;
	protected Vector			myElements;
	
	public aUnitTableModel(Document document ,ClmDefs clmdefs){
		myDocument		= new documentBooster(document);
		myClm			= clmdefs;
		myClmDefs		= myClm.ClmDefs();
		myClmDefCount	= myClmDefs.length;
		myElements		= new Vector();
		
		collecting(clmdefs.tagnames());
		
	}
	
	/**
	 * AbstractTableModel̃I[o[ChBZ̕ҏWۂԂB
	 * @param	rowIndex	sCfbNXB
	 * @param	columnIndex	CfbNXB
	 * @return	trueԂB
	 * @since	1.00
	 */
	public boolean isCellEditable(int rowIndex ,int columnIndex){
		return true;
	}
	
	/**
	 * AbstractTableModel̃I[o[ChBsԂB
	 * @return	sB
	 * @since	1.00
	 */
	public int getRowCount(){
		return myElements.size();
	}
	
	/**
	 * AbstractTableModel̃I[o[ChBJB
	 * @param	column	CfbNXB
	 * @return	JB
	 * @since	1.00
	 */
	public String getColumnName(int column){
		return myClmDefs[column].title;
	}
	
	/**
	 * AbstractTableModel̃I[o[ChBJB
	 * @return	JB
	 * @since	1.00
	 */
	public int getColumnCount(){
		return myClmDefCount;
	}
	
	/**
	 * AbstractTableModel̃I[o[ChBZl𓾂B
	 * @param	row		sCfbNXB
	 * @param	column	CfbNXB
	 * @return	ZlB
	 * @since	1.00
	 */
	public Object getValueAt(int row ,int column){
/*		
		elementBooster element = (elementBooster)myElements.elementAt(row);
		if(null==element)	return null;
		
		return element.attribute(myClmDefs[column].name);
*/		
		if("+seq".equals(myClmDefs[column].type)){ return String.valueOf(row); }
		try{
			LineItem line = (LineItem)myElements.elementAt(row);
			return line.cellstring(myClmDefs[column].name);
		}catch(NullPointerException e){ return null; }
	}
	
	/**
	 * AbstractTableModel̃I[o[ChBZlݒ肷B
	 * @param	aValue	ZlB
	 * @param	row		sCfbNXB
	 * @param	column	CfbNXB
	 * @since	1.00
	 */
	public void setValueAt(Object aValue ,int row ,int column){
/*
		if(!(aValue instanceof String))	aValue = null;
		elementBooster element = (elementBooster)myElements.elementAt(row);
		if(null==element)	return;
		
		element.attribute(myClmDefs[column].name ,(String)aValue);
*/		
		LineItem line = (LineItem)myElements.elementAt(row);
		line.cellstring(myClmDefs[column].name ,(String)aValue);
	}
	
	/**
	 * \[gB
	 * @param	column	CfbNXB
	 * @since	1.00
	 */
	public void sort(int column){
		ClmDef def = myClmDefs[column];
		if(def.sorted == ClmDef.ASSENDING)	def.sorted = ClmDef.DISSENDING;
		else								def.sorted = ClmDef.ASSENDING;
		Object[] elements = myElements.toArray();
		Comparator comparator = null;
		
		if(null==def.sorttype)				comparator = new LineItemComparator(def.name ,def.sorted);
		else if("int".equals(def.sorttype))	comparator = new intLineItemComparator(def.name ,def.sorted);
		else if("datetime".equals(def.sorttype))	comparator = new datetimeLineItemComparator(def.name ,def.sorted);
		else								comparator = new LineItemComparator(def.name ,def.sorted);
		
		Arrays.sort(elements ,comparator);
		myElements = new Vector(Arrays.asList(elements));
	}
	
	/**
	 * sɑΉGg擾B
	 * @param	row	sCfbNXB
	 * @return	GgB
	 * @since	1.00
	 */
	public elementBooster element(int row){
//		return (elementBooster)myElements.elementAt(row);
		LineItem line = (LineItem)myElements.elementAt(row);
		return line.element();
	}
	
	
	public elementBooster element(int row ,int col){
		LineItem line = (LineItem)myElements.elementAt(row);
		try{
			return line.cellitem(myClmDefs[col].name).element();
		}catch(NullPointerException e){ return null; }
	}
	
}
