/**
 * @(#)SWFActionRecords.java
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/4
 */
package	jp.co.iti.swf;

import	java.util.*;
import	java.io.*;

/**
 * SWF ACTION TAGActionRecordǗB
 */
class SWFActionRecords{
	private	Vector	myRecords;
	
	public	SWFActionRecords(){ myRecords = new Vector(); }
	public	void	add(int code ,byte[] data) throws SWFActionRecordException{
		SWFActionRecord record;
		switch(code){
			case	SWFActionRecord.GETURL:
				record = new SWFGetURLAction(code ,data);
				break;
			case	SWFActionRecord.PUSH:
				record = new SWFPushAction(code ,data);
				break;
			default:
				record = new SWFActionRecord(code ,data);
		}
		myRecords.add(record);
	}
	
	public	void	readRecords(SWFInputStream instream)
		throws SWFActionRecordsException ,SWFActionRecordException
	{
		try{
			while(true){
				int	code	= instream.readUI8();
				
				if(SWFActionRecord.END == code)	break;
				
				int	length	= 0;
				
				if(0x80 <= code)	length = instream.readUI16();
				
				byte[] recorddata = null;
				if(0 < length){
					recorddata = new byte[length];
					instream.read(recorddata);
				}
				
				add(code ,recorddata);
			}
		}catch(IOException e){ throw new SWFActionRecordsException(); }
	}
	
	public	SWFActionRecord[] getActionRecords(){ return (SWFActionRecord[])myRecords.toArray(new SWFActionRecord[0]); }
}
