/**
 * @(#)SWFMatrix.java
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/4
 */
package	jp.co.iti.swf;

/**
 * SWF BasicTypesMatrix Record\B
 */
public class SWFMatrix implements Cloneable{
	public	boolean	hasScale;
	public	int		scaleX;
	public	int		scaleY;
	public	boolean	hasRotate;
	public	int		rotateSkew0;
	public	int		rotateSkew1;
	public	int		translateX;
	public	int		translateY;
	
	/**
	 * @since	1.00
	 */
	public	SWFMatrix(){}
	
	/**
	 * Rs[RXgN^B
	 * @since	1.00
	 */
	public	SWFMatrix(SWFMatrix org){
		hasScale	=	org.hasScale;
		scaleX		=	org.scaleX;
		scaleY		=	org.scaleY;
		hasRotate	=	org.hasRotate;
		rotateSkew0	=	org.rotateSkew0;
		rotateSkew1	=	org.rotateSkew1;
		translateX	=	org.translateX;
		translateY	=	org.translateY;
	}
	
	/**
	 * ̃CX^X̃N[B
	 * @return	̃CX^X̃N[B
	 * @since	1.00
	 */
	public	Object	clone(){ return new SWFMatrix(this); }
	
	/**
	 * ̃CX^X̕\𓾂B
	 * @return	̃CX^X̕\B
	 * @since	1.00
	 */
	public String toString(){
		return "hasScale="+hasScale+" scaleX="+scaleX+" scaleY="+scaleY
		+" hasRotate="+hasRotate+" rotateSkew0="+rotateSkew0
		+" rotateSkew1="+rotateSkew1+" translateX="+translateX+" translateY="+translateY;
	}
}
