#include "ring.h"

/* Copyright (c) 2022 Mahmoud Fayed <msfclipper@yahoo.com> */

#include "cjson_extension/cJSON.h"
#include "cjson_extension/cJSON_Utils.h"
RING_FUNC(ring_get_cjson_version_major)
{
	RING_API_RETNUMBER(CJSON_VERSION_MAJOR);
}

RING_FUNC(ring_get_cjson_version_minor)
{
	RING_API_RETNUMBER(CJSON_VERSION_MINOR);
}

RING_FUNC(ring_get_cjson_version_patch)
{
	RING_API_RETNUMBER(CJSON_VERSION_PATCH);
}

RING_FUNC(ring_get_cjson_invalid)
{
	RING_API_RETNUMBER(cJSON_Invalid);
}

RING_FUNC(ring_get_cjson_false)
{
	RING_API_RETNUMBER(cJSON_False);
}

RING_FUNC(ring_get_cjson_true)
{
	RING_API_RETNUMBER(cJSON_True);
}

RING_FUNC(ring_get_cjson_null)
{
	RING_API_RETNUMBER(cJSON_NULL);
}

RING_FUNC(ring_get_cjson_number)
{
	RING_API_RETNUMBER(cJSON_Number);
}

RING_FUNC(ring_get_cjson_string)
{
	RING_API_RETNUMBER(cJSON_String);
}

RING_FUNC(ring_get_cjson_array)
{
	RING_API_RETNUMBER(cJSON_Array);
}

RING_FUNC(ring_get_cjson_object)
{
	RING_API_RETNUMBER(cJSON_Object);
}

RING_FUNC(ring_get_cjson_raw)
{
	RING_API_RETNUMBER(cJSON_Raw);
}

RING_FUNC(ring_get_cjson_isreference)
{
	RING_API_RETNUMBER(cJSON_IsReference);
}

RING_FUNC(ring_get_cjson_stringisconst)
{
	RING_API_RETNUMBER(cJSON_StringIsConst);
}

RING_FUNC(ring_get_cjson_nesting_limit)
{
	RING_API_RETNUMBER(CJSON_NESTING_LIMIT);
}

RING_FUNC(ring_new_cjson)
{
	cJSON *pMyPointer ;
	pMyPointer = (cJSON *) RING_API_MALLOC(sizeof(cJSON)) ;
	if (pMyPointer == NULL) 
	{
		RING_API_ERROR(RING_OOM);
		return ;
	}
	RING_API_RETCPOINTER(pMyPointer,"cJSON");
}

RING_FUNC(ring_new_managed_cjson)
{
	cJSON *pMyPointer ;
	pMyPointer = (cJSON *) RING_API_MALLOC(sizeof(cJSON)) ;
	if (pMyPointer == NULL) 
	{
		RING_API_ERROR(RING_OOM);
		return ;
	}
	RING_API_RETMANAGEDCPOINTER(pMyPointer,"cJSON",RING_API_FREEFUNC);
}

RING_FUNC(ring_destroy_cjson)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = (cJSON*) RING_API_GETCPOINTER(1,"cJSON");
	if (pMyPointer != NULL) {
		RING_API_FREE(pMyPointer) ;
		RING_API_SETNULLPOINTER(1);
	}
}

RING_FUNC(ring_get_cjson_next)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	RING_API_RETCPOINTER(pMyPointer->next,"cJSON");
}

RING_FUNC(ring_set_cjson_next)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	pMyPointer->next = (cJSON *) RING_API_GETCPOINTER(2,"cJSON");
}

RING_FUNC(ring_get_cjson_prev)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	RING_API_RETCPOINTER(pMyPointer->prev,"cJSON");
}

RING_FUNC(ring_set_cjson_prev)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	pMyPointer->prev = (cJSON *) RING_API_GETCPOINTER(2,"cJSON");
}

RING_FUNC(ring_get_cjson_child)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	RING_API_RETCPOINTER(pMyPointer->child,"cJSON");
}

RING_FUNC(ring_set_cjson_child)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	pMyPointer->child = (cJSON *) RING_API_GETCPOINTER(2,"cJSON");
}

RING_FUNC(ring_get_cjson_type)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	RING_API_RETNUMBER(pMyPointer->type);
}

RING_FUNC(ring_set_cjson_type)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	pMyPointer->type = RING_API_GETNUMBER(2);
}

RING_FUNC(ring_get_cjson_valuestring)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	RING_API_RETCPOINTER(pMyPointer->valuestring,"char");
}

RING_FUNC(ring_set_cjson_valuestring)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	pMyPointer->valuestring = (char *) RING_API_GETCPOINTER(2,"char");
}

RING_FUNC(ring_get_cjson_valueint)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	RING_API_RETNUMBER(pMyPointer->valueint);
}

RING_FUNC(ring_set_cjson_valueint)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	pMyPointer->valueint = RING_API_GETNUMBER(2);
}

RING_FUNC(ring_get_cjson_valuedouble)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	RING_API_RETNUMBER(pMyPointer->valuedouble);
}

RING_FUNC(ring_set_cjson_valuedouble)
{
	cJSON *pMyPointer ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA) ;
		return ;
	}
	if ( ! RING_API_ISCPOINTER(1) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) { 
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pMyPointer = RING_API_GETCPOINTER(1,"cJSON");
	pMyPointer->valuedouble = RING_API_GETNUMBER(2);
}


RING_FUNC(ring_cJSON_Version)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	RING_API_RETSTRING(cJSON_Version());
}


RING_FUNC(ring_cJSON_InitHooks)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSON_InitHooks((cJSON_Hooks *) RING_API_GETCPOINTER(1,"cJSON_Hooks"));
}


RING_FUNC(ring_cJSON_Parse)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_Parse(RING_API_GETSTRING(1)),"cJSON");
}


RING_FUNC(ring_cJSON_ParseWithLength)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_ParseWithLength(RING_API_GETSTRING(1), (size_t ) RING_API_GETNUMBER(2)),"cJSON");
}


RING_FUNC(ring_cJSON_ParseWithOpts)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_ParseWithOpts(RING_API_GETSTRING(1),(char **) RING_API_GETCPOINTER2POINTER(2,"char"), (cJSON_bool ) RING_API_GETNUMBER(3)),"cJSON");
}


RING_FUNC(ring_cJSON_ParseWithLengthOpts)
{
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_ParseWithLengthOpts(RING_API_GETSTRING(1), (size_t ) RING_API_GETNUMBER(2),(char **) RING_API_GETCPOINTER2POINTER(3,"char"), (cJSON_bool ) RING_API_GETNUMBER(4)),"cJSON");
}


RING_FUNC(ring_cJSON_Print)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(cJSON_Print((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_PrintUnformatted)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(cJSON_PrintUnformatted((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_PrintBuffered)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(cJSON_PrintBuffered((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (int ) RING_API_GETNUMBER(2), (cJSON_bool ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_cJSON_PrintPreallocated)
{
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_PrintPreallocated((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2),* (const int  *) RING_API_GETCPOINTER(3,"const int"),* (const cJSON_bool  *) RING_API_GETCPOINTER(4,"const cJSON_bool")));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		RING_API_FREE(RING_API_GETCPOINTER(3,"int"));
	if (RING_API_ISCPOINTERNOTASSIGNED(4))
		RING_API_FREE(RING_API_GETCPOINTER(4,"cJSON_bool"));
}


RING_FUNC(ring_cJSON_Delete)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSON_Delete((cJSON *) RING_API_GETCPOINTER(1,"cJSON"));
}


RING_FUNC(ring_cJSON_GetArraySize)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_GetArraySize((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_GetArrayItem)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_GetArrayItem((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (int ) RING_API_GETNUMBER(2)),"cJSON");
}


RING_FUNC(ring_cJSON_GetObjectItem)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_GetObjectItem((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2)),"cJSON");
}


RING_FUNC(ring_cJSON_GetObjectItemCaseSensitive)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_GetObjectItemCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2)),"cJSON");
}


RING_FUNC(ring_cJSON_HasObjectItem)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_HasObjectItem((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2)));
}


RING_FUNC(ring_cJSON_GetErrorPtr)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	RING_API_RETSTRING(cJSON_GetErrorPtr());
}


RING_FUNC(ring_cJSON_GetStringValue)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(cJSON_GetStringValue((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_GetNumberValue)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_GetNumberValue((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsInvalid)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsInvalid((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsFalse)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsFalse((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsTrue)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsTrue((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsBool)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsBool((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsNull)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsNull((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsNumber)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsNumber((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsString)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsString((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsArray)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsArray((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsObject)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsObject((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_IsRaw)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_IsRaw((cJSON *) RING_API_GETCPOINTER(1,"cJSON")));
}


RING_FUNC(ring_cJSON_CreateNull)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	RING_API_RETCPOINTER(cJSON_CreateNull(),"cJSON");
}


RING_FUNC(ring_cJSON_CreateTrue)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	RING_API_RETCPOINTER(cJSON_CreateTrue(),"cJSON");
}


RING_FUNC(ring_cJSON_CreateFalse)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	RING_API_RETCPOINTER(cJSON_CreateFalse(),"cJSON");
}


RING_FUNC(ring_cJSON_CreateBool)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISNUMBER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateBool( (cJSON_bool ) RING_API_GETNUMBER(1)),"cJSON");
}


RING_FUNC(ring_cJSON_CreateNumber)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISNUMBER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateNumber( (double ) RING_API_GETNUMBER(1)),"cJSON");
}


RING_FUNC(ring_cJSON_CreateString)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateString(RING_API_GETSTRING(1)),"cJSON");
}


RING_FUNC(ring_cJSON_CreateRaw)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateRaw(RING_API_GETSTRING(1)),"cJSON");
}


RING_FUNC(ring_cJSON_CreateArray)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	RING_API_RETCPOINTER(cJSON_CreateArray(),"cJSON");
}


RING_FUNC(ring_cJSON_CreateObject)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	RING_API_RETCPOINTER(cJSON_CreateObject(),"cJSON");
}


RING_FUNC(ring_cJSON_CreateStringReference)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateStringReference(RING_API_GETSTRING(1)),"cJSON");
}


RING_FUNC(ring_cJSON_CreateObjectReference)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateObjectReference((cJSON *) RING_API_GETCPOINTER(1,"cJSON")),"cJSON");
}


RING_FUNC(ring_cJSON_CreateArrayReference)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateArrayReference((cJSON *) RING_API_GETCPOINTER(1,"cJSON")),"cJSON");
}


RING_FUNC(ring_cJSON_CreateIntArray)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateIntArray(RING_API_GETINTPOINTER(1), (int ) RING_API_GETNUMBER(2)),"cJSON");
	RING_API_ACCEPTINTVALUE(1) ;
}


RING_FUNC(ring_cJSON_CreateFloatArray)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateFloatArray((float *) RING_API_GETCPOINTER(1,"float"), (int ) RING_API_GETNUMBER(2)),"cJSON");
}


RING_FUNC(ring_cJSON_CreateDoubleArray)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateDoubleArray(RING_API_GETDOUBLEPOINTER(1), (int ) RING_API_GETNUMBER(2)),"cJSON");
}


RING_FUNC(ring_cJSON_AddItemToArray)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_AddItemToArray((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")));
}


RING_FUNC(ring_cJSON_AddItemToObject)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_AddItemToObject((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2),(cJSON *) RING_API_GETCPOINTER(3,"cJSON")));
}


RING_FUNC(ring_cJSON_AddItemToObjectCS)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_AddItemToObjectCS((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2),(cJSON *) RING_API_GETCPOINTER(3,"cJSON")));
}


RING_FUNC(ring_cJSON_AddItemReferenceToArray)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_AddItemReferenceToArray((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")));
}


RING_FUNC(ring_cJSON_AddItemReferenceToObject)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_AddItemReferenceToObject((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2),(cJSON *) RING_API_GETCPOINTER(3,"cJSON")));
}


RING_FUNC(ring_cJSON_DetachItemViaPointer)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_DetachItemViaPointer((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),* (cJSON * const  *) RING_API_GETCPOINTER(2,"cJSON * const")),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		RING_API_FREE(RING_API_GETCPOINTER(2,"cJSON"));
}


RING_FUNC(ring_cJSON_DetachItemFromArray)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_DetachItemFromArray((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (int ) RING_API_GETNUMBER(2)),"cJSON");
}


RING_FUNC(ring_cJSON_DeleteItemFromArray)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSON_DeleteItemFromArray((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_cJSON_DetachItemFromObject)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_DetachItemFromObject((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2)),"cJSON");
}


RING_FUNC(ring_cJSON_DetachItemFromObjectCaseSensitive)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_DetachItemFromObjectCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2)),"cJSON");
}


RING_FUNC(ring_cJSON_DeleteItemFromObject)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSON_DeleteItemFromObject((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2));
}


RING_FUNC(ring_cJSON_DeleteItemFromObjectCaseSensitive)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSON_DeleteItemFromObjectCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2));
}


RING_FUNC(ring_cJSON_InsertItemInArray)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_InsertItemInArray((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (int ) RING_API_GETNUMBER(2),(cJSON *) RING_API_GETCPOINTER(3,"cJSON")));
}


RING_FUNC(ring_cJSON_ReplaceItemViaPointer)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_ReplaceItemViaPointer(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),* (cJSON * const  *) RING_API_GETCPOINTER(2,"cJSON * const"),(cJSON *) RING_API_GETCPOINTER(3,"cJSON")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		RING_API_FREE(RING_API_GETCPOINTER(2,"cJSON"));
}


RING_FUNC(ring_cJSON_ReplaceItemInArray)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_ReplaceItemInArray((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (int ) RING_API_GETNUMBER(2),(cJSON *) RING_API_GETCPOINTER(3,"cJSON")));
}


RING_FUNC(ring_cJSON_ReplaceItemInObject)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_ReplaceItemInObject((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2),(cJSON *) RING_API_GETCPOINTER(3,"cJSON")));
}


RING_FUNC(ring_cJSON_ReplaceItemInObjectCaseSensitive)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_ReplaceItemInObjectCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2),(cJSON *) RING_API_GETCPOINTER(3,"cJSON")));
}


RING_FUNC(ring_cJSON_Duplicate)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_Duplicate((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (cJSON_bool ) RING_API_GETNUMBER(2)),"cJSON");
}


RING_FUNC(ring_cJSON_Compare)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_Compare((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON"),* (const cJSON_bool  *) RING_API_GETCPOINTER(3,"const cJSON_bool")));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		RING_API_FREE(RING_API_GETCPOINTER(3,"cJSON_bool"));
}


RING_FUNC(ring_cJSON_Minify)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSON_Minify(RING_API_GETSTRING(1));
}


RING_FUNC(ring_cJSON_AddNullToObject)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_AddNullToObject(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),RING_API_GETSTRING(2)),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
}


RING_FUNC(ring_cJSON_AddTrueToObject)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_AddTrueToObject(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),RING_API_GETSTRING(2)),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
}


RING_FUNC(ring_cJSON_AddFalseToObject)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_AddFalseToObject(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),RING_API_GETSTRING(2)),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
}


RING_FUNC(ring_cJSON_AddBoolToObject)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_AddBoolToObject(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),RING_API_GETSTRING(2),* (const cJSON_bool  *) RING_API_GETCPOINTER(3,"const cJSON_bool")),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		RING_API_FREE(RING_API_GETCPOINTER(3,"cJSON_bool"));
}


RING_FUNC(ring_cJSON_AddNumberToObject)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_AddNumberToObject(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),RING_API_GETSTRING(2),* (const double  *) RING_API_GETCPOINTER(3,"const double")),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		RING_API_FREE(RING_API_GETCPOINTER(3,"double"));
}


RING_FUNC(ring_cJSON_AddStringToObject)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_AddStringToObject(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),RING_API_GETSTRING(2),RING_API_GETSTRING(3)),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
}


RING_FUNC(ring_cJSON_AddRawToObject)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_AddRawToObject(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),RING_API_GETSTRING(2),RING_API_GETSTRING(3)),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
}


RING_FUNC(ring_cJSON_AddObjectToObject)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_AddObjectToObject(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),RING_API_GETSTRING(2)),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
}


RING_FUNC(ring_cJSON_AddArrayToObject)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_AddArrayToObject(* (cJSON * const  *) RING_API_GETCPOINTER(1,"cJSON * const"),RING_API_GETSTRING(2)),"cJSON");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		RING_API_FREE(RING_API_GETCPOINTER(1,"cJSON"));
}


RING_FUNC(ring_cJSON_SetNumberHelper)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSON_SetNumberHelper((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (double ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_cJSON_SetValuestring)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(cJSON_SetValuestring((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2)));
}


RING_FUNC(ring_cJSON_malloc)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISNUMBER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_malloc( (size_t ) RING_API_GETNUMBER(1)),"void");
}


RING_FUNC(ring_cJSON_free)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSON_free((void *) RING_API_GETCPOINTER(1,"void"));
}


RING_FUNC(ring_cJSON_SetIntValue)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSON_SetIntValue((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_cJSON_SetBoolValue)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSON_SetBoolValue((cJSON *) RING_API_GETCPOINTER(1,"cJSON"), (cJSON_bool ) RING_API_GETNUMBER(2));
}

RING_FUNC(ring_cJSON_CreateStringArray)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSON_CreateStringArray((const char *const *) RING_API_GETSTRING(1), (int ) RING_API_GETNUMBER(2)),"cJSON");
}

RING_FUNC(ring_cJSONUtils_GetPointer)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSONUtils_GetPointer((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2)),"cJSON");
}


RING_FUNC(ring_cJSONUtils_GetPointerCaseSensitive)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSONUtils_GetPointerCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2)),"cJSON");
}


RING_FUNC(ring_cJSONUtils_GeneratePatches)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSONUtils_GeneratePatches((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")),"cJSON");
}


RING_FUNC(ring_cJSONUtils_GeneratePatchesCaseSensitive)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSONUtils_GeneratePatchesCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")),"cJSON");
}


RING_FUNC(ring_cJSONUtils_AddPatchToArray)
{
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSONUtils_AddPatchToArray((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),RING_API_GETSTRING(2),RING_API_GETSTRING(3),(cJSON *) RING_API_GETCPOINTER(4,"cJSON"));
}


RING_FUNC(ring_cJSONUtils_ApplyPatches)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSONUtils_ApplyPatches((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")));
}


RING_FUNC(ring_cJSONUtils_ApplyPatchesCaseSensitive)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(cJSONUtils_ApplyPatchesCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")));
}


RING_FUNC(ring_cJSONUtils_MergePatch)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSONUtils_MergePatch((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")),"cJSON");
}


RING_FUNC(ring_cJSONUtils_MergePatchCaseSensitive)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSONUtils_MergePatchCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")),"cJSON");
}


RING_FUNC(ring_cJSONUtils_GenerateMergePatch)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSONUtils_GenerateMergePatch((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")),"cJSON");
}


RING_FUNC(ring_cJSONUtils_GenerateMergePatchCaseSensitive)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(cJSONUtils_GenerateMergePatchCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")),"cJSON");
}


RING_FUNC(ring_cJSONUtils_FindPointerFromObjectTo)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISCPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(cJSONUtils_FindPointerFromObjectTo((cJSON *) RING_API_GETCPOINTER(1,"cJSON"),(cJSON *) RING_API_GETCPOINTER(2,"cJSON")));
}


RING_FUNC(ring_cJSONUtils_SortObject)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSONUtils_SortObject((cJSON *) RING_API_GETCPOINTER(1,"cJSON"));
}


RING_FUNC(ring_cJSONUtils_SortObjectCaseSensitive)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	cJSONUtils_SortObjectCaseSensitive((cJSON *) RING_API_GETCPOINTER(1,"cJSON"));
}


void cJSON_ProcessList(cJSON *pJSON,List *pOutputList);

RING_FUNC(ring_cJSON_ToRingList)
{
	List *pOutputList;
	cJSON *pJSON ;
	pOutputList = ring_list_new(0);
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISCPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	// TODO: Implement the function
	pJSON = RING_API_GETCPOINTER(1,"cJSON");
	if (pJSON == NULL) {
		RING_API_RETLIST(pOutputList);		
		return ;
	}
	cJSON_ProcessList(pJSON,pOutputList);
	RING_API_RETLIST(pOutputList);		
}

void cJSON_ProcessList(cJSON *pJSON,List *pOutputList)
{
	List *pList, *pList2;
	cJSON *pJSONChild;
	while ( pJSON != NULL) {
		pList = pOutputList;
		if (pJSON->string != NULL) {
			pOutputList = ring_list_newlist(pOutputList);
			ring_list_addstring(pOutputList,pJSON->string);
		}
		switch ((pJSON->type) & 0xFF)
		{
			case cJSON_NULL:
				ring_list_addstring(pOutputList,"null");
				break;
			case cJSON_False:
				ring_list_addstring(pOutputList,"false");
				break;
			case cJSON_True:
				ring_list_addstring(pOutputList,"true");
				break;
			case cJSON_Number:
				ring_list_adddouble(pOutputList,cJSON_GetNumberValue(pJSON));
				break;
			case cJSON_Raw:
				ring_list_addstring(pOutputList,pJSON->valuestring);
				break;
			case cJSON_String:
				if (pJSON->valuestring != NULL)
					ring_list_addstring(pOutputList,cJSON_GetStringValue(pJSON));
				break;
			case cJSON_Array:
				pOutputList = ring_list_newlist(pOutputList);
				pJSONChild = pJSON->child;
				while ( pJSONChild != NULL) {
					pList2 = ring_list_newlist(pOutputList);
					cJSON_ProcessList(pJSONChild,pList2);
					pJSONChild = pJSONChild->next;
				}
				break;
			case cJSON_Object:
				if (pJSON->string != NULL) {
					pOutputList = ring_list_newlist(pOutputList);
				} else {
					pJSON = pJSON->child;
					continue ;
				}
				cJSON_ProcessList(pJSON->child,pOutputList);
				break;
		}
		pOutputList = pList;
		pJSON = pJSON->next;
	}
}
void ring_vm_cjson_loadfunctions ( RingState *pRingState )
{
	RING_API_REGISTER("cjson_version",ring_cJSON_Version);
	RING_API_REGISTER("cjson_inithooks",ring_cJSON_InitHooks);
	RING_API_REGISTER("cjson_parse",ring_cJSON_Parse);
	RING_API_REGISTER("cjson_parsewithlength",ring_cJSON_ParseWithLength);
	RING_API_REGISTER("cjson_parsewithopts",ring_cJSON_ParseWithOpts);
	RING_API_REGISTER("cjson_parsewithlengthopts",ring_cJSON_ParseWithLengthOpts);
	RING_API_REGISTER("cjson_print",ring_cJSON_Print);
	RING_API_REGISTER("cjson_printunformatted",ring_cJSON_PrintUnformatted);
	RING_API_REGISTER("cjson_printbuffered",ring_cJSON_PrintBuffered);
	RING_API_REGISTER("cjson_printpreallocated",ring_cJSON_PrintPreallocated);
	RING_API_REGISTER("cjson_delete",ring_cJSON_Delete);
	RING_API_REGISTER("cjson_getarraysize",ring_cJSON_GetArraySize);
	RING_API_REGISTER("cjson_getarrayitem",ring_cJSON_GetArrayItem);
	RING_API_REGISTER("cjson_getobjectitem",ring_cJSON_GetObjectItem);
	RING_API_REGISTER("cjson_getobjectitemcasesensitive",ring_cJSON_GetObjectItemCaseSensitive);
	RING_API_REGISTER("cjson_hasobjectitem",ring_cJSON_HasObjectItem);
	RING_API_REGISTER("cjson_geterrorptr",ring_cJSON_GetErrorPtr);
	RING_API_REGISTER("cjson_getstringvalue",ring_cJSON_GetStringValue);
	RING_API_REGISTER("cjson_getnumbervalue",ring_cJSON_GetNumberValue);
	RING_API_REGISTER("cjson_isinvalid",ring_cJSON_IsInvalid);
	RING_API_REGISTER("cjson_isfalse",ring_cJSON_IsFalse);
	RING_API_REGISTER("cjson_istrue",ring_cJSON_IsTrue);
	RING_API_REGISTER("cjson_isbool",ring_cJSON_IsBool);
	RING_API_REGISTER("cjson_isnull",ring_cJSON_IsNull);
	RING_API_REGISTER("cjson_isnumber",ring_cJSON_IsNumber);
	RING_API_REGISTER("cjson_isstring",ring_cJSON_IsString);
	RING_API_REGISTER("cjson_isarray",ring_cJSON_IsArray);
	RING_API_REGISTER("cjson_isobject",ring_cJSON_IsObject);
	RING_API_REGISTER("cjson_israw",ring_cJSON_IsRaw);
	RING_API_REGISTER("cjson_createnull",ring_cJSON_CreateNull);
	RING_API_REGISTER("cjson_createtrue",ring_cJSON_CreateTrue);
	RING_API_REGISTER("cjson_createfalse",ring_cJSON_CreateFalse);
	RING_API_REGISTER("cjson_createbool",ring_cJSON_CreateBool);
	RING_API_REGISTER("cjson_createnumber",ring_cJSON_CreateNumber);
	RING_API_REGISTER("cjson_createstring",ring_cJSON_CreateString);
	RING_API_REGISTER("cjson_createraw",ring_cJSON_CreateRaw);
	RING_API_REGISTER("cjson_createarray",ring_cJSON_CreateArray);
	RING_API_REGISTER("cjson_createobject",ring_cJSON_CreateObject);
	RING_API_REGISTER("cjson_createstringreference",ring_cJSON_CreateStringReference);
	RING_API_REGISTER("cjson_createobjectreference",ring_cJSON_CreateObjectReference);
	RING_API_REGISTER("cjson_createarrayreference",ring_cJSON_CreateArrayReference);
	RING_API_REGISTER("cjson_createintarray",ring_cJSON_CreateIntArray);
	RING_API_REGISTER("cjson_createfloatarray",ring_cJSON_CreateFloatArray);
	RING_API_REGISTER("cjson_createdoublearray",ring_cJSON_CreateDoubleArray);
	RING_API_REGISTER("cjson_additemtoarray",ring_cJSON_AddItemToArray);
	RING_API_REGISTER("cjson_additemtoobject",ring_cJSON_AddItemToObject);
	RING_API_REGISTER("cjson_additemtoobjectcs",ring_cJSON_AddItemToObjectCS);
	RING_API_REGISTER("cjson_additemreferencetoarray",ring_cJSON_AddItemReferenceToArray);
	RING_API_REGISTER("cjson_additemreferencetoobject",ring_cJSON_AddItemReferenceToObject);
	RING_API_REGISTER("cjson_detachitemviapointer",ring_cJSON_DetachItemViaPointer);
	RING_API_REGISTER("cjson_detachitemfromarray",ring_cJSON_DetachItemFromArray);
	RING_API_REGISTER("cjson_deleteitemfromarray",ring_cJSON_DeleteItemFromArray);
	RING_API_REGISTER("cjson_detachitemfromobject",ring_cJSON_DetachItemFromObject);
	RING_API_REGISTER("cjson_detachitemfromobjectcasesensitive",ring_cJSON_DetachItemFromObjectCaseSensitive);
	RING_API_REGISTER("cjson_deleteitemfromobject",ring_cJSON_DeleteItemFromObject);
	RING_API_REGISTER("cjson_deleteitemfromobjectcasesensitive",ring_cJSON_DeleteItemFromObjectCaseSensitive);
	RING_API_REGISTER("cjson_insertiteminarray",ring_cJSON_InsertItemInArray);
	RING_API_REGISTER("cjson_replaceitemviapointer",ring_cJSON_ReplaceItemViaPointer);
	RING_API_REGISTER("cjson_replaceiteminarray",ring_cJSON_ReplaceItemInArray);
	RING_API_REGISTER("cjson_replaceiteminobject",ring_cJSON_ReplaceItemInObject);
	RING_API_REGISTER("cjson_replaceiteminobjectcasesensitive",ring_cJSON_ReplaceItemInObjectCaseSensitive);
	RING_API_REGISTER("cjson_duplicate",ring_cJSON_Duplicate);
	RING_API_REGISTER("cjson_compare",ring_cJSON_Compare);
	RING_API_REGISTER("cjson_minify",ring_cJSON_Minify);
	RING_API_REGISTER("cjson_addnulltoobject",ring_cJSON_AddNullToObject);
	RING_API_REGISTER("cjson_addtruetoobject",ring_cJSON_AddTrueToObject);
	RING_API_REGISTER("cjson_addfalsetoobject",ring_cJSON_AddFalseToObject);
	RING_API_REGISTER("cjson_addbooltoobject",ring_cJSON_AddBoolToObject);
	RING_API_REGISTER("cjson_addnumbertoobject",ring_cJSON_AddNumberToObject);
	RING_API_REGISTER("cjson_addstringtoobject",ring_cJSON_AddStringToObject);
	RING_API_REGISTER("cjson_addrawtoobject",ring_cJSON_AddRawToObject);
	RING_API_REGISTER("cjson_addobjecttoobject",ring_cJSON_AddObjectToObject);
	RING_API_REGISTER("cjson_addarraytoobject",ring_cJSON_AddArrayToObject);
	RING_API_REGISTER("cjson_setnumberhelper",ring_cJSON_SetNumberHelper);
	RING_API_REGISTER("cjson_setvaluestring",ring_cJSON_SetValuestring);
	RING_API_REGISTER("cjson_malloc",ring_cJSON_malloc);
	RING_API_REGISTER("cjson_free",ring_cJSON_free);
	RING_API_REGISTER("cjson_setintvalue",ring_cJSON_SetIntValue);
	RING_API_REGISTER("cjson_setboolvalue",ring_cJSON_SetBoolValue);
	RING_API_REGISTER("cjson_createstringarray",ring_cJSON_CreateStringArray);
	RING_API_REGISTER("cjsonutils_getpointer",ring_cJSONUtils_GetPointer);
	RING_API_REGISTER("cjsonutils_getpointercasesensitive",ring_cJSONUtils_GetPointerCaseSensitive);
	RING_API_REGISTER("cjsonutils_generatepatches",ring_cJSONUtils_GeneratePatches);
	RING_API_REGISTER("cjsonutils_generatepatchescasesensitive",ring_cJSONUtils_GeneratePatchesCaseSensitive);
	RING_API_REGISTER("cjsonutils_addpatchtoarray",ring_cJSONUtils_AddPatchToArray);
	RING_API_REGISTER("cjsonutils_applypatches",ring_cJSONUtils_ApplyPatches);
	RING_API_REGISTER("cjsonutils_applypatchescasesensitive",ring_cJSONUtils_ApplyPatchesCaseSensitive);
	RING_API_REGISTER("cjsonutils_mergepatch",ring_cJSONUtils_MergePatch);
	RING_API_REGISTER("cjsonutils_mergepatchcasesensitive",ring_cJSONUtils_MergePatchCaseSensitive);
	RING_API_REGISTER("cjsonutils_generatemergepatch",ring_cJSONUtils_GenerateMergePatch);
	RING_API_REGISTER("cjsonutils_generatemergepatchcasesensitive",ring_cJSONUtils_GenerateMergePatchCaseSensitive);
	RING_API_REGISTER("cjsonutils_findpointerfromobjectto",ring_cJSONUtils_FindPointerFromObjectTo);
	RING_API_REGISTER("cjsonutils_sortobject",ring_cJSONUtils_SortObject);
	RING_API_REGISTER("cjsonutils_sortobjectcasesensitive",ring_cJSONUtils_SortObjectCaseSensitive);
	RING_API_REGISTER("cjson_toringlist",ring_cJSON_ToRingList);
	RING_API_REGISTER("get_cjson_version_major",ring_get_cjson_version_major);
	RING_API_REGISTER("get_cjson_version_minor",ring_get_cjson_version_minor);
	RING_API_REGISTER("get_cjson_version_patch",ring_get_cjson_version_patch);
	RING_API_REGISTER("get_cjson_invalid",ring_get_cjson_invalid);
	RING_API_REGISTER("get_cjson_false",ring_get_cjson_false);
	RING_API_REGISTER("get_cjson_true",ring_get_cjson_true);
	RING_API_REGISTER("get_cjson_null",ring_get_cjson_null);
	RING_API_REGISTER("get_cjson_number",ring_get_cjson_number);
	RING_API_REGISTER("get_cjson_string",ring_get_cjson_string);
	RING_API_REGISTER("get_cjson_array",ring_get_cjson_array);
	RING_API_REGISTER("get_cjson_object",ring_get_cjson_object);
	RING_API_REGISTER("get_cjson_raw",ring_get_cjson_raw);
	RING_API_REGISTER("get_cjson_isreference",ring_get_cjson_isreference);
	RING_API_REGISTER("get_cjson_stringisconst",ring_get_cjson_stringisconst);
	RING_API_REGISTER("get_cjson_nesting_limit",ring_get_cjson_nesting_limit);
	RING_API_REGISTER("new_cjson",ring_new_cjson);
	RING_API_REGISTER("new_managed_cjson",ring_new_managed_cjson);
	RING_API_REGISTER("destroy_cjson",ring_destroy_cjson);
	RING_API_REGISTER("get_cjson_next",ring_get_cjson_next);
	RING_API_REGISTER("set_cjson_next",ring_set_cjson_next);
	RING_API_REGISTER("get_cjson_prev",ring_get_cjson_prev);
	RING_API_REGISTER("set_cjson_prev",ring_set_cjson_prev);
	RING_API_REGISTER("get_cjson_child",ring_get_cjson_child);
	RING_API_REGISTER("set_cjson_child",ring_set_cjson_child);
	RING_API_REGISTER("get_cjson_type",ring_get_cjson_type);
	RING_API_REGISTER("set_cjson_type",ring_set_cjson_type);
	RING_API_REGISTER("get_cjson_valuestring",ring_get_cjson_valuestring);
	RING_API_REGISTER("set_cjson_valuestring",ring_set_cjson_valuestring);
	RING_API_REGISTER("get_cjson_valueint",ring_get_cjson_valueint);
	RING_API_REGISTER("set_cjson_valueint",ring_set_cjson_valueint);
	RING_API_REGISTER("get_cjson_valuedouble",ring_get_cjson_valuedouble);
	RING_API_REGISTER("set_cjson_valuedouble",ring_set_cjson_valuedouble);
}
