<?php
/* ========================================================================
 - [execute/cal_schedule.php]
 -      スケジュール用メール配信
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/26] wap_config.php読み込み追加
 -      [2006/08/29] 設定ファイル名の変更に伴う修正
 -      [2006/08/20] 作成
 - ======================================================================== */

define('EXECUTE_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR);

/* =-=- モジュール等の読み込み -=-= */
require_once EXECUTE_DIR.'../sns_config.php';
require_once BASE_DIR.'webapp'.DIRECTORY_SEPARATOR.'wap_config.php';

require_once LIB_DIR.'rkt_db.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';

/**
 * 日次処理：デイリー配信クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package cal_schedule
 * @access public
 * @version 1.1
 */
class cal_schedule
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * メールオブジェクト
     * @var object
     */
    var $objmail = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function cal_schedule()
    {
        $this->objdb = RKT_db::getInstance();
        $this->objmail = new sendmail('schedule');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $start = sql_query::dateFormat('cal.start_date','%m月 %d日 ');
        $end   = sql_query::dateFormat('cal.end_date','%m月 %d日 ');

        $format = sql_query::dateFormat('cal.start_date','%Y%m%d');
        $sql=
            'SELECT '.
                'act.email as email,'.
                'pro.nickname as nickname,'.
                $start.' as start_date,'.
                $end.' as end_date,'.
                'cal.start_hour as start_hour,'.
                'cal.start_minute as start_minute,'.
                'cal.end_hour as end_hour,'.
                'cal.end_minute as end_minute,'.
                'cal.schedule as schedule,'.
                'cal.comment as comment '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'cal_schedule cal '.
            'WHERE '.
                $format." = '".date('Y/m/d')."' AND ".
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'mail_flag = '.AVAIL_ENABLE;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        foreach ($result as $value){
            $this->send_mail($value);
        }
    }

    /**
     * ニュースの配信
     *
     * @access private
     * @param array $values
     * @return void
     **/
    function send_mail($values)
    {        
        $email = sql_query::decrypt($values['email']);

        $this->objmail->Assign('user_name', $values['nickname']);
        $this->objmail->Assign('start_date', $values['start_date']);
        $this->objmail->Assign('end_date', $values['end_date']);
        $this->objmail->Assign('start_hour', $values['start_hour']);
        $this->objmail->Assign('start_minute', $values['start_minute']);
        $this->objmail->Assign('end_hour', $values['end_hour']);
        $this->objmail->Assign('end_minute', $values['end_minute']);
        $this->objmail->Assign('schedule', $values['schedule']);
        $this->objmail->Assign('comment', $values['comment']);

        $this->objmail->sendmail($email);
    }

} // cal_schedule

$calsch = new cal_schedule();
$calsch->execute();
?>
