<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty wordwrap modifier plugin
 *
 * Type:     modifier<br>
 * Name:     rkt_strimwidth<br>
 * Purpose:  width a string of text at a given length
 * Examples:
 * <pre>
 * {$string|rkt_strimwidth}
 * {$string|rkt_strimwidth:20}
 * {$string|rkt_strimwidth:20:'...'}
 * {$string|rkt_strimwidth:20:'...':'utf-8'}
 * </pre>
 * @link http://jp.php.net/manual/ja/function.mb-strimwidth.php
 *          rkt_strimwidth
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @param string
 * @param integer
 * @param string
 * @param string
 * @return string
 */
function smarty_modifier_rkt_strimwidth($string,$length=200,$trimmarker="....",$encoding=NULL)
{
    return mb_strimwidth($string, 0, $length, $trimmarker);
}

?>
