<?php
/* ========================================================================
 - [libs/rktPDO/drivers/rkt_sqlite.php]
 -      なんちゃってPDO SQLiteドライバ
 -      Copyright (c) 2005-2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/12/18]    定数定義をrkt_pdo.phpへ集中
 -      [2006/09/29]    リクエスト結果取得関連の定数宣言を追加
 -      [2005/03/19]    bindParam追加・RKT_sqlite::query()の戻り値を修正
 -      [2005/01/08]    作成
 - ======================================================================== */

/**
 * なんちゃってPDO SQLiteドライバ
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_sqlite
 * @access public
 * @version 1.0
 */
class RKT_sqlite
{
    /**
     * DBハンドル
     * @access private
     * @var object
     */
    var $dbh = null;

    /**
     * errmessage
     * @access private
     * @var string
     */
    var $sqlerror = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_sqlite($dns,$arg=null)
    {
        $this->dbh = sqlite_open($dns['file'], 0666, $this->sqlerror);
    }

    /**
     * オープンされたSQLiteデータベースを閉じる
     *
     * @access public
     * @return void
     */
    function db_close()
    {
        sqlite_close($this->dbh);
        $this->dbh = null;
    }


    /**
     * 最後に発行したIDの取得
     *
     * @access public
     * @return integer
     */
    function lastInsertId()
    {
        return @sqlite_last_insert_rowid($this->dbh);
    }

    /**
     * プリペアドステートメントの作成
     *
     * @access public
     * @return object
     */
    function &prepare($sql)
    {
        $stmt = new RKT_sqliteStatement($this->dbh);
        $stmt->setSql($sql);
        
        return $stmt;
    }

    /**
     * トランザクションの開始
     *
     * @access public
     * @return boolean
     */
    function beginTransaction()
    {
        return true;
        $result = sqlite_exec ($this->dbh, 'BEGIN TRANSACTION');
        
        return ($result)?true:false;
    }

    /**
     * トランザクションの確証
     *
     * @access public
     * @return boolean
     */
    function commit()
    {
        return true;
        $result = sqlite_exec ($this->dbh, 'COMMIT');
        
        return ($result)?true:false;
    }

    /**
     * トランザクション内のクエリ取りやめ
     *
     * @access public
     * @return boolean
     */
    function rollBack()
    {
        $result = sqlite_query($this->dbh, 'ROLLBACK');
        
        return ($result)?true:false;
    }

    /**
     * アトリビュート設定
     *
     * @access public
     * @param long $attribute
     * @param mixed $value
     * @return boolean
     */
    function setAttribute($attribute, $value)
    {        
        return true;
    }
    
    /**
     * クエリ用の文字列をクオートする
     *
     * @access public
     * @param string $query
     * @return string
     */
    function quote($query)
    {
        return "'".sqlite_escape_string($query)."'";
    }

    /**
     * SQLクエリ実行
     *
     * @access public
     * @param string $query
     * @return integer
     */
    function exec($query)
    {
		ob_start();
        sqlite_query($this->dbh, $query);
		$this->sqlerror .= ob_get_contents();
		ob_end_clean();
        
        return @sqlite_changes($this->dbh);
    }

    /**
     * SQLクエリ実行
     *
     * @access public
     * @param string $query
     * @return boolean
     */
    function query($query)
    {
		ob_start();
        $result = sqlite_query($this->dbh, $query);
		$this->sqlerror .= ob_get_contents();
		ob_end_clean();
        
        return ($result)?true:false;
    }

    /**
     * エラーの取得
     *
     * @access public
     * @return string
     */
    function getError()
    {
		$error = sqlite_last_error($this->dbh);
		return sqlite_error_string($error);
    }
} // RKT_sqliteの終了

/**
 * なんちゃってPDOStatement
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_sqliteStatement
 * @access public
 * @version 1.1
 */
class RKT_sqliteStatement
{
    /**
     * DBハンドル
     * @access private
     * @var object
     */
    var $dbh = null;

    /**
     * sql
     * @access private
     * @var string
     */
    var $sql = '';

    /**
     * result
     * @access private
     * @var resource
     */
    var $result = null;

    /**
     * bind_flag
     * @access private
     * @var boolean
     */
    var $bind_flag = false;
 
    /**
     * インスタンス生成　現在の接続を返す
     *
     * @access public
     * @return object
     */
    function &getInstance(&$dbh)
    {
        static $__singleton;
        
        if ($__singleton == null) {
            $__singleton = new RKT_sqliteStatement($dbh);
        }
        return $__singleton;
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_sqliteStatement(&$dbh)
    {
        $this->dbh = $dbh;
    }

    /**
     * SQLの設定
     *
     * @access public
     * @pram string $sql
     * @return void
     */
    function setSql($sql)
    {
        $this->sql = $sql;
    }

    /**
     * SQLの設定
     *
     * @access public
     * @pram string $sql
     * @return void
     */
    function setBindFlag($flag)
    {
        $this->bind_flag = $flag;
    }

    /**
     * プリペアドステートメントを実行する 
     *
     * @access public
     * @return boolean
     */
    function execute()
    {
        if ($this->bind_flag){
            $sql = $this->_bind($this->sql);
        } else {
            $sql = $this->sql;
        }
        $this->result = @sqlite_query($this->dbh, $sql);
        return ($this->result)?true:false;
    }

    /**
     * プリペアドステートメントを実行する 
     *
     * @access public
     * @return boolean
     */
    function rowCount()
    {
        return @sqlite_changes($this->dbh);
    }

    /**
     * 結果リソースの値を取得
     *
     * @access public
     * @param integer $how
     * @return array
     */
    function fetch($how)
    {
        $result_type = array(
                PDO_FETCH_ASSOC=>SQLITE_ASSOC,
                PDO_FETCH_NUM=>  SQLITE_NUM,
                PDO_FETCH_BOTH=> SQLITE_BOTH
            );
        return @sqlite_fetch_array($this->result, $result_type[$how]);
    }

    /**
     * 結果リソースの値を取得
     *
     * @access public
     * @return mixed
     */
    function fetchSingle()
    {
        return @sqlite_fetch_single($this->result);
    }

    /**
     * 結果リソースの全ての値を取得
     *
     * @access public
     * @param integer $how
     * @return array
     */
    function fetchAll($how)
    {
        $result_type = array(
                PDO_FETCH_ASSOC=>SQLITE_ASSOC,
                PDO_FETCH_NUM=>  SQLITE_NUM,
                PDO_FETCH_BOTH=> SQLITE_BOTH
            );
        return @sqlite_fetch_all($this->result, $result_type[$how]);
    }

    /**
     * バインド変数設定
     *
     * @access public
     * @param mixed $paramno
     * @param mixed &$param
     * @param integer $type
     * @param integer $maxlen
     * @param mixed $driverdata
     * @return boolean
     */
    function bindParam($paramno, &$param, $type=PDO_PARAM_STR, $maxlen=0, $driverdata=null)
    {
         $this->bind_flag = true;
         $this->param[$paramno] = array(
            'key'=>   $paramno,
            'param'=> &$param,
            'type'=>  $type,
            'maxlen'=>$maxlen
        );
        return true;
    }

    /**
     * カーソルを閉じる
     *
     * @access public
     * @return boolean
     */
    function closeCursor()
    {
        return true;
    }

    /**
     * バインド変数処理
     *
     * @access public
     * @return string
     */
    function _bind()
    {
        $types = array(
                PDO_PARAM_NULL=> '',
                PDO_PARAM_INT=>  '',
                PDO_PARAM_STR=>  "'",
                PDO_PARAM_LOB=>  '',
                PDO_PARAM_STMT=> ''
            );

        foreach ($this->param as $param){
            $value  = $types[$param['type']];
            $value .= sqlite_escape_string($param['param']);
            $value .= $types[$param['type']];

            $sql = preg_replace( '/'.$param['key'].'/', $value, $sql, 1);
        }

        return $sql;
    }
} // RKT_sqliteStatementの終了
?>