<?php
/* ========================================================================
 - [modules/private/edit/relation.php]
 -      各種認証
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 友達ID
     * @var integer
     */
    var $ref_friends = 0;

    /**
     * 管理人変更用名簿ＩＤ
     * @var integer
     */
    var $ref_change = 0;

    /**
     * コミュニティ参加用名簿ＩＤ
     * @var integer
     */
    var $ref_entry = 0;

    /**
     * ステータス
     * @var integer
     */
    var $status = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/edit/relation.tpl');

        /* URL引数の取得 */
        $this->setSafety('ref_friends');
        $this->setSafety('ref_change');
        $this->setSafety('ref_entry');
        $this->setSafety('status');

        if (!empty($this->status)){
            $this->update_friends();
            $this->update_change();
            $this->update_entry();
        }

        $this->set_friends();
        $this->set_change();
        $this->set_entry();
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friends()
    {
        $sql=
            'SELECT '.
                'fri.id as id,'.
                'act.id as ref_friend,'.
                'act.last_login as last_login,'.
                'sex.sex as sex,'.
                'pro.nickname as nickname,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'fri.comment as comment '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'sex.id = pro.ref_sex AND '.
                'act.id = fri.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_THROW.' AND '.
                'fri.ref_account='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('friends', $result);
    }

    /**
     * 友達登録の更新
     *
     * @access private
     * @return void
     */
    function update_friends()
    {
        if (empty($this->ref_friends)){
            return ;
        }
        $sql=
            'SELECT '.
                'ref_friend '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'id = '.$this->ref_friends.' AND '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_THROW.' AND '.
                'ref_account='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute();
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $pages = array(
            STATUS_FRIEND_CONNECT=> 'friend/edit/message/'.$this->sid.'/'.$result['ref_friend'].'/'.WAP_URI_SEPARATOR.'relation=1',
            STATUS_FRIEND_REFUSAL=> 'private/edit/relation/'.$this->sid.'/'.WAP_URI_SEPARATOR.'updated=1'
        );

        $this->status = ($this->status == STATUS_FRIEND_CONNECT) ? 
                            STATUS_FRIEND_CONNECT:STATUS_FRIEND_REFUSAL;
        $sql =
            'UPDATE '.
                DB_PREFIX.'fri_friends '.
            ' SET '.
                'status='.$this->status.' '.
            ' WHERE '.
                'id = '.$this->ref_friends.' AND '.
                'status = '.STATUS_FRIEND_THROW.' AND '.
                'ref_account='.$this->account['id'];
        /* アクション処理 */
        if ($this->objdb->exec($sql)){
            $this->insert_friends($result['ref_friend']);
            $this->send_friends();
            header('Location: '.HTTP_ACTION.$pages[$this->status]);
            exit();
        }
    }

    /**
     * 相手用の友達リスト追加
     *
     * @access private
     * @return void
     */
    function insert_friends($ref_account)
    {
        if ($this->status != STATUS_FRIEND_CONNECT){
            return false;
        }
        $now = sql_query::now();
        $sql=
            'INSERT INTO '.
                DB_PREFIX.'fri_friends ('.
                    'modify,'.
                    'avail,'.
                    'status,'.
                    'ref_account,'.
                    'ref_friend'.
                ') VALUES ('.
                    $now.','.
                    AVAIL_ENABLE.','.
                    STATUS_FRIEND_CONNECT.','.
                    $ref_account.','.
                    $this->account['id'].
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * 友達登録の更新通知メール
     *
     * @access private
     * @return void
     */
    function send_friends()
    {
        $result = array(
            STATUS_FRIEND_CONNECT=> 'friendsOK',
            STATUS_FRIEND_REFUSAL=> 'friendsNG',
        );

        $sql=
            'SELECT '.
                'act.email as email,'.
                'pro.nickname as nickname '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = fri.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.id = '.$this->ref_friends;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        
        $user = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $objmail = new sendmail($result[$this->status]);

        $objmail->Assign('friend', $this->account['nickname']);
        $objmail->Assign('user_name', $user['nickname']);
        $objmail->Assign('url', HTTP_ACTION.'friend/show/profile/'.$this->account['id'].'/');

        $to = sql_query::decrypt($user['email']);
        $objmail->send($to);
    }

    /**
     * 管理人交代の設定
     *
     * @access private
     * @return void
     */
    function set_change()
    {
        $sql=
            'SELECT '.
                'nam.id as id,'.
                'nam.ref_community as ref_community,'.
                'com.community as community,'.
                'com.ref_account as ref_account,'.
                'act.last_login as last_login,'.
                'sex.sex as sex,'.
                'pro.nickname as nickname,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'com_community com,'.
                DB_PREFIX.'com_names nam,'.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'com.id = nam.ref_community AND '.
                'nam.status = '.STATUS_COMMUNITY_CHANGE.' AND '.
                'nam.ref_account='.$this->account['id'].' AND '.
                'act.id = com.ref_account AND '.
                'sex.id = pro.ref_sex AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.avail = '.AVAIL_ENABLE;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('changes', $result);
    }

    /**
     * 管理人交代の処理
     *
     * @access private
     * @return void
     */
    function update_change()
    {
        if (empty($this->ref_change)){
            return ;
        }
        $sql=
            'SELECT '.
                'com.id as id,'.
                'act.email as email,'.
                'pro.nickname as nickname,'.
                'com.community as community,'.
                'com.ref_account as ref_account '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_community com,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'act.id = nam.ref_account AND '.
                'act.id = pro.ref_account AND '.
                'com.id = nam.ref_community AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'nam.id = '.$this->ref_change.' AND '.
                'nam.status = '.STATUS_COMMUNITY_CHANGE.' AND '.
                'nam.ref_account='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($infos)){
            return ;
        }

        $this->status = (STATUS_COMMUNITY_ADMIN == $this->status) ?
                             STATUS_COMMUNITY_ADMIN:STATUS_COMMUNITY_MEMBER;
        
        $ref_community = $infos['id'];
        $old_admin = $infos['ref_account'];
        $sql =
            'UPDATE '.
                DB_PREFIX.'com_names '.
            ' SET '.
                'status='.$this->status.' '.
            ' WHERE '.
                'id = '.$this->ref_change.' AND '.
                'status = '.STATUS_COMMUNITY_CHANGE.' AND '.
                'ref_account='.$this->account['id'];
        $result = $this->objdb->exec($sql);
        if ($result && $this->status == STATUS_COMMUNITY_ADMIN){
            $sql =
                'UPDATE '.
                    DB_PREFIX.'com_names '.
                ' SET '.
                    'status='.STATUS_COMMUNITY_MEMBER.' '.
                ' WHERE '.
                    'ref_community = '.$ref_community.' AND '.
                    'status = '.STATUS_COMMUNITY_ADMIN.' AND '.
                    'ref_account='.$old_admin;
            $this->objdb->exec($sql);

            $sql =
                'UPDATE '.
                    DB_PREFIX.'com_community '.
                ' SET '.
                    'ref_account='.$this->account['id'].' '.
                ' WHERE '.
                    'id = '.$ref_community;
            $this->objdb->exec($sql);
            $this->send_change($infos,'承諾');
        } else {
            $this->send_change($infos,'辞退');
        }
        /* アクション処理 */
        if ($result){
            header('Location: '.HTTP_ACTION.'private/edit/relation/'.$this->sid.'/'.WAP_URI_SEPARATOR.'updated=1');
            exit();
        }        
    }

    /**
     * 管理人交代通知メール
     *
     * @access private
     * @param array $infos
     * @param string $result
     * @return void
     */
    function send_change($infos,$result)
    {
        $objmail = new sendmail('change');

        $objmail->Assign('friend', $this->account['nickname']);
        $objmail->Assign('user_name', $infos['nickname']);
        $objmail->Assign('community', $infos['community']);
        $objmail->Assign('result', $result);
        $objmail->Assign('url', HTTP_ACTION.'community/show/community/'.$infos['id'].'/');

        $to = sql_query::decrypt($infos['email']);
        $objmail->send($to);
    }

    /**
     * コミュニティ参加の設定
     *
     * @access private
     * @return void
     */
    function set_entry()
    {
        $sql=
            'SELECT '.
                'nam.id as id,'.
                'nam.ref_community as ref_community,'.
                'com.community as community,'.
                'act.id as ref_friend,'.
                'act.last_login as last_login,'.
                'pro.nickname as nickname,'.
                'sex.sex as sex,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'nam.comment as comment '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'com_community com,'.
                DB_PREFIX.'com_names nam,'.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'com.id = nam.ref_community AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'nam.status = '.STATUS_COMMUNITY_REQUEST.' AND '.
                'com.ref_account='.$this->account['id'].' AND '.
                'act.id = nam.ref_account AND '.
                'act.id = pro.ref_account AND '.
                'sex.id = pro.ref_sex';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('entrys', $result);
    }

    /**
     * コミュニティ参加の処理
     *
     * @access private
     * @return void
     */
    function update_entry()
    {
        if (empty($this->ref_entry)){
            return ;
        }
        $sql=
            'SELECT '.
                'com.id as id,'.
                'act.email as email,'.
                'pro.nickname as nickname,'.
                'com.community as community,'.
                'com.ref_account as ref_account '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_community com,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'act.id = nam.ref_account AND '.
                'act.id = pro.ref_account AND '.
                'com.id = nam.ref_community AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'com.ref_account = '.$this->account['id'].' AND '.
                'nam.id = '.$this->ref_entry;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($infos)){
            return ;
        }

        $this->status = (STATUS_COMMUNITY_MEMBER == $this->status) ?
                             STATUS_COMMUNITY_MEMBER:STATUS_COMMUNITY_REFUSAL;
        $sql =
            'UPDATE '.
                DB_PREFIX.'com_names '.
            ' SET '.
                'status='.$this->status.' '.
            ' WHERE '.
                'id = '.$this->ref_entry;
        $result = $this->objdb->exec($sql);

        /* アクション処理 */
        if ($result){
            $this->send_entry($infos);
            header('Location: '.HTTP_ACTION.'private/edit/relation/'.$this->sid.'/'.WAP_URI_SEPARATOR.'updated=1');
            exit();
        }        
    }

    /**
     * コミュニティ参加通知メール
     *
     * @access private
     * @param array $infos
     * @return void
     */
    function send_entry($infos)
    {
        $result = array(
            STATUS_COMMUNITY_MEMBER=> 'entryOK',
            STATUS_COMMUNITY_REFUSAL=> 'entryNG',
        );
        $objmail = new sendmail($result[$this->status]);

        $objmail->Assign('user_name', $infos['nickname']);
        $objmail->Assign('community', $infos['community']);
        $objmail->Assign('url', HTTP_ACTION.'community/show/community/'.$infos['id'].'/');

        $to = sql_query::decrypt($infos['email']);
        $objmail->send($to);
    }
} // webapp
?>
