<?php
/* ========================================================================
 - [modules/public/registry/confirm.php]
 -      入力内容確認
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 友達名簿ID
     * @var integer
     */
    var $ref_friends = 0;

    /**
     * 暗号化用の種
     * @var string
     */
    var $seed = '';

    /**
     * 暗号化文字列
     * @var string
     */
    var $key = '';

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/registry/confirm.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_friends');
        $this->Assign('ref_friends', $this->ref_friends);
        $this->setPathInfo('seed',1,'string');
        $this->Assign('seed', $this->seed);
        $this->setPathInfo('key',2,'string');
        $this->Assign('key', $this->key);

        /* アクション処理 */
        if (!empty($_REQUEST['registry'])){
            header('Location: '.SSL_ACTION.'public/registry/sendmail/'.$this->sid.'/'.$this->ref_friends.'/'.$this->seed.'/'.$this->key.'/');
            exit();
        } else if (!empty($_REQUEST['again'])){
            header('Location: '.SSL_ACTION.'public/registry/account/'.$this->sid.'/'.$this->ref_friends.'/'.$this->seed.'/'.$this->key.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_account');
        $this->objmnp->setValuesKey('value');
        $this->objmnp->doValidate($this);
    }
} // webapp
?>
