<?php
/* ========================================================================
 - [modules/public/registry/registry.php]
 -      会員登録
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * アカウントID
     * @var integer
     */
    var $id = 0;

    /**
     * 友達名簿ID
     * @var integer
     */
    var $ref_friends = 0;

    /**
     * 暗号化用の種
     * @var string
     */
    var $seed = '';

    /**
     * 暗号化文字列
     * @var string
     */
    var $key = '';

    /**
     * 紹介者ID
     * @var integer
     */
    var $ref_account = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/registry/registry.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_friends');
        $this->Assign('ref_friends', $this->ref_friends);
        $this->setPathInfo('seed',1,'string');
        $this->Assign('seed', $this->seed);
        $this->setPathInfo('key',2,'string');
        $this->Assign('key', $this->key);

    	if ($this->check_keyword()){
    		if ($this->update_account()){
                $this->insert_diary();
                $this->do_friends();
    		    $this->Assign('complete', true);			
    		} else {
    		    $this->Assign('again', true);
    		}
    	} else {
    	    $this->Assign('unmatch', true);
    	}
        $this->Assign('sessionid', RKT_auth::getSessionID());
    }

    /**
     * キーワードの確認
     *
     * @access private
     * @return boolean 真偽値
     */
    function check_keyword()
    {
    	if (empty($this->seed)){
    		return false;
    	}
    	if (empty($this->key)){
    		return false;
    	}

        $sql=
            'SELECT '.
                'ref_account,'.
                'ref_friend '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'id ='.$this->ref_friends;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

    	$seed = md5($result['ref_account'].RKT_SEED);
        $seed = substr($seed,4,6);
    	$key = md5($seed.$result['ref_friend'].RKT_SEED);

    	$this->id = $result['ref_friend'];
    	$this->ref_account = $result['ref_account'];
        
    	if ($key != $this->key){
    		return false;
    	}
    	return true;
    }

    /**
     * 会員登録の完了処理
     *
     * @access private
     * @return boolean
     */
    function update_account()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'avail = '.AVAIL_PENDING.' AND '.
                'id='.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result['ct'])){
            return false;
        }

        $sql=
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                'avail = '.AVAIL_ENABLE.' '.
            'WHERE '.
                'id='.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * 日記テーブルの挿入
     *
     * @access private
     * @return array
     */
    function insert_diary()
    {
        $sql = 
            'INSERT INTO '.
                DB_PREFIX.'dia_diary ('.
                    'modify,'.
                    'ref_account,'.
                    'visibility,'.
                    'url,'.
                    'rss '.
                ') VALUES ('.
                    "'".date('Y-m-d H:i:s')."',".
                    $this->id.','.
                    VISIBILITY_PROTECTED.','.
                    "'',".
                    "''".
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * 友達名簿の更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_friends()
    {
        $sql =
            'UPDATE '.
                DB_PREFIX.'fri_friends '.
            'SET '.
                'status='.STATUS_FRIEND_CONNECT.' '.
            'WHERE '.
                'id='.$this->ref_friends;
        $this->objdb->exec($sql);
    }

    /**
     * 友達名簿の挿入
     *
     * @access private
     * @return boolean
     */
    function insert_friends($ref_account)
    {
        $sql = 
            'INSERT INTO '.
                DB_PREFIX.'fri_friends ('.
                    'modify,'.
                    'avail,'.
                    'status,'.
                    'invite,'.
                    'ref_account,'.
                    'ref_friend,'.
                    'email,'.
                    'email_hash,'.
                    'comment'.
                ') VALUES ('.
                    "'".date('Y-m-d H:i:s')."',".
                    AVAIL_ENABLE.','.
                    STATUS_FRIEND_CONNECT.','.
                    '1,'.
                    $this->id.','.
                    $ref_account.','.
                    'NULL,'.
                    'NULL,'.
                    'NULL'.
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * 友達数の設定
     *
     * @access private
     * @return void
     */
    function update_friend_number()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->insert_friends($this->ref_account);

        $sql =
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                'friend_number ='.$result['ct'].' '.
            'WHERE '.
                'id='.$this->ref_account;
        $this->objdb->exec($sql);
    }
    
    /**
     * 友達名簿の更新とグループ登録
     *
     * @access private
     * @return void
     */
    function do_friends()
    {        
        $this->update_friends();
        $this->update_friend_number();
    }
} // webapp
?>
