<?php
/* ========================================================================
 - [modules/admin/account/profile.php]
 -      プロフィール
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/29] 整形表示のエラー修正
 -      [2006/08/04] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * アカウントID
     * @var integer
     */
    var $id = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/account/profile.tpl');

        // URL引数の取得
        $this->setSafety('id');
        $this->Assign('id', $this->id);

        $this->set_relation();
        $this->set_friend_number();
        $this->set_photo();
        $this->set_profile();
        $this->set_enquete();
        $this->set_friend();
        $this->set_community();
        $this->set_community_number();
    }

    /**
     * 招待元の友達設定
     *
     * @access public
     * @return void
     */
    function set_relation()
    {
        $sql=
            'SELECT '.
                'pro.ref_account as ref_account,'.
                'pro.nickname as nickname '.
            'FROM '.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'pro.ref_account = fri.ref_account AND '.
                'fri.invite = '.INVITE_ENABLE.'  AND '.
                'fri.ref_friend = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        $this->Assign('relation', $result);
    }


    /**
     * 友達数の設定
     *
     * @access public
     * @return void
     */
    function set_friend_number()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        $this->Assign('friend_num',$result['ct']);
    }

    /**
     * 写真の設定
     *
     * @access public
     * @return void
     */
    function set_photo()
    {
        $sql=
            'SELECT '.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'ref_account = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $nophoto = array(
            'href'=>   NOPHOTO_LARGE,
            'src'=>    NOPHOTO_SMALL,
            'width'=>  PHOTO_SMALL_SIZE,
            'height'=> PHOTO_SMALL_SIZE
        );
        
        $list = array();
        for ($row=0; $row<3; $row++){
            $list[] = empty($result[$row])?$nophoto:$result[$row];
        }

        $this->Assign('photos', $list);
    }

    /**
     * プロフィールの設定
     *
     * @access public
     * @return void
     */
    function set_profile()
    {
        $sql=
            'SELECT '.
                'act.last_login as last_login,'.
                'act.regist_date as regist_date,'.
                'act.email as email,'.
                'act.cellular as cellular,'.
                'act.block as block,'.
                'pro.id as id,'.
                'pro.ref_account as ref_account,'.
                'pro.modify as modify,'.
                'pro.first_name as first_name,'.
                'pro.second_name as second_name,'.
                'pro.nickname as nickname,'.
                'pro.ref_blood as ref_blood,'.
                'pro.birthday as birthday,'.
                'pro.publicity as publicity,'.
                'prf.prefecture as prefecture,'.
                'lcl.local as local,'.
                'sex.sex as sex,'.
                'bld.blood as blood,'.
                'mrd.married as married,'.
                'htn.prefecture as hometown,'.
                'hlc.local as homelocal '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_married mrd,'.
                DB_PREFIX.'act_profile pro '.
                    'LEFT JOIN '.DB_PREFIX.'act_blood bld '.
                    'ON bld.id = pro.ref_blood '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture prf '.
                    'ON prf.id = pro.ref_prefecture '.
                    'LEFT JOIN '.DB_PREFIX.'ara_local lcl '.
                    'ON lcl.id = pro.ref_local '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture htn '.
                    'ON htn.id = pro.ref_hometown '.
                    'LEFT JOIN '.DB_PREFIX.'ara_local hlc '.
                    'ON hlc.id = pro.ref_homelocal '.                    
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'sex.id = pro.ref_sex AND '.
                'mrd.id = pro.ref_married AND '.
                'pro.ref_account = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        if (empty($result)){
            header('Location: '.HTTP_ACTION);
            exit();
        }
        
        $this->Assign('profile',$result);
    }

    /**
     * アンケートの設定
     *
     * @access private
     * @return void
     */
    function set_enquete()
    {
        $sql=
            'SELECT '.
                'id,'.
                'form_type,'.
                'enquete '.
            'FROM '.
                DB_PREFIX.'act_enquete '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            if ($value['form_type'] == FORM_TYPE_CHECKBOX){
                $value['value'] = $this->get_select($value['id']);
            } else {
                $value['value'] = $this->get_item($value['id'],$value['form_type']);
            }
            $list[] = $value;
        }

        $this->Assign('enquetes', $list);
    }

    /**
     * 回答したアンケートの取得
     *
     * @access private
     * @param integer $ref_enquete
     * @param integer $form_type
     * @return array
     */
    function get_item($ref_enquete, $form_type)
    {
        $sql=
            'SELECT '.
                'con.ref_enquete as ref_enquete,'.
                'itm.item as item,'.
                'con.content as content '.
            'FROM '.
                DB_PREFIX.'act_content con '.
                    'LEFT JOIN '.DB_PREFIX.'act_item itm '.
                    'ON itm.id = con.ref_item '.
            'WHERE '.
                'con.ref_enquete = '.$ref_enquete.' AND '.
                'con.ref_account = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        if (empty($result)){
            return null;
        }

        if ($form_type == FORM_TYPE_SELECT || $form_type == FORM_TYPE_RADIO){
            return $result['item'];
        }
        
        return $result['content'];
    }

    /**
     * 選択肢の取得
     *
     * @access private
     * @param integer $ref_enquete
     * @return string
     */
    function get_select($ref_enquete)
    {
        $sql=
            'SELECT '.
                'itm.item as item '.
            'FROM '.
                DB_PREFIX.'act_item itm,'.
                DB_PREFIX.'act_select sel '.
            'WHERE '.
                'itm.id = sel.ref_item AND '.
                'sel.ref_enquete = '.$ref_enquete.' AND '.
                'sel.ref_account = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        $list = array();
        foreach ($result as $row){
            $list[] = $row['item'];
        }
        
        return  implode(',&nbsp;',$list);
    }

    /**
     * 情報の成形
     *
     * @access public
     * @param array $values
     * @return array
     */
    function shape_list($values)
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($values as $value){
            // 改行処理
            if ($column >= 3){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } // foreach ($result as $value)
        
        return $list;
    }

    /**
     * 友達の設定
     *
     * @access public
     * @return void
     */
    function set_friend()
    {
        $sql=
            'SELECT '.
                'ref_account,'.
                'ref_friend '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$this->id .' '.
            'ORDER BY '.
                'modify '.
            'LIMIT 9';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $list = array();
        $row=0;
        foreach ($result as $value){
            $ref_friend = ($value['ref_account'] != $this->id)
                                ?$value['ref_account']:$value['ref_friend'];
            $list[] = $this->get_friend($ref_friend);
            $row++;
        }

        $inits = array (0,2,1);
        for ($row=$inits[$row%3]; $row; $row--){
            $list[] = array(
                'name'=> '',
                'friend_number'=>0,
                'subject'=> '',
                'src'=>    '',
                'width'=>  0,
                'height'=> 0
            );
        }
        $this->Assign('friends', $this->shape_list($list));
    }

    /**
     * 友達情報の取得
     *
     * @access public
     * @param integer $ref_account
     * @return array
     */
    function get_friend($ref_account)
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = '.$ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        if (empty($result)){
            $result = array(
                'id'=> null,
                'nickname'=> '',
                'friend_number'=>0,
                'src'=>    NOPHOTO_LARGE,
                'width'=>  PHOTO_SMALL_SIZE,
                'height'=> PHOTO_SMALL_SIZE
            );
        }
        $result['src'] = empty($result['src'])?NOPHOTO_SMALL:$result['src'];
        $result['width'] = empty($result['width'])?PHOTO_SMALL_SIZE:$result['width'];
        $result['height'] = empty($result['height'])?PHOTO_SMALL_SIZE:$result['height'];

        return $result;
    }

    /**
     * コミュニティの設定
     *
     * @access public
     * @return void
     */
    function set_community()
    {
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.community as community,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.','.
                DB_PREFIX.'com_names nms '.
            'WHERE '.
                'com.id = nms.ref_community AND '.
                '(nms.status = '.STATUS_COMMUNITY_MEMBER.' OR '.
                 'nms.status = '.STATUS_COMMUNITY_CHANGE.' OR '.
                 'nms.status = '.STATUS_COMMUNITY_ADMIN.')AND '.
                'nms.ref_account = '.$this->id.' '.
            'ORDER BY '.
                'nms.modify '.
            'LIMIT 9';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            $this->Assign('communitys', null);
            return ;
        }

        $list = array();
        $row=0;
        foreach ($result as $value){
            $value['src'] = empty($value['src'])?NOPHOTO_SMALL:$value['src'];
            $value['width'] = empty($value['width'])?PHOTO_SMALL_SIZE:$value['width'];
            $value['height'] = empty($value['height'])?PHOTO_SMALL_SIZE:$value['height'];

            $list[] = array(
                'id'=> $value['id'],
                'community'=> $value['community'],
                'src'=> $value['src'],
                'width'=> $value['width'],
                'height'=> $value['height'],
            );
            $row++;
        }

        $inits = array (0,2,1);
        for ($row=$inits[$row%3]; $row; $row--){
            $list[] = array(
                'id'=> '',
                'community'=> '',
                'src'=>    '',
                'width'=>  0,
                'height'=> 0
            );
        }

        $this->Assign('communitys', $this->shape_list($list));
    }

    /**
     * グループ数の設定
     *
     * @access public
     * @return void
     */
    function set_community_number()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_account = '.$this->id. ' AND '.
                '(status = '.STATUS_COMMUNITY_MEMBER.' OR '.
                 'status = '.STATUS_COMMUNITY_CHANGE.' OR '.
                 'status = '.STATUS_COMMUNITY_ADMIN.')';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        $this->Assign('community_num',$result['ct']);
    }
} // webapp
?>
