<?php
/* ========================================================================
 - [libs/rkt_validate.php]
 -      データの整合性確認
 -      Copyright (c) 2005-2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2007/03/11] 入力データのエスケープ処理を追加
 -      [2005/05/05] グローバルスコープ関連を修正
 -      [2005/03/19] 作成
 - ======================================================================== */

require_once LIB_DIR.'PEAR/Validate.php';
require_once LIB_DIR.'rkt_calendar.php';

/**
 * 整合性確認クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_validate
 * @access public
 * @version 1.2
 */
class RKT_validate extends Validate
{
    /**
     * グローバルスコープ名
     * @access private
     * @var string
     */
    var $request_type = '';

    /**
     * 個別警告フラグ格納用
     * @access private
     * @var array
     */
    var $alerts = array();

    /**
     * 取得したグローバルスコープ値格納用
     * @access private
     * @var string
     */
    var $requests =  array();

    /**
     * グローバルスコープ名
     * @access private
     * @var string
     */
    var $request = '_REQUEST';

    /**
     * 正当性フラグ
     * @access private
     * @var integer
     */
    var $validated = true;

    /**
     * コンストラクタ
     *
     * @access public
     * @param array $request グローバルスコープ名
     */
    function RKT_validate($request_type = '_REQUEST')
    {
        $this->request_type = $request_type;
        $this->alerts = array();
        $this->validated = true;
    }

    /**
     * 入力方法の設定
     *
     * @access public
     * @param string $request グローバルスコープ名
     *             $request = _GET/_POST/_COOKIE
     */
    function setRequestType($request)
    {
        if (preg_match("/_SESSION/i",$request)){
            $session_id = session_id();
            if (!$session_id){
                session_start();
            }
        } // if (preg_match("/_SESSION/i",$request))
        $this->request_type = $request;
    }

    /**
     * グローバル格納配列の取得
     *
     * @access public
     * @param string $key
     * @return mixed グローバル格納配列
     */
    function getRequest($key)
    {
        return isSet($this->requests[$key])? $this->requests[$key]:null;
    }

    /**
     * 警告格納配列の取得
     *
     * @access public
     * @return array 警告格納配列
     */
    function getAlerts()
    {
        return $this->alerts;
    }

    /**
     * 警告配列の設定
     *
     * @access public
     * @param string $key 入力キー
     * @param string $alert 警告文字列
     */
    function setAlert($key)
    {
        $this->alerts[$key] = true;
        $this->validated = false;
    }

    /**
     * 正当性状態を初期状態に戻す
     *
     * @access public
     * @return void
     */
    function resetValidated()
    {
        $this->alerts = array();
        $this->validated = true;
    }

    /**
     * 正当性状態の取得
     *
     * @access public
     * @return integer チェック結果
     */
    function getValidate()
    {
        return $this->validated;
    }

    /**
     * ダミー
     *
     * @access public
     * @parmas mixed $value
     * @param mixed $option オプション
     * @return boolean 真:正常 偽:エラー
     */
    function dummy($value,$option=null)
    {
        return true;
    }

    /**
     * ストリップタグ
     *
     * @access public
     * @parmas mixed $value
     * @param string $tags ストリップタグ
     * @return mixed ストリップタグ
     */
    function arrayStrip($value, $tags)
    {
        if (!is_array($value)){
            return strip_tags($value, $tags);
        }
        foreach ($value as $key=>$row){
            $value[$key] = RKT_validate::arrayStrip($row, $tags);
        }
        return $value;
    }

    /**
     * 配列の数値検閲
     *
     * @access public
     * @parmas mixed $value
     * @param array $option
     * @return boolean
     */
    function arrayNumber($value,$option=null)
    {
        if (!is_array($value)){
            return RKT_validate::number($value, $option);
        }
        $result = true;
        foreach ($value as $row){
            $result &= RKT_validate::arrayNumber($row, $option);
        }
        return $result;
    }

    /**
     * 必須項目
     *
     * @access public
     * @parmas mixed $value
     * @param mixed $option オプション
     * @return boolean 真:正常 偽:エラー
     */
    function required($value,$option=null)
    {
        if ($value == '') {
            return false;
        }
        return true;
    }

    /**
     * 文字のエスケープ処理など
     *
     * @access private
     * @param mixed $value
     * @retrun mixed
     */
    function escape_character($values)
    {
        if (!is_array($values)){
            $value = trim($values);
            if (get_magic_quotes_gpc()) {
                $value = stripslashes($value);
            }
            $value = str_replace('<', '&lt;', $value);
            $value = str_replace('>', '&gt;', $value);
            return $value;
        }
        $result = array();
        foreach ($values as $key=>$value){
            $result[$key] = RKT_validate::escape_character($value);
        }
        return $result;
    }

    /**
     * 文字のエスケープ処理など
     *
     * @access private
     * @param mixed $value
     * @retrun mixed
     */
    function strip_slashes($values)
    {
        if (!is_array($values)){
            $value = trim($values);
            if (get_magic_quotes_gpc()) {
                $value = stripslashes($value);
            }
            return $value;
        }
        $result = array();
        foreach ($values as $key=>$value){
            $result[$key] = RKT_validate::escape_character($value);
        }
        return $result;
    }

    /**
     * フォーマットの正当性を確認
     *
     * @access public
     * @param string $action 実行するメソッド名
     * @param mixed $key 確認対象情報
     * @param mixed $option オプション
     * @param boolean $required 必須項目
     * @param array $required 必須項目
     * @return boolean 真:正常 偽:エラー
     */
    function validate($action,$key,$option=array(),$required=false,$effect=NULL)
    {
        $source = null;
        $require = ($required) ?'required':'dummy';
        $effect  = empty($effect)? array('RKT_validate', 'escape_character'):$effect;
        /* request値が使用可能か */
        eval('$request = isSet($'.$this->request_type.'[$key]);');
        if ($request){
            eval('$source = $'.$this->request_type.'[$key];');
        }
        $this->requests[$key] = call_user_func($effect, $source);
        $this->alerts[$key] = null;

        /* 対象が日付型の場合 */
        if ($action == 'date'){
            $source = RKT_calendar::joinDate($source);
        }
        /* validateの対象を配列に */
        $values = is_array($source) ? $source : array($source);
        foreach ($values as $value){
            $method = empty($value)?$require:$action;
            $func = array('RKT_validate', $method);

            $result = call_user_func($func, $value, $option);
            if (!$result)   break;
        }

        /* 正当性結果の保存 */
        if (!$result){
            $this->validated = false;
            $this->alerts[$key] = true;
        }

        return $result;
    }

    /**
     * 安全な値の取得
     *
     * @access public
     * @param string $method メソッド名
     * @param string $key グローバルスコープの添え字
     * @param mixed $option オプション
     * @param string $request グローバルスコープ名
     * @return boolean 真:正常 偽:エラー
     */
    function getSafety($method, $key, $option=array(), $request='_REQUEST')
    {
        $isset = false;
        eval('$isset = isSet($'.$request.'[$key]);');
        if (!$isset){
            return null;
        }
        eval('$source = $'.$request.'[$key];');

        /* validateの対象を配列に */
        $values = is_array($source) ? $source : array($source);

        $func = array('RKT_validate', $method);
        foreach ($values as $value){
            $result = call_user_func($func, $value, $option);
            if (!$result)   break;
        }

        /* 不正なデータ */
        if (!$result){
            return null;
        }
        return $source;
    }

    /**
     * 警告の表示
     *
     * @access private
     */
    function displayAlert(&$objhtml,$key='alert')
    {
        $objhtml->Assign($key, $this->alerts);
        if (DEBUG_ENV == 1){
            echo "<div id=\"left\">\n";
            echo "<pre style=\"text-align:left;\">".print_r($this->alerts,true)."</pre>";
            echo "</div>\n";
        }
    }
} // RKT_validate
?>
