<?php
/* ========================================================================
 - [modules/private/item/list.php]
 -      コミュニティ記事一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/12] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/item/list.tpl');

        $this->set_list();
    }

    /**
     * 記事の設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成

        $now = sql_query::now();
        $sql = 
            'SELECT '.
                'id,'.
                'origin,'.
                'open_date,'.
                'subject '.
            'FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'open_date <= '.$now.' AND '.
                'avail = '.AVAIL_ENABLE.' '.
            'ORDER BY '.
                'open_date DESC ';
        $objpgr->setSql($sql);
        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('list', $result);
    }
} // webapp
?>
