<?php
/* ========================================================================
 - [modules/private/home/recent.php]
 -      プロフィール
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * ページstatus
     * @var integer
     */
    var $status = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/home/recent.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('status');
        $this->status = empty($this->status)?1:$this->status; 
        $this->Assign('status', $this->status);

        $titles = array(
            '1'=> '日記への書き込み一覧',
            '2'=> 'コミュニティトピック一覧',
            '3'=> '友達の日記一覧',
        );
        $this->baseAssign('title',  $titles[$this->status]);

        if ($this->status == 1){
            $this->set_post();
        } elseif ($this->status == 2){
            $this->set_topic();
        } else {
            $this->set_fdiary();
        }

        $urls = array(
            STATUS_TOPIC_BULLETIN=> 'bbs/browse',
            STATUS_TOPIC_EVENT=> 'bbs/browse',
            STATUS_TOPIC_ITEM=> 'item/browse',
        );
        $this->Assign('com_urls', $urls);
    }

    /**
     * 日記書き込みの設定
     *
     * @access private
     * @return void
     */
    function set_post()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'com.modify as modify,'.
                'ent.post as ct,'.
                'ent.subject as subject,'.
                'ent.body as body,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent,'.
                DB_PREFIX.'dia_comment com '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'ent.id = com.ref_entry AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'dia.ref_account != '.$this->account['id'].' AND '.
                'com.ref_account = '.$this->account['id'].' '.
            'GROUP BY '.
                'act.id,'.
                'dia.id,'.
                'ent.id '.
            'ORDER BY '.
                'com.modify DESC ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('posts', $result);
    }

    /**
     * コミュニティ掲示板の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $sql=
            'SELECT '.
                'com.id as ref_community,'.
                'com.community as community,'.
                'tpc.id as ref_topic,'.
                'tpc.status as status,'.
                'tpc.topic as subject,'.
                'tpc.comment as body,'.
                'com.modify as modify,'.
                'tpc.post as ct,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.','.
                DB_PREFIX.'com_topic tpc '.
                    'LEFT JOIN '.DB_PREFIX.'com_comment cmt '.
                    'ON tpc.id = cmt.ref_topic,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.id = nam.ref_community AND '.
                'com.id = tpc.ref_community AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'nam.ref_account = '.$this->account['id'].' AND '.
                'nam.status != '.STATUS_COMMUNITY_REFUSAL.' AND '.
                'nam.status != '.STATUS_COMMUNITY_REQUEST.' '.
            'GROUP BY '.
                'com.id,'.
                'tpc.id,'.
                'nam.id '.
            'ORDER BY '.
                'cmt.modify DESC ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('topics', $result);
    }

    /**
     * 友達日記の設定
     *
     * @access private
     * @return void
     */
    function set_fdiary()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'ent.regist_date as modify,'.
                'ent.subject as subject,'.
                'ent.body as body,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id != '.$this->account['id'] .' AND '.
                'act.id = dia.ref_account AND '.
                'act.id = ent.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'fri.ref_account = '.$this->account['id'] .' AND '.
                'fri.ref_friend = act.id '.
            'ORDER BY '.
                'ent.regist_date DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('fdiarys', $result);
    }
} // webapp
?>
