<?php
/* ========================================================================
 - [modules/public/community/search.php]
 -      コミュニティ検索
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/29] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_calendar.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/community/search.tpl');

        $this->set_prefecture();
        $this->set_category();
        $this->set_genre();
        $this->set_date();
    }

    /**
     * 都道府県の設定
     *
     * @access private
     * @return void
     */
    function set_prefecture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'prefecture '.
            'FROM '.
                DB_PREFIX.'ara_prefecture '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['prefecture'];
        }
        
        $this->Assign('prefectures',$list);
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'com_category '.
            'ORDER BY '.
                'ref_genre,sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
        }
        
        $this->Assign('categorys',$list);
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_genre()
    {
        $sql=
            'SELECT '.
                'id,'.
                'genre '.
            'FROM '.
                DB_PREFIX.'com_genre '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[] = array(
                'id'=> $value['id'],
                'genre'=> $value['genre'],
                'categorys'=> $this->get_category($value['id'])
            );
        }
        
        $this->Assign('genre',$list);
    }

    /**
     * カテゴリの取得
     *
     * @access private
     * @return void
     */
    function get_category($ref_genre)
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'com_category '.
            'WHERE '.
                'ref_genre = '.$ref_genre.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $row = 0;
        $column = 0;
        foreach ($result as $value){
            // 改行処理
            if ($column >= 3){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = array(
                    'id'=> $value['id'],
                    'value'=> $value['id'],
                    'label'=> $value['category'],
                    'checked'=> null,
            );
            $column++;
        }

        return $list;
    }

    /**
     * 日付の設定
     *
     * @return void
     **/
    function set_date()
    {
        $timestamp  = time();

    	$years = array();
    	$months = array();
    	$days = array();

    	$num = date('Y',$timestamp);
    	$max_year = $num + 2;
    	for ($num;$num<=$max_year;$num++) {
    		$years[$num] = $num;
    	}
    	for ($num=1;$num<=12;$num++) {
            $num = sprintf('%02d',$num);
    		$months[$num] = $num;
    	}
    	for ($num=1;$num<=31;$num++) {
            $num = sprintf('%02d',$num);
    		$days[$num] = $num;
    	}
    	for ($num=0;$num<=23;$num++) {
            $num = sprintf('%02d',$num);
    		$hours[$num] = $num;
    	}

        $this->Assign('years', $years);
        $this->Assign('months', $months);
        $this->Assign('days', $days);
    }
} // webapp
?>
