<?php
/* ========================================================================
 - [modules/public/content/default.php]
 -      デフォルトページ
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/29] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_crypt.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/content/default.tpl');

        $jumps = array(
            WAP_ACC_ADMIN=>    'admin/inquire/list/',
            WAP_ACC_MEMBER=>   'private/home/',
        );

        $objauth = new RKT_auth();
        if ($objauth->autoLogin()){
            header('Location: '.HTTP_ACTION.'private/home/');
            exit();
        }
        
        if ($this->account['status'] != WAP_ACC_GUEST){
            $this->update_last_login();
            header('Location: '.HTTP_ACTION.$jumps[$this->account['status']]);
            exit();
        }

        $this->Assign('sessionid', RKT_auth::getSessionID());
        $url = empty($_REQUEST['url'])? '':'content/default/';
        $this->Assign('url', $url);
    }

    /**
     * ログイン日時の更新
     *
     * @access private
     * @return boolean 正常時：真
     */
    function update_last_login()
    {
        $sql=
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                "last_login = '".date('Y-m-d H:i:s')."' ".
            'WHERE '.
                'id = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }
} // webapp
?>
