<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty plugin
 *
 * Type:     modifier<br>
 * Name:     rkt_last_login<br>
 * Purpose:  ログイン後の経過時間
 * Example:  {$text|rkt_last_login}
 * @version  1.0
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @param string
 * @return string
 */
function smarty_modifier_rkt_last_login($date)
{
    $elapsed = time() - strtotime($date);

    $minute = ceil($elapsed / 60);  // 経過　分
    $hour = ceil($elapsed / 3600);  // 経過　時
    $day = ceil($elapsed / 86400);  // 経過　日

    if ($minute <= 60) {
        if ($minute <= 3) {
            $string = '3分以内';
        } elseif ($minute <= 5){
            $string = '5分以内';
        } elseif ($minute <= 10){
            $string = '10分以内';
        } elseif ($minute <= 15){
            $string = '15分以内';
        } elseif ($minute <= 30){
            $string = '30分以内';
        } elseif ($minute <= 45){
            $string = '45分以内';
        } else {
            $string = '60分以内';
        }
    } elseif ($hour <= 24){
        $string = $hour.'時間以内';    
    } elseif ($day <= 3){
        $string = $day.'日以内';            
    } else {
        $string = '3日以上';    
    }

    return $string;
}

/* vim: set expandtab: */

?>
