<?php
/* ========================================================================
 - [modules/private/forum/list.php]
 -      トピック一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * コメント削除ID
     * @var integer
     */
    var $delete = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/forum/list.tpl');

        $this->setSafety('delete');

        if ($this->delete_topic()){
            header('Location: '.HTTP_ACTION.'private/forum/list/'.$this->sid.'/');
            exit();
        }
        $this->set_forum();
        $this->set_photo();
        $this->set_topic();

        $icons = array(
            STATUS_TOPIC_BULLETIN=> 'bulletin.gif',
            STATUS_TOPIC_EVENT=> 'event.gif',
        );
        $this->Assign('icons', $icons);
    }

    /**
     * フォーラム情報の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return void
     */
    function set_forum()
    {
        $sql=
            'SELECT '.
                'sum(post) as total,'.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('forum', $result);
    }

    /**
     * 写真の設定
     *
     * @access private
     * @return void
     */
    function set_photo()
    {
        $sql=
            'SELECT '.
                'subject,'.
                'filename as src,'.
                'width,'.
                'height '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'status = '.STATUS_PHOTO_MAIN.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->Assign('photo', $result);
    }

    /**
     * トピック一覧の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_FORUM);    // クラスの生成
        $sql=
            'SELECT '.
                'id,'.
                'post,'.
                'topic,'.
                'comment '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'modify DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $list = array();
        foreach ($result as $value){
            $list[] = array(
                'id'=> $value['id'],
                'post'=> $value['post'],
                'topic'=> $value['topic'],
                'comment'=> $value['comment'],
                'pictures'=> $this->get_picture($value['id'])
            );
        }

        $this->Assign('list', $list);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return void
     */
    function get_picture($ref_topic)
    {
        $sql=
            'SELECT '.
                'id,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'status = '.STATUS_PICTURE_TOPIC.' AND '.
                'ref_relation = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        return $result;
    }

    /**
     * トピックの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_topic()
    {
        if (empty($this->delete)){
            return false;
        }
        $sql=
            'SELECT '.
                'ref_account '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'id ='.$this->delete.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result)){
            return false;
        } // if (!$this->admin)

        $this->delete_comment();
        $this->delete_picture($this->delete, STATUS_PICTURE_TOPIC);
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'id ='.$this->delete;
        return $this->objdb->exec($sql);
    }

    /**
     * コメントの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_comment()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'ref_topic = '.$this->delete;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        foreach ($result as $value){
            $this->delete_picture($value['id'], STATUS_PICTURE_COMMENT);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'ref_topic = '.$this->delete;
        return $this->objdb->exec($sql);
    }

    /**
     * 添付画像の削除
     *
     * @access private
     * @return boolean
     */
    function delete_picture($ref_relation, $status)
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'status = '.$status.' AND '.
                'ref_relation = '.$ref_relation;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_blob::getInstance();
        foreach ($result as $value){
            $objblb->unlink(ARCHIVES_DIR.$value['filename']);
            $objblb->unlink(ARCHIVES_DIR.$value['thumbnail']);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'status = '.$status.' AND '.
                'ref_relation = '.$ref_relation;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
