<?php
/* ========================================================================
 - [modules/public/content/default.php]
 -      デフォルトページ
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/05/27] 携帯端末IDによる自動ログイン処理の追加
 -      [2006/07/29] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_crypt.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/content/default.tpl');

        $objauth = new RKT_auth();
        if ($objauth->autoLoginUserAgentID()){
            $this->update_last_login();
            $this->sid = RKT_auth::getSessionID();
            header('Location: '.HTTP_ACTION.'private/home/menu/'.$this->sid.'/');
            $this->print_url(HTTP_ACTION.'private/home/menu/'.$this->sid.'/');
            exit();
        }
        
        if ($this->account['status'] != WAP_ACC_GUEST){
            $this->update_last_login();
            header('Location: '.HTTP_ACTION.'private/home/menu/'.$this->sid.'/');
            $this->print_url(HTTP_ACTION.'private/home/menu/'.$this->sid.'/');
            exit();
        }

        $this->Assign('sessionid', RKT_auth::getSessionID());
        $url = empty($_REQUEST['url'])? '':'content/default/';
        $this->Assign('url', $url);
    }

    /**
     * ログイン日時の更新
     *
     * @access private
     * @return boolean 正常時：真
     */
    function update_last_login()
    {
        $sql=
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                "last_login = '".date('Y-m-d H:i:s')."' ".
            'WHERE '.
                'id = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }

    /**
     * リダイレクト出来ない場合の表示
     *
     * @access public
     * @return void
     **/
    function print_url($url)
    {
        $body  = '<html>';
        $body .= '<head>';
        $body .= '<meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS">';
        $body .= '<title>{$base.title}</title>';
        $body .= '</head>';
        $body .= '<body>';
        $body .= '<h1 align="center"><font color="#087794">'.WAP_SYSTEM_NAME.'</font></h1><hr />';
        $body .= '<a accesskey="0" href="'.$url.'">[0]ページ移動</a>';
        $body .= '<hr />'.COPYRIGHT;
        $body .= '</body>';
        $body .= '</html>';

        $body = mb_convert_encoding($body, 'SJIS', 'UTF-8');
        print($body);
    }
} // webapp
?>
