<?php
/* ========================================================================
 - [webapp/libs/private/act_exit.php]
 -      退会、関連レコード削除処理
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/03] お友達招待削除を追加
 -      [2006/08/20] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_blob.php';

/**
 * 退会、関連レコード削除処理クラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package act_exit
 * @access public
 * @version 1.0
 */
class act_exit
{
    /**
     * アカウントID
     * @var integer
     */
    var $ref_account = 0;

    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * BLOB操作オブジェクト
     * @var object
     */
    var $objfile = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param integer $ref_account
     * @return void
     */
    function act_exit($ref_account)
    {
        $this->objdb = RKT_db::getInstance();
        $this->objfile = RKT_blob::getInstance(BLOB_DRIVER,BLOB_PARAM);
        
        $this->ref_account = $ref_account;
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->delete_community();
        $this->delete_review();
        $this->delete_forum();
        $this->delete_diary();
        $this->delete_friend();
        $this->delete_account();

        $this->objfile->delete(array('uid'=>$this->ref_account));
    }

    /**
     * アカウントの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_account()
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_content '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_select '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'cal_schedule '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_autologin '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'id = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * 友達情報の削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_friend()
    {
        /* 友達紹介 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_intro '.
            'WHERE '.
                '(ref_account = '.$this->ref_account.' OR '.
                'ref_friend = '.$this->ref_account.')';
        $this->objdb->exec($sql);

        /* お気に入り */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_favorite '.
            'WHERE '.
                '(ref_account = '.$this->ref_account.' OR '.
                'ref_friend = '.$this->ref_account.')';
        $this->objdb->exec($sql);

        /* お友達リストの取得 */
        $friends = $this->get_relation();

        /* お友達リスト相互削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                '(ref_account = '.$this->ref_account.' OR '.
                'ref_friend = '.$this->ref_account.')';
        $this->objdb->exec($sql);
        
        /* 友達人数を更新 */
        foreach ($friends as $ref_account){
            $this->friend_total($ref_account);
        }

        /* メッセージ */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_message '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 足跡 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_footprint '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* アクセスログ */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_accesslog '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 友達招待 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_invite '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 友達招待 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_invite '.
            'WHERE '.
                'ref_friend = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * 友達人数を更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function friend_total($ref_account)
    {
        $sql=
            'SELECT '.
                'count(id) as total '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $total = empty($result['total'])?0:$result['total'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                'friend_number = '.$total.' '.
            'WHERE '.
                'id = '.$ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * 友達のつながり取得
     *
     * @access public
     * @return void
     */
    function get_relation()
    {
        $sql=
            'SELECT '.
                'ref_account as friend '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_friend ='.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        if (empty($result)){
            return array();
        }
        
        foreach ($result as $value){
            $list[] = $value['friend'];
        }
        return $list;
    }

    /**
     * 日記の削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_diary()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_select '.
            'WHERE '.
                'ref_diary = '.$result['id'];
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_category '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_comment '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * フォーラムの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_forum()
    {
        /* 画像の削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 書き込みコメントの削除 */
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        foreach ($result as $value){
            $sql =
                'DELETE FROM '.
                    DB_PREFIX.'frm_response '.
                'WHERE '.
                    'ref_comment = '.$value['id'];
            $this->objdb->exec($sql);
        }
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);


        /* トピックの削除 */
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        foreach ($result as $value){
            $sql =
                'DELETE FROM '.
                    DB_PREFIX.'frm_response '.
                'WHERE '.
                    'ref_topic = '.$value['id'];
            $this->objdb->exec($sql);

            $sql =
                'DELETE FROM '.
                    DB_PREFIX.'frm_comment '.
                'WHERE '.
                    'ref_topic = '.$value['id'];
            $this->objdb->exec($sql);

            $sql =
                'DELETE FROM '.
                    DB_PREFIX.'frm_select '.
                'WHERE '.
                    'ref_topic = '.$value['id'];
            $this->objdb->exec($sql);
        }
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * レビューの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_review()
    {
        /* コメントの削除 */
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'rev_review '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        foreach ($result as $value){
            $this->review_total($value['id']);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'rev_review '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        return $this->objdb->exec($sql);
    }

    /**
     * ポイント総数を更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function review_total($id)
    {
        $sql = 
            'SELECT '.
                '(sum(point) / count(id)) as total,'.
                'count(id) as point '.
            'FROM '.
                DB_PREFIX.'rev_review '.
            'WHERE '.
                'ref_item = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $total = empty($result['total'])?0:$result['total'];
        $point = empty($result['point'])?0:$result['point'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'rev_item '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                'total = '.$total.','.
                'post = '.$point.' '.
            'WHERE '.
                'id = '.$id;
        $this->objdb->exec($sql);
    }

    /**
     * コミュニティ関連の削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_community()
    {
        /* 名簿の削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* コメントの削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* イベント参加の削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* トピック作者の変更 */
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_topic '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        foreach ($result as $value){
            $this->group_topic($value['id']);
        }

        /* 画像の削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }
}
// act_exitの終了
?>
