<?php
/* ========================================================================
 - [modules/admin/account/mails.php]
 -      メール配信
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/06] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * 削除ID
     * @var integer
     */
    var $delete = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));
        
        $this->setTemplateFile('admin/account/mails.tpl');
        $this->setSafety('delete');

        if ( preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }

        if (!empty($_REQUEST['new'])){
            header('Location: '.HTTP_ACTION.'admin/account/sendmail/');
            exit();
        }

        $this->set_regist_date();
        $this->set_list();

        // 削除
        if ($this->delete_mail()){
            header('Location: '.HTTP_ACTION.'admin/account/mails/complete/');
            exit();
        }

        $status = array(
            STATAS_MAIL_ROUGH=> STATAS_MAIL_LABEL_ROUGH,
            STATAS_MAIL_SEND=>  STATAS_MAIL_LABEL_SEND,
            STATAS_MAIL_SENT=>  STATAS_MAIL_LABEL_SENT,
        );
        $this->Assign('status',$status);
    }

    /**
     * 活動分野の設定
     *
     * @access private
     * @return void
     */
    function set_regist_date()
    {
        $date_format = sql_query::dateFormat('regist_date','%Y%m');
        $label_format = sql_query::dateFormat('regist_date','%Y-%m-01');
        $sql=
            'SELECT '.
                $date_format.' as value,'.
                $label_format.' as label '.
            'FROM '.
                DB_PREFIX.'sys_mail '.
            'GROUP BY '.
                'value';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            $list[$value['value']] = $value['label'];
        }
        
        $this->Assign('regist_dates',$list);
    }

    /**
     * 配信メールリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $where = $this->add_where();
        $sql = 
            'SELECT '.
                'id,'.
                'modify,'.
                'regist_date,'.
                'status,'.
                'subject,'.
                'body '.
            'FROM '.
                DB_PREFIX.'sys_mail '.
                $where.
            'ORDER BY '.
                'regist_date';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $this->Assign('list', $result);
    }

    /**
     * 配信メールの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function add_where()
    {
        /* 絞込条件の取得 */
        $validates = array(
            /* 記事の作成日 */
            'regist_date'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            /* 記事の状態 */
            'status'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );
        $conditions = $this->catchCondition($validates);

        // 絞込み条件の初期化
        $where = array();
        /* 記事の作成日時 */
        if (!empty($conditions['regist_date'])){
            $date_format = sql_query::dateFormat('regist_date','%Y%m');
            $where[] = $date_format."='".$conditions['regist_date']."'";
        }

        /* 記事の状態 */
        if (!empty($conditions['status'])){
            $where[] = 'status='.$conditions['status'];
        }
        
        if (!count($where)){
            return '';
        }

        return 'WHERE '. implode(' AND ',$where) .' ';
    }

    /**
     * 配信メールの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_mail()
    {
        if (empty($this->delete)){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'sys_mail '.
            'WHERE '.
                'id ='.$this->delete;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
