<?php
/* ========================================================================
 - [modules/admin/design/css.php]
 -      スタイルシート編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/07] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * スタイルシート名
     * @var string
     */
    var $css = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/design/css.tpl');        
        $this->addJavas('admin.js');

        // URL引数の取得
        $this->setSafety('css', '_REQUEST', 'string');
        $css_array = array(
            'common', 'admin', 'private', 'friend', 'community', 'public'
        );
        if (!in_array($this->css, $css_array)){
            $this->css = 'common';
        }
        $this->Assign('css', $this->css);

        if (!empty($_POST['manip'])){
            $this->update_css();
            $this->Assign('complete', true);
        }
        
        $this->set_label();
        $this->set_css();
    }

    /**
     * ラベルの設定
     *
     * @access private
     * @return void
     */
    function set_label()
    {
        $labels = array(
            'common'=>    '共通CSS',
            'admin'=>     '管理者ページ',
            'private'=>   'プライベートページ',
            'friend'=>    '友達ページ',
            'community'=> 'コミュニティページ',
            'public'=>    '一般ページ'
        );
        $this->Assign('label',$labels[$this->css]);
    }

    /**
     * スタイルシートの設定
     *
     * @access private
     * @return void
     */
    function set_css()
    {
        /* ファイルの読み込み */
        $filename = RESOURCE_DIR.'css'.DIRECTORY_SEPARATOR.$this->css.'.css';
        $fp = fopen($filename, 'r');
        if (!$fp){
            return ;
        }
        $buff = '';
        $fsize = filesize($filename);
        if ($fsize) {
            $buff = fread($fp, $fsize);
        } else {
            while (!feof($fp)){
                $buff .= fread($fp, 1024);
            }
        }
        fclose($fp);

        $buff = mb_convert_encoding($buff, ENCODE_TYPE, 'SJIS');

        $this->Assign('body', $buff);
    }

    /**
     * スタイルシートの書き込み
     *
     * @access private
     * @return void
     */
    function update_css()
    {
        $output = mb_convert_encoding($_POST['body'], 'SJIS', ENCODE_TYPE);

        /* ファイルの読み込み */
        $filename = RESOURCE_DIR.'css'.DIRECTORY_SEPARATOR.$this->css.'.css';
        $fp = @fopen($filename, 'w');
        if (!$fp){
            return ;
        }
        @fwrite($fp, $output);
        fclose($fp);
    }
} // webapp
?>
