<?php
/* ========================================================================
 - [modules/admin/sponsor/list.php]
 -      スポンサーバナー一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/02] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/sponsor/list.tpl');

        if ( preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }

        if (!empty($_REQUEST['new'])){
            header('Location: '.HTTP_ACTION.'admin/sponsor/sponsor/');
            exit();
        }

        // 一括更新
        if ($this->do_querys()){
            header('Location: '.HTTP_ACTION.'admin/sponsor/list/complete/');
            exit();
        }

        $this->set_list();
        $position = array(
            '1'=> 'ヘッダー',
            '2'=> '中央',
            '3'=> 'サイド',
        );
        $this->Assign('positions', $position);
    }

    /**
     * リストの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function add_where()
    {
        /* 絞込条件の取得 */
        $validates = array(
            'position'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );
        $conditions = $this->catchCondition($validates);

        // 絞込み条件の初期化
        $where = array();

        /* キーワード検索 */
        $keys = array();
        if (!empty($conditions['position'])){
            $where[] = 'position='.$conditions['position'];
        }
        
        if (!count($where)){
            return '';
        }
        return 'WHERE '. implode(' AND ',$where) .' ';
    }

    /**
     * リストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $where = $this->add_where();
        $sql = 
            'SELECT '.
                'id,'.
                'avail,'.
                'sponsor,'.
                'html '.
            'FROM '.
                DB_PREFIX.'sys_sponsor '.
                $where.
            'ORDER BY '.
                'id';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $this->Assign('list', $result);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_querys()
    {
        if (empty($_POST['manips'])){
            return false;
        }
        foreach ($_POST['edits'] as $values){
            $this->update_query($values);
        }
        return true;
    }

    /**
     * 更新処理
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function update_query($values)
    {
        $id    = RKT_validate::number($values['id'])?$values['id']:0;
        $id    = $this->objdb->quote($id);
        $avail = empty($values['avail'])?AVAIL_DISABLE:AVAIL_ENABLE;

        $sql =
            'UPDATE '.
                DB_PREFIX.'sys_sponsor '.
            'SET '.
                'avail = '.$avail.' '.
            'WHERE '.
                'id = '.$id;
        return $this->objdb->query($sql);
    }

} // webapp
?>
