<?php
/* ========================================================================
 - [libs/rktPDO/rkt_pdo.php]
 -      なんちゃってPDO
 -      Copyright (c) 2005-2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/12/18]    定数定義をrkt_pdo.phpへ集中
 -      [2006/09/29]    定数定義を個々のドライバへ分散
 -      [2005/03/19]    bindParam追加・RSL_sqlite::query()の戻り値を修正
 -      [2005/01/08]    作成
 - ======================================================================== */

if (!defined('PDO_ATTR_ERRMODE')){
    define('PDO_ATTR_ERRMODE',TRUE);
}
if (!defined('PDO_ERRMODE_EXCEPTION')){
    define('PDO_ERRMODE_EXCEPTION',TRUE);
}

if (!defined('PDO_PARAM_NULL')){
    define('PDO_PARAM_NULL',1);
}
if (!defined('PDO_PARAM_INT')){
    define('PDO_PARAM_INT',2);
}
if (!defined('PDO_PARAM_STR')){
    define('PDO_PARAM_STR',3);
}
if (!defined('PDO_PARAM_LOB')){
    define('PDO_PARAM_LOB',4);
}
if (!defined('PDO_PARAM_STMT')){
    define('PDO_PARAM_STMT',5);
}

if (!defined('PDO_FETCH_ASSOC')){
    define('PDO_FETCH_ASSOC',   1);
}
if (!defined('PDO_FETCH_NUM')){
    define('PDO_FETCH_NUM',     2);
}
if (!defined('PDO_FETCH_BOTH')){
    define('PDO_FETCH_BOTH',    3);
}

/**
 * なんちゃってPDO
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_pdo
 * @access public
 * @version 1.0
 */
class RKT_pdo
{
    /**
     * メンバ変数DB接続ハンドルの吐き出し
     *
     * @access public
     * @return object DB接続ハンドル
     */
    function &factory($dsn, $username, $passwd, $driver_opts=NULL)
    {
        $dsns = RKT_pdo::parseDSN($dsn);
        $dsns['username'] = $username;
        $dsns['passwd']   = $passwd;

        include_once LIB_DIR.'rktPDO/drivers/rkt_'.$dsns['driver'].'.php';

        $classname = 'RKT_'.$dsns['driver'];

        $obj =& new $classname($dsns);

        return $obj;
    }

    /**
     * データベースソースネームの解析
     *
     * @access public
     * @param string $dsn
     * @return void
     */
    function parseDSN($dsn)
    {
        $parsed = array();
        $parse = explode(':',$dsn); 
        $parsed['driver'] = $parse[0];

        if (preg_match('/sqlite/i',$parsed['driver'])){
            $pos = strpos ($dsn,':');
            $parsed['file'] = substr ($dsn, $pos+1);

            return $parsed;
        }
        
        $parts = array(
            'dbname',
            'host',
            'port',
        );
        $sources = explode(';',$parse[1]); 

        foreach ($sources as $source){
            foreach ($parts as $key){
                if (preg_match("/".$key."/i",$source)){
                    $parsed[$key] = preg_replace("/".$key."=/i",'',$source);
                }
            } // foreach ($parts as $key)
        } // foreach ($sources as $source)

        return $parsed;
    }
} // RKT_pdoの終了
?>