<?php
/* ========================================================================
 - [modules/community/item/commnet.php]
 -      コメント
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/19] メールによる画像添付機能追加
 -      [2007/07/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * トピックID
     * @var integer
     */
    var $ref_topic = 0;

    /**
     * 選択肢ID
     * @var integer
     */
    var $ref_option = 0;

    /**
     * コメント削除ID
     * @var integer
     */
    var $delete = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/item/comment.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_topic', 1);
        $this->Assign('ref_topic', $this->ref_topic);
        $this->setPathInfo('ref_option', 2);
        $this->Assign('ref_option', $this->ref_option);
        $this->setSafety('delete');

        /* 非公開でメンバーではない */
        if (!$this->get_visibility()){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->sid.'/'.$this->ref_community.'/'.$this->ref_topic.'/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/item/comment/'.$this->sid.'/'.$this->ref_community.'/'.$this->ref_topic.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_itmselect');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->update_topic();
            header('Location: '.HTTP_ACTION.'community/item/browse/'.$this->sid.'/'.$this->ref_community.'/'.$this->ref_topic.'/complete/#bar');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'community/item/comment/'.$this->sid.'/'.$this->ref_community.'/'.$this->ref_topic.'/confirm/#editform');
            exit();
        }

        /* コメントの削除 */
        if ($this->delete_comment()){
            $this->update_topic();
            header('Location: '.HTTP_ACTION.'community/item/comment/'.$this->sid.'/'.$this->ref_community.'/'.$this->ref_topic.'/'.$this->ref_option.'/complete/#bar');
            exit();
        }

        
        $this->set_item();
        $this->set_option();
        $this->set_comment();
        $this->set_bar();
    }

    /**
     * 表示の設定
     *
     * @access private
     * @return void
     */
    function get_visibility()
    {
        $visibility = true;
        /* 非公開 */
        if ($this->community['visibility'] == VISIBILITY_HIDDEN){
            $visibility = $this->community['is_member'];
        }
        return $visibility;
    }

    /**
     * トピック一覧の設定
     *
     * @access private
     * @return void
     */
    function set_item()
    {
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.regist_date as regist_date,'.
                'tpc.start_date as start_date,'.
                'tpc.deadline as deadline,'.
                'tpc.start_hour as start_hour,'.
                'tpc.start_minute as start_minute,'.
                'pro.nickname as nickname,'.
                'tpc.ref_account as ref_account,'.
                'tpc.status as status,'.
                'tpc.ref_prefecture as ref_prefecture,'.
                'tpc.sub_locale as sub_locale,'.
                'tpc.topic as topic,'.
                'tpc.comment as body '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_topic tpc '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.ref_community = '.$this->ref_community.' AND '.
                'tpc.id = '.$this->ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('topic', $result);
    }

    /**
     * アンケート項目の設定
     *
     * @access private
     * @return void
     **/
    function set_option()
    {
        $sql = 
            'SELECT '.
                'id,'.
                'item '.
            'FROM '.
                DB_PREFIX.'com_option '.
            'WHERE '.
                'ref_community ='.$this->ref_community.' AND '.
                'ref_topic ='.$this->ref_topic.' '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['item'];
        }

        $this->Assign('options', $list);
    }

    /**
     * バーリストの設定
     *
     * @access private
     * @return void
     **/
    function set_bar()
    {
        $sql = 
            'SELECT '.
                'opt.id as id,'.
                'opt.item as item,'.
                'count(sel.ref_account) as vote '.
            'FROM '.
                DB_PREFIX.'com_option opt '.
                    'LEFT JOIN '.DB_PREFIX.'com_itmselect sel '.
                    'ON opt.id = sel.ref_option '.
            'WHERE '.
                'opt.ref_community = '.$this->ref_community.' AND '.
                'opt.ref_topic = '.$this->ref_topic.' '.
            'GROUP BY '.
                'opt.id '.
            'ORDER BY '.
                'vote DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $par = 200;
        if ($result[0]['vote']!=0){
            $par = 200 / $result[0]['vote'];
        }
        $list = array();
        foreach ($result as $value){
            $list[] = array(
                'id'=>   $value['id'],
                'item'=> $value['item'],
                'vote'=> $value['vote'],
                'bar'=>  intval($value['vote'] * $par)
            );
        }
        $this->Assign('bars', $list);        
    }

    /**
     * カレントIDの取得
     *
     * @access private
     * @return void
     */
    function set_curid()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_itmselect '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->ref_topic.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->id = empty($result['id'])?null:$result['id'];
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $this->set_curid();
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_community', $this->ref_community);
        $this->objmnp->setValue('ref_topic', $this->ref_topic);
        $this->objmnp->setValue('ref_account', $this->account['id']);

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
        );
        return $this->objmnp->execute($this, $skip);
    }


    /**
     * コメント一覧の設定
     *
     * @access private
     * @return void
     */
    function set_comment()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_COMMENT);    // クラスの生成
        $sql=
            'SELECT '.
                'sel.id as id,'.
                'pro.nickname as nickname,'.
                'pro.ref_account as ref_account,'.
                'sel.regist_date as regist_date,'.
                'sel.comment as comment,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_itmselect sel '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = sel.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'sel.ref_community = '.$this->ref_community.' AND '.
                'sel.ref_topic = '.$this->ref_topic.' AND '.
                'sel.ref_option = '.$this->ref_option.' '.
            'ORDER BY '.
                'sel.regist_date DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('comment', $result);
    }

    /**
     * コメントの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_comment()
    {
        if (empty($this->delete)){
            return false;
        }
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_itmselect '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->ref_topic.' AND '.
                'ref_account = '.$this->account['id'].' AND '.
                'id ='.$this->delete;
        return $this->objdb->exec($sql);
    }

    /**
     * トピックの更新日を更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_topic()
    {
        $sql = 
            'SELECT '.
                'count(*) as post '.
            'FROM '.
                DB_PREFIX.'com_itmselect '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $post = empty($result['post'])?0:$result['post'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_topic '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                'post = '.$post.' '.
            'WHERE '.
                'id = '.$this->ref_topic;
        $this->objdb->exec($sql);
    }
} // webapp
?>
