<?php
/* ========================================================================
 - [modules/community/show/home.php]
 -      コミュニティホーム
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/16] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/show/home.tpl');

        $this->set_community();
        $this->set_member();
        $this->set_topic();
        $this->set_event();
        $this->set_item();
        $this->set_enquete();

        $this->doFootprint();

        $visibilitys = array(
            VISIBILITY_PUBLIC=>  VISIBILITY_LABEL_PUBLIC_ENTRY,
            VISIBILITY_PRIVATE=> VISIBILITY_LABEL_PRIVATE_ENTRY,
            VISIBILITY_HIDDEN=>  VISIBILITY_LABEL_HIDDEN_ENTRY,
        );
        $this->Assign('visibilitys', $visibilitys);
    }

    /**
     * コミュニティ情報の設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.community as community,'.
                'com.regist_date as regist_date,'.
                'com.visibility as visibility,'.
                'com.total as total,'.
                'com.publicity as publicity,'.
                'com.ref_account as ref_account,'.
                'pro.nickname as nickname,'.
                'prf.prefecture as prefecture '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'ara_prefecture prf,'.
                DB_PREFIX.'com_community com '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = com.ref_account AND '.
                'prf.id = com.ref_prefecture AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'com.id = '.$this->ref_community;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('community',$result);
    }

    /**
     * 会員の設定
     *
     * @access private
     * @return void
     */
    function set_member()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = nam.ref_account AND '.
                'nam.ref_community = '.$this->ref_community .' AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                sql_query::bitFlag('nam.status & '.STATUS_COMMUNITY_MEMBERS).' '.
            'ORDER BY '.
                'act.last_login '.
            'LIMIT 6';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $this->Assign('member', $result);
    }

    /**
     * トピックの設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.modify as modify,'.
                'tpc.topic as topic,'.
                'tpc.post as post '.
            'FROM '.
                DB_PREFIX.'com_topic tpc '.
                    'LEFT JOIN '.DB_PREFIX.'com_comment cmt '.
                    'ON tpc.id = cmt.ref_topic,'.
                DB_PREFIX.'act_account act '.
            'WHERE '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.status = '.STATUS_TOPIC_BULLETIN.' AND '.
                'tpc.ref_community = '.$this->ref_community.' '.
            'GROUP BY '.
                'tpc.id '.
            'ORDER BY '.
                'tpc.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('topics', $result);
    }

    /**
     * イベントの設定
     *
     * @access private
     * @return void
     */
    function set_event()
    {
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.modify as modify,'.
                'tpc.topic as topic,'.
                'tpc.post as post '.
            'FROM '.
                DB_PREFIX.'com_topic tpc '.
                    'LEFT JOIN '.DB_PREFIX.'com_comment cmt '.
                    'ON tpc.id = cmt.ref_topic,'.
                DB_PREFIX.'act_account act '.
            'WHERE '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.status = '.STATUS_TOPIC_EVENT.' AND '.
                'tpc.ref_community = '.$this->ref_community.' '.
            'GROUP BY '.
                'tpc.id '.
            'ORDER BY '.
                'tpc.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('events', $result);
    }

    /**
     * 記事の設定
     *
     * @access private
     * @return void
     */
    function set_item()
    {
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.modify as modify,'.
                'tpc.topic as topic,'.
                'tpc.post as post '.
            'FROM '.
                DB_PREFIX.'com_topic tpc '.
                    'LEFT JOIN '.DB_PREFIX.'com_comment cmt '.
                    'ON tpc.id = cmt.ref_topic,'.
                DB_PREFIX.'act_account act '.
            'WHERE '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.status = '.STATUS_TOPIC_ITEM.' AND '.
                'tpc.ref_community = '.$this->ref_community.' '.
            'GROUP BY '.
                'tpc.id '.
            'ORDER BY '.
                'tpc.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('items', $result);
    }

    /**
     * アンケートの設定
     *
     * @access private
     * @return void
     */
    function set_enquete()
    {
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.modify as modify,'.
                'tpc.topic as topic,'.
                'tpc.post as post '.
            'FROM '.
                DB_PREFIX.'com_topic tpc '.
                    'LEFT JOIN '.DB_PREFIX.'com_comment cmt '.
                    'ON tpc.id = cmt.ref_topic,'.
                DB_PREFIX.'act_account act '.
            'WHERE '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.status = '.STATUS_TOPIC_ENQUETE.' AND '.
                'tpc.ref_community = '.$this->ref_community.' '.
            'GROUP BY '.
                'tpc.id '.
            'ORDER BY '.
                'tpc.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('enquetes', $result);
    }
} // webapp
?>
