<?php
/* ========================================================================
 - [modules/private/account/autologin.php]
 -      自動ログイン設定
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/01/16] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_validate.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));
        $this->setTemplateFile('private/account/autologin.tpl');

        if ($this->do_query()){
            $_SESSION['complete'] = true;
            header('Location: '.HTTP_ACTION.'private/account/autologin/'.$this->sid.'/');
            exit();
        }
        
        if (!empty($_SESSION['complete'])){
            $this->Assign('complete', true);
            unset($_SESSION['complete']);
        }
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {        
        /* アクション処理 */
        if (empty($_REQUEST['manip'])){
            return false;
        }

        $objauth = new RKT_auth($this->sid);
        $result = $objauth->setAutoLoginUserAgentID();
        
        if (empty($result)){
            $this->Assign('error', true);
        }
        return $result;
    }
} // webapp
?>
