<?php
/* ========================================================================
 - [modules/private/content/question.php]
 -      アンケート結果
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/12] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * アンケートID
     * @var integer
     */
    var $id = null;

    /**
     * ページ名
     * @var string
     */
    var $origin = '';

    /**
     * コメント削除ID
     * @var integer
     */
    var $delete = 0;

    /**
     * 記事情報ID
     * @var integer
     */
    var $ref_item = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/content/question.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);

        /* PathInfoによる引数の取得 */
        $this->setPathInfo('origin',0,'string');
        $this->Assign('origin', $this->origin);
        $this->setSafety('delete');

        $this->set_content();
        $this->set_option();
        $this->set_comment();

        if ($this->delete_comment()){
            header('Location: '.HTTP_ACTION.'private/content/browse/'.$this->sid.'/'.$this->origin.'/complete/#bar');
            exit();
        }

    }

    /**
     * 記事の設定
     *
     * @access private
     * @return void
     **/
    function set_content()
    {
        $now = date('Y-m-d H:i:s');
        $sql = 
            'SELECT '.
                'id,'.
                'modify,'.
                'subject,'.
                'body '.
            'FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                "open_date <= '".$now."' AND ".
                "origin='".$this->origin."' ";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->ref_item = $result['id'];

        $subject = empty($result['subject'])?'コンテンツ':$result['subject'];
        $this->baseAssign('title', $subject);
        $this->Assign('item', $result);
    }

    /**
     * アンケート項目の設定
     *
     * @access private
     * @return void
     **/
    function set_option()
    {
        $sql = 
            'SELECT '.
                'opt.id as id,'.
                'opt.item as item,'.
                'count(sel.ref_account) as vote '.
            'FROM '.
                DB_PREFIX.'itm_option opt '.
                    'LEFT JOIN '.DB_PREFIX.'itm_select sel '.
                    'ON opt.id = sel.ref_option '.
            'WHERE '.
                'opt.ref_item = '.$this->ref_item.' '.
            'GROUP BY '.
                'opt.id '.
            'ORDER BY '.
                'vote DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $par = 200;
        if ($result[0]['vote']!=0){
            $par = 200 / $result[0]['vote'];
        }
        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = array(
                'id'=>   $value['id'],
                'item'=> $value['item'],
                'vote'=> $value['vote'],
                'bar'=>  intval($value['vote'] * $par)
            );
        }
        $this->Assign('result', $list);        
    }

    /**
     * コメント一覧の設定
     *
     * @access private
     * @return void
     */
    function set_comment()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_COMMENT);    // クラスの生成
        $sql=
            'SELECT '.
                'sel.id as id,'.
                'pro.nickname as nickname,'.
                'pro.ref_account as ref_account,'.
                'sel.regist_date as regist_date,'.
                'sel.comment as comment,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'itm_select sel '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = sel.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'sel.ref_item = '.$this->ref_item.' AND '.
                'sel.ref_option = '.$this->id.' '.
            'ORDER BY '.
                'sel.regist_date DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('comment', $result);
    }

    /**
     * コメントの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_comment()
    {
        if (empty($this->delete)){
            return false;
        }
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'itm_select '.
            'WHERE '.
                'ref_item = '.$this->ref_item.' AND '.
                'ref_account = '.$this->account['id'].' AND '.
                'id ='.$this->delete;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
