<?php
/* ========================================================================
 - [modules/private/diary/post.php]
 -      日記記事投稿
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/19] メールによる画像添付機能追加
 -      [2007/07/24] 過去の日付指定を追加
 -      [2007/07/24] カテゴリ選択更新時エラーを修正
 -      [2007/06/16] 日記の公開レベルを追加
 -      [2007/02/02] カテゴリ選択更新時エラーを修正
 -      [2006/07/25] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'dia_menu.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 記事ID
     * @var integer
     */
    var $id = null;

    /**
     * 日記ID
     * @var integer
     */
    var $ref_diary = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 添付画像操作オブジェクト
     * @var object
     */
    var $objpic = null;

    /**
     * 選択済みカテゴリ
     * @var integer
     */
    var $dia_select = array();

    /**
     * 添付画像を送信
     * @var integer
     */
    var $attach = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/diary/post.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->permission();
        $this->Assign('id', $this->id);

        /* 削除処理 */
        if ($this->delete_entry()){
            header('Location: '.HTTP_ACTION.'private/diary/list/'.$this->sid.'/complete/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/diary/post/'.$this->sid.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
        $this->set_ref_diary();

        
        $this->set_dia_select();        // 選択済みカテゴリの取得
        $this->set_attach();            // 画像添付フラグの設定

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'dia_entry');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();
            
            // 選択済みカテゴリ処理
            $this->do_query_select();
            unset($_SESSION['dia_select']);
            
            $this->mail_action();
            unset($_SESSION['attach']);

            header('Location: '.HTTP_ACTION.'private/diary/post/'.$this->sid.'/complete/'.WAP_URI_SEPARATOR.'id='.$this->id.'&attach='.$this->attach);
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            $_SESSION['dia_select'] = $this->dia_select;
            $_SESSION['attach']     = $this->attach;
            header('Location: '.HTTP_ACTION.'private/diary/post/'.$this->sid.'/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        /* メニューオブジェクトの生成 */
        $objmenu = new dia_menu($this,$this->account['id']);
        $objmenu->setMenu($this->account['id']);

        $this->set_category();
        $this->set_date();

        $visibilitys = array(
            VISIBILITY_PUBLIC=>    VISIBILITY_LABEL_PUBLIC,
            VISIBILITY_PROTECTED=> VISIBILITY_LABEL_PROTECTED,
            VISIBILITY_FRIEND=>    VISIBILITY_LABEL_FRIEND,
            VISIBILITY_HIDDEN=>    VISIBILITY_LABEL_HIDDEN,
        );
        $this->Assign('visibilitys', $visibilitys);
        $this->Assign('attach', $this->attach);
    }

    /**
     * 対象IDに編集権限があるか
     *
     * @access private
     * @return void
     */
    function permission()
    {
        if (empty($this->id)){
            return ;
        }
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['id'])){
            $this->id = null;        
        }
    }

    /**
     * 日付の設定
     *
     * @return void
     **/
    function set_date()
    {
    	$years = array();
    	$months = array();
    	$days = array();

    	$max_year = date('Y');
    	for ($num=$max_year-4;$num<=$max_year;$num++) {
    		$years[$num] = $num;
    	}
    	for ($num=1;$num<=12;$num++) {
            $num = sprintf('%02d',$num);
    		$months[$num] = $num;
    	}
    	for ($num=1;$num<=31;$num++) {
            $num = sprintf('%02d',$num);
    		$days[$num] = $num;
    	}
        $this->Assign('years', $years);
        $this->Assign('months', $months);
        $this->Assign('days', $days);

        $now_date = date('Y-m-d H:i:s');

        /* 開始年月日: */
        $date = $this->objmnp->getValue('regist_date');
        $date = empty($date)?$this->objmnp->getInitValue('regist_date'):$date;
        $date = empty($date)?$now_date:$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('regist_date', $init_date);
    }

    /**
     * 日記IDの取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function set_ref_diary()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->ref_diary = $result['id'];
    }

    /**
     * 本文のフォーマット
     *
     * @access public
     * @param string $value
     * @return string
     */
    function format_body($string)
    {
        return strip_tags($string);
    }

    /**
     * 入力された日付が正当か？
     *
     * @access private
     * @return boolean 正常時：真
     */
    function is_valid_term()
    {
        if (empty($_POST['regist_date'])){
            return true;
        }
        $regist_date = RKT_calendar::joinDate($_POST['regist_date']);
        $regist_date = strtotime($regist_date);

        return ($regist_date < time());
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('ref_account', $this->account['id']);
        }

        // 過去の日付かのチェック
        if (!$this->is_valid_term()){
            $this->objmnp->setAlert('error_term');
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_diary', $this->ref_diary);
        $this->objmnp->setValue('format', DIARY_FORMAT_PLAIN);

        /* 入力データの加工設定 */
        $func = array('webapp', 'format_body');
        $this->objmnp->setInputEffect('body', array('func'=>$func, 'key'=>'body'));

        $this->objmnp->setInputEffect('body', array('func'=>array('webapp', 'emojiConvert')));

        // 更新しない項目名
        $skip = array(
            'ref_account',
            'link',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * 投稿記事の削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_entry()
    {
        if (empty($_POST['delete'])){
            return false;
        }
        $this->delete_picture();

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_select '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_comment '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'id = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * 添付画像の削除
     *
     * @access private
     * @return boolean
     */
    function delete_picture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_blob::getInstance();
        foreach ($result as $value){
            $objblb->unlink(ARCHIVES_DIR.$value['filename']);
            $objblb->unlink(ARCHIVES_DIR.$value['thumbnail']);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_entry = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**********************************************/
    /**********    カテゴリ     *******************/
    /**********************************************/
    /**
     * 選択したカテゴリの取得
     *
     * @access private
     * @return array
     */
    function set_dia_select()
    {
        if (isSet($_POST['dia_select'])){
            $this->dia_select = empty($_POST['dia_select'])?array():$_POST['dia_select'];
            return ;
        }
        if (isSet($_SESSION['dia_select'])){
            $this->dia_select = empty($_SESSION['dia_select'])?array():$_SESSION['dia_select'];
            return ;
        }
        if (preg_match('/(manip|confirm|edit)/i',$_SERVER['REQUEST_URI'])){
            return ;
        }
        
        $sql=
            'SELECT '.
                'ref_category '.
            'FROM '.
                DB_PREFIX.'dia_select '.
            'WHERE '.
                'ref_diary = '.$this->ref_diary.' AND '.
                'ref_entry = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $value){
            $list[$value['ref_category']] = $value['ref_category'];
        }
        
        $this->dia_select = $list;
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $is_confirm = preg_match('/confirm/',$_SERVER['REQUEST_URI']);
        $sql = 
            'SELECT '.
                'cat.id as id,'.
                'count(ref.ref_category) as ct,'.
                'cat.category as category '.
            'FROM '.
                DB_PREFIX.'dia_category cat '.
                    'LEFT JOIN '.DB_PREFIX.'dia_select ref '.
                    'ON cat.id = ref.ref_category '.
            'WHERE '.
                'cat.ref_account = '.$this->account['id'].' '.
            'GROUP BY '.
                'cat.id '.
            'ORDER BY '.
                'cat.sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        if ($is_confirm){
            foreach ($result as $value){
                if (isSet($this->dia_select[$value['id']])){
                    $list[] = array(
                        'id'=> $value['id'],
                        'value'=> $value['id'],
                        'count'=> $value['ct'],
                        'label'=> $value['category'],
                    );
                }
            } // foreach ($result as $value)
        } else {
            foreach ($result as $value){
                $list[] = array(
                    'id'=> $value['id'],
                    'value'=> $value['id'],
                    'count'=> $value['ct'],
                    'label'=> $value['category'],
                    'checked'=> !empty($this->dia_select[$value['id']]),
                );
            }
        } // if ($this->confirm)


        $this->Assign('categorys', $list);
    }

    /**
     * 選択済みカテゴリの取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function get_selected()
    {
        $ref_entry = $this->objmnp->getCurID();
        $select = array();
        $sql=
            'SELECT '.
                'ref_category '.
            'FROM '.
                DB_PREFIX.'dia_select '.
            'WHERE '.
                'ref_diary ='.$this->ref_diary.' AND '.
                'ref_entry ='.$ref_entry;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return $select;
        }
        
        foreach ($result as $value){
            $select[$value['ref_category']] = $value['ref_category'];
        }

        return $select;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_query_select()
    {
        $ref_entry = $this->objmnp->getCurID();
        $selected = $this->get_selected();
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_category '.
            'WHERE '.
                'ref_diary ='.$this->ref_diary;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return false;
        }

        foreach ($result as $value){
            if (empty($this->dia_select[$value['id']])){
                if (!empty($selected[$value['id']])){
                    $this->delete_select($value['id'], $ref_entry);
                }
            } else {
                if (empty($selected[$value['id']])){
                    $this->insert_select($value['id'], $ref_entry);
                }
            }
        } // foreach ($result as $value)

        return true;
    }

    /**
     * 記事のカテゴリを新規登録
     *
     * @access private
     * @param integer $ref_category  カテゴリID
     * @param integer $ref_entry     記事ID
     * @return boolean  真偽値
     */
    function insert_select($ref_category, $ref_entry)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'dia_select('.
                    'ref_diary,'.
                    'ref_category,'.
                    'ref_entry'.
                ') VALUES ('.
                    $this->ref_diary.','.
                    $ref_category.','.
                    $ref_entry.
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * 記事のカテゴリを削除
     *
     * @access private
     * @param integer $ref_category  カテゴリID
     * @param integer $ref_entry     記事ID
     * @return boolean  真偽値
     */
    function delete_select($ref_category, $ref_entry)
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_select '.
            'WHERE '.
                'ref_diary ='.$this->ref_diary.' AND '.
                'ref_category ='.$ref_category.' AND '.
                'ref_entry ='.$ref_entry;
        return $this->objdb->exec($sql);
    }

    /******************************************************/
    /**************    メールアクション     ***************/
    /******************************************************/
    /**
     * 画像添付フラグの設定
     *
     * @access private
     * @return array
     */
    function set_attach()
    {
        if (isSet($_POST['attach'])){
            $this->attach = empty($_POST['attach'])?array():$_POST['attach'];
            return ;
        }
        if (isSet($_SESSION['attach'])){
            $this->attach = empty($_SESSION['attach'])?array():$_SESSION['attach'];
            return ;
        }
        if (isSet($_GET['attach'])){
            $this->attach = empty($_GET['attach'])?array():$_GET['attach'];
            return ;
        }
        if (preg_match('/(manip|confirm|edit)/i',$_SERVER['REQUEST_URI'])){
            return ;
        }
    }

    /**
     * メールアクション設定
     *
     * @access private
     * @return integer  データ操作結果
     */
    function mail_action()
    {
        if (empty($this->attach)){
            return false;
        }
        $ref_relation = $this->objmnp->getCurID();

        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_mailaction');

        $objmnp->setValue('modify',        date('Y-m-d H:i:s'));
        $objmnp->setValue('ref_table',     ACTION_DIA_ENTRY);
        $objmnp->setValue('ref_relation',  $ref_relation);
        $objmnp->setValue('ref_account',   $this->account['id']);

        return $objmnp->manip();
    }
} // webapp
?>
