<?php
/* ========================================================================
 - [modules/private/home/mail_action.php]
 -      Myホーム
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/19] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'PEAR/Net/POP3.php';
require_once LIB_DIR.'PEAR/Mail/mimeDecode.php';
require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_blob.php';
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_image.php';
require_once LIB_DIR.'rkt_validate.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 携帯アドレス
     * @var string
     */
    var $cellular = '';

    /**
     * アクション情報
     * @var array
     */
    var $action = array();

    /**
     * 添付ファイルの種類
     * @var string
     */
    var $attach_format = '';

    /**
     * 添付ファイル
     * @var binary
     */
    var $attach = null;

    /**
     * アクション元
     * @var integer
     */
    var $from = null;

    /**
     * 引数用第1変数
     * @var integer
     */
    var $arg1 = null;

    /**
     * 引数用第2変数
     * @var integer
     */
    var $arg2 = null;

    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * ファイルオジェクト
     * @var object
     */
    var $objfile = null;

    /**
     * 画像処理オジェクト
     * @var object
     */
    var $objimg = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/home/mail_action.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('from');
        $this->setPathInfo('arg1', 1);
        $this->setPathInfo('arg2', 2);

        $this->objdb   = RKT_db::getInstance();
        $this->objfile = RKT_blob::getInstance(BLOB_DRIVER, BLOB_PARAM);
        $this->objimg  = RKT_image::factory(IMAGE_DRIVER);

        if (POP3_HOST != ''){
    		$this->read_pop3();
        }
        if (MAIL_BOX_DIR != ''){
            $this->read_mailbox(MAIL_BOX_DIR);
        }

        $this->Assign('from', $this->from);
        $this->Assign('arg1', $this->arg1);
        $this->Assign('arg2', $this->arg2);
    }

    /**
     * メールボックスからの読み込み
     *
     * @access private
     * @param string $dir
     * @return void
     **/
    function read_mailbox($dir)
    {
        if (!is_dir($dir)){
            return false;
        }
    
        $files = array();
        $handle  = opendir($dir);
        if (!is_resource($handle)) {
            return false;
        }

        while (false !== ($file = readdir($handle))) {
            if ($file != '.' && $file != '..') {
                $files[] = $file;
            }
        } // while (false !== ($filename = readdir($dh)))
        closedir($handle);

        foreach ($files as $file){
            if (!is_dir($dir.$file)){
                $this->attach = array();
                $this->attach_format = array();

    	        // メール中身を取得
           		ob_start();
                @readfile($dir.$file);
		        $msg = ob_get_contents();
		        ob_end_clean();

    	        // メールソースの解析
    			$this->parse($msg);
    			if ($this->set_action()) {
        			if ($this->manip()){
                        unlink($dir.$file);
                    }
                } else {
                    unlink($dir.$file);
                }

                unset($this->attach);
                unset($this->attach_format);
            }
	    } // foreach ($files as $file)
    }

    /**
     * POP3からの読み込み
     *
     * @access private
     * @return boolean
     */
    function read_pop3()
    {
	    $pop3 =& new Net_POP3();		// オブジェクトの作成
	    $pop3->connect(POP3_HOST);		// 接続

	    /* ログイン */
	    $result = $pop3->login(POP3_ACCOUNT,POP3_PASSWORD,true);
		if (PEAR::isError($result)){
	        $pop3->disconnect();    /* POP3との接続を終了 */
	        return false;
	    }

	    $num = $pop3->numMsg();             // メッセージ数の取得
	    for ($row=1;$row<=$num;$row++){
            $this->attach = array();
            $this->attach_format = array();

	        //メールソースの解析
			$msg = $pop3->getMsg($row);
			$this->parse($msg);
			if ($this->set_action()) {
    			if ($this->manip()) {
                    $pop3->deleteMsg($row);     // メッセージの削除
                }
            } else {
                $pop3->deleteMsg($row);     // メッセージの削除
            }

            unset($this->attach);
            unset($this->attach_format);
	    } // for ($row=1;$row<=$num;$row++)

	    /* POP3との接続を終了 */
	    $pop3->disconnect();

	    return true;
    }

    /**
     * メールメッセージの解析
     *
     * @access private
     * @return boolean
     */
    function parse($msg)
    {
		$params = array(
			'include_bodies'=> true,
			'decode_bodies'=>  true,
			'decode_headers'=> true,
		);

        $objdcdr = new Mail_mimeDecode($msg);
        $objmail = $objdcdr->decode($params);

		$this->cellular = $objmail->headers['return-path'];
		$this->cellular = preg_replace('/<|>/i', '', $this->cellular);

	    /* 添付ファイルがある場合 */	    
	    $num = (empty($objmail->parts)?0:count($objmail->parts));
	    for ($row=0;$row<$num;$row++){
	        if ($objmail->parts[$row]->ctype_primary == 'text'){
	            $this->body .= mb_convert_encoding($objmail->parts[$row]->body, ENCODE_TYPE, 'ISO-2022-JP');
	        } elseif ($objmail->parts[$row]->ctype_primary == 'image'){
				$this->attach[] = $objmail->parts[$row]->body;
                $this->attach_format[] = $this->shape_format($objmail->parts[$row]->ctype_secondary);
	        }
	    } // for ($row=0;$row<$num;$row++)

	    /* 添付ファイルがない場合 */
	    if (!$num){
	        if ($objmail->ctype_primary == 'image'){
				$this->attach[] = $objmail->body;
                $this->attach_format[] = $this->shape_format($objmail->ctype_secondary);
	        }
	    } // if (!$num)
    }

    /**
     * フォーマットの整形
     *
     * @access private
     * @param string $format
     * @return integer  データ操作結果
     */
    function shape_format($format)
    {
        $format = strtolower($format);
        return preg_replace('/jpeg/i', 'jpg', $format);
    }

    /**
     * アカウントIDの設定
     *
     * @access private
     * @return boolean
     */
    function set_action()
    {
		if (!RKT_validate::email($this->cellular)){
			return false;
		}
		$cellular_hash = md5($this->cellular);
        $sql=
            'SELECT '.
                'mla.id as id,'.
                'mla.ref_table as ref_table,'.
                'mla.ref_relation as ref_relation,'.
                'mla.ref_account as ref_account '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_mailaction mla '.
            'WHERE '.
                'act.id = mla.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.cellular_hash = '.$this->objdb->quote($cellular_hash).' '.
            'ORDER BY '.
                'mla.modify';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $this->action = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($this->action['id'])){
            return false;
        }
        return true;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
	function manip()
	{
        $this->objfile->setUID($this->action['ref_account']);

		$maxrow = count($this->attach_format);
		for ($row=0; $row<$maxrow; $row++) {
		    if ($this->is_add_photo()){
                $this->save_picture($row);
            }
		} // for ($row=0; $row<$maxrow; $row++)
        return true;
	}

    /**
     * メールアクションの削除
     *
     * @access private
     * @return boolean
     */
    function delete_action()
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_mailaction '.
            'WHERE '.
                'id='.$this->action['id'];
        return $this->objdb->exec($sql);
    }

    /**
     * 画像が追加できるか
     *
     * @access private
     * @return boolean
     */
    function is_add_photo()
    {
        if ($this->action['ref_table'] != ACTION_ACT_PHOTO){
            return true;
        }
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'ref_account = '.$this->action['ref_account'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if ($result['ct'] >= 3){
            return false;
        }
        return true;
    }

    /**
     * 画像の保存処理
     *
     * @access public
     * @param integer $row
     * @return boolean
     */
    function save_picture($row)
    {
        if (empty($this->action['ref_community'])){
            $dir = ARCHIVES_MEMBER_PATH.$this->action['ref_account'].'/';
        } else {
            $this->objfile->setGID($this->action['ref_community']);
            $dir = ARCHIVES_COMMUNITY_PATH.$this->action['ref_community'].'/';
        }
        $temp = md5($this->action['ref_account'].time());
        $filename = substr($temp, rand(0,25), 6);
        $filename = $filename.'.'.$this->attach_format[$row];

        $large_name = $dir.'large/'.$filename;
        $small_name = $dir.'small/'.$filename;

        /* 大きいサイズの画像 */
        $this->objimg->setBinary($this->attach[$row], $this->attach_format[$row]);
        $this->objimg->resize(PHOTO_MAX_SIZE, PHOTO_MAX_SIZE);
        $large = $this->objimg->getInfo();

        $buffer = $this->objimg->getBinary();
        $this->objfile->setBuffer($buffer);
        $this->objfile->save($large_name);

        /* 小さいサイズの画像 */
        $this->objimg->setBinary($this->attach[$row], $this->attach_format[$row]);
        $this->objimg->resize(PHOTO_SMALL_SIZE, PHOTO_SMALL_SIZE);
        $small = $this->objimg->getInfo();

        $buffer = $this->objimg->getBinary();
        $this->objfile->setBuffer($buffer);
        $this->objfile->save($small_name);

        $this->picture = array(
            'title'=>       $filename,
            'filename'=>    $large_name,
            'width'=>       $large['width'],
            'height'=>      $large['height'],
            'thumbnail'=>   $small_name,
            't_width'=>     $small['width'],
            't_height'=>    $small['height'],
        );

        if ($this->insert_picture()){
            $this->delete_action();
        }

        return true;
    }

    /**
     * 添付画像を新規登録
     *
     * @access private
     * @return boolean  真偽値
     */
    function insert_picture()
    {
        $table = array(
            ACTION_ACT_PHOTO=>     'act_photo',     // 会員写真
            ACTION_DIA_ENTRY=>     'dia_picture',   // 日記記事
            ACTION_FRI_MESSAGE=>   'fri_picture',   // メッセージ
            ACTION_FRM_TOPIC=>     'frm_picture',   // フォーラムトピック
            ACTION_FRM_COMMENT=>   'frm_picture',   // フォーラムコメント
            ACTION_COM_COMMUNITY=> 'com_picture',   // コミュニティ
            ACTION_COM_TOPIC=>     'com_picture',   // コミュニティトピック
            ACTION_COM_COMMENT=>   'com_picture',   // コミュニティコメント
        );
        $relation = array(
            ACTION_ACT_PHOTO=>     null,            // 会員写真
            ACTION_DIA_ENTRY=>     'ref_entry',     // 日記記事
            ACTION_FRI_MESSAGE=>   'ref_message',   // メッセージ
            ACTION_FRM_TOPIC=>     'ref_relation',  // フォーラムトピック
            ACTION_FRM_COMMENT=>   'ref_relation',  // フォーラムコメント
            ACTION_COM_COMMUNITY=> 'ref_relation',  // コミュニティ
            ACTION_COM_TOPIC=>     'ref_relation',  // コミュニティトピック
            ACTION_COM_COMMENT=>   'ref_relation',  // コミュニティコメント
        );
        $status = array(
            ACTION_ACT_PHOTO=>     null,                    // 会員写真
            ACTION_DIA_ENTRY=>     null,                    // 日記記事
            ACTION_FRI_MESSAGE=>   null,                    // メッセージ
            ACTION_FRM_TOPIC=>     STATUS_PICTURE_TOPIC,    // フォーラムトピック
            ACTION_FRM_COMMENT=>   STATUS_PICTURE_COMMENT,  // フォーラムコメント
            ACTION_COM_COMMUNITY=> STATUS_PICTURE_COMMUNITY,// コミュニティ
            ACTION_COM_TOPIC=>     STATUS_PICTURE_TOPIC,    // コミュニティトピック
            ACTION_COM_COMMENT=>   STATUS_PICTURE_COMMENT,  // コミュニティコメント
        );
        $table    = $table[$this->action['ref_table']];
        $relation = $relation[$this->action['ref_table']];
        $status   = $status[$this->action['ref_table']];
        $title    = ($this->action['ref_table'] == ACTION_ACT_PHOTO)?'subject':'title';

        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.$table);

        $objmnp->setValue('modify',     date('Y-m-d H:i:s'));        
        $objmnp->setValue('ref_account',$this->action['ref_account']);
        $objmnp->setValue($title,       $this->picture['title']);
        $objmnp->setValue('filename',   $this->picture['filename']);
        $objmnp->setValue('width',      $this->picture['width']);
        $objmnp->setValue('height',     $this->picture['height']);
        $objmnp->setValue('thumbnail',  $this->picture['thumbnail']);
        $objmnp->setValue('t_width',    $this->picture['t_width']);
        $objmnp->setValue('t_height',   $this->picture['t_height']);

        if (!empty($relation)){
            $objmnp->setValue($relation,  $this->action['ref_relation']);
        }
        if (!empty($relation)){
            $objmnp->setValue($relation,  $this->action['ref_relation']);
        }
        if (!empty($status)){
            $objmnp->setValue('status',   $status);
        }

        return $objmnp->manip();
    }
} // webapp
?>
