<?php
/* ========================================================================
 - [webapp/libs/account.php]
 -      アカウント（状態）管理クラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 注意事項:
 -      PHP4用の古いバージョンではWAP_accountを継承して使う事が出来ません。
 -      serialize()関数が継承に対応していません。
 - 更新履歴：
 -      [2006/08/27] account::set_profile()を削除
 -      [2006/07/21] account::setInfo()の引数を$idに変更
 -      [2006/07/10] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';

/**
 * アカウント管理クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package account
 * @access public
 * @version 1.1
 */
class account
{
    /**
     * アカウント情報
     * @var array
     */
    var $infos = array();

    /**
     * インスタンス生成
     *
     * @access public
     */
    function &getInstance($id=null)
    {
        if (empty($id)){
            $id = empty($_POST['sid'])?null:$_POST['sid'];
        }
        $session_id = empty($id) ? session_id():session_id($id);

        if (!$session_id){
            session_start();
        }
        if (!isSet($_SESSION['account'])) {
            $_SESSION['account'] = new account();
        }
        return $_SESSION['account'];
    }

    /**
     * コンストラクタ
     *
     * @access public
     */
    function account()
    {
        $this->infos = array(
            'id'           => 0,
            'status'       => RKT_ACC_DEFAULT,
            'friend_number'=> 1,
        );
    }

    /**
     * アカウント削除
     *
     * @access public
     */
    function accountDestroy()
    {
        unset($_SESSION['account']);
    }

    /**
     * セッションIDの取得
     *
     * @access public
     * @return string セッションID
     */
    function getSessionID()
    {
        return session_id();
    }

    /**
     * アカウントIDの取得
     *
     * @access public
     * @return integer アカウントID
     */
    function getAccountID()
    {
        return $this->infos['id'];
    }

    /**
     * 管理者権限の有無
     *
     * @access public
     * @return boolean 管理者権限の有無
     */
    function isAdmin()
    {
        if ($this->infos['status'] != RKT_ACC_ADMIN){
            return false;
        }

        return true;
    }

    /**
     * 状態の取得
     *
     * @access public
     * @return string 状態
     */
    function getStatus()
    {
        return $this->infos['status'];
    }

    /**
     * ユーザー情報を取得しメンバーへ設定
     *
     * @access public
     * @param integer $id
     * @return boolean 正常時：真
     */
    function setInfo($id)
    {
        $objdb = RKT_db::getInstance();
        $sql=
            'SELECT '.
                'id,'.
                'status,'.
                'friend_number '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'id = '.$id;
        $stmt = $objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        if (empty($result)){
            return false;
        }

        $this->infos = array(
            'id'           => $result['id'],
            'status'       => $result['status'],
            'friend_number'=> $result['friend_number'],
        );

        /* PHP4用セッションの中身を更新 */
        $_SESSION['account'] = $this;

        return true;
    }

    /**
     * ユーザー情報を取得しメンバーへ設定
     *
     * @access public
     * @return boolean 正常時：真
     */
    function updateInfo($key,$value)
    {
        $objdb = RKT_db::getInstance();
        $sql=
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                $key."='".$value."' ".
            'WHERE '.
                'id='.$this->infos['id'];
        $result = $objdb->exec($sql); 

        $this->infos[$key] = $value;

        $_SESSION['account'] = $this;

        return true;
    }

    /**
     * ログイン日時の更新
     *
     * @access private
     * @return boolean 正常時：真
     */
    function updateLastLogin()
    {
        $objdb = RKT_db::getInstance();
        $sql=
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                "last_login = '".date('Y-m-d H:i:s')."' ".
            'WHERE '.
                'ref_account = '.$this->infos['id'];
        return $objdb->exec($sql); 
    }

    /**
     * ユーザー情報の取得
     *
     * @access public
     * @return array ユーザー情報
     */
    function getInfo($key=null)
    {
        if (empty($key)){
            return $this->infos;        
        }
        return $this->infos[$key];
    }
} // accountの終了
?>