<?php
/* ========================================================================
 - [modules/admin/environment/config.php]
 -      環境設定
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/19] メールアクション設定を追加
 -      [2006/09/17] PDFサポート設定を追加
 -      [2006/09/05] 定数書き換え正規表現の修正
 -      [2006/08/31] メールボックスパスの設定を追加
 -      [2006/08/02] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objvld = null;

    /**
     * 入力条件データ
     * @var array
     */
    var $conditions = array();

    /**
     * 入力データ
     * @var array
     */
    var $values = array();

    /**
     * configファイルの中身
     * @var string
     */
    var $buffer = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/environment/config.tpl');

        if (preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }

        // データ操作クラスの生成
        $this->objvld = new RKT_validate('_POST');
        if ($this->do_query()){
            header('Location: '.HTTP_ACTION.'admin/environment/config/complete/');
            exit();
        }
    }

    /**
     * 入力条件データの設定
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        $this->conditions = array (
            'wap_administrator'=> array(
                'type'=>     'email',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_system_name'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'copyright'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_invite'=> array(
                'type'=>     'number',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_pdf_support'=> array(
                'type'=>     'number',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_cookie_domain'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'base_url'=> array(
                'type'=>     'uri',
                'option'=>   null,
                'required'=> true,
            ),
            'ssl_url'=> array(
                'type'=>     'uri',
                'option'=>   null,
                'required'=> true,
            ),
            'amazon_associateid'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'imagemagick_path'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'image_driver'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'action_mail'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'pop3_host'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'pop3_account'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'pop3_password'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'mail_box_dir'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
        );
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_validate()
    {
        $this->set_condition();
        foreach ($this->conditions as $key=>$condition){
            $this->objvld->validate(
                    $condition['type'], 
                    $key, 
                    $condition['option'], 
                    $condition['required']);
            $this->values[$key] = $this->objvld->getRequest($key);
        }
        $this->Assign('value', $this->values);

        $check = $this->objvld->getValidate();
        if (!$check){
            $this->objvld->displayAlert($this);
            return false;
        }

        return true;
    }


    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function replace_define()
    {
        $this->values['wap_invite'] = empty($this->values['wap_invite'])?'FALSE':'TRUE';
        $this->values['wap_pdf_support'] = empty($this->values['wap_pdf_support'])?'FALSE':'TRUE';

        foreach ($this->values as $key=>$value){
            $key = strtoupper($key);
            if ('WAP_INVITE' === $key){
                $this->buffer = preg_replace(
                                    "/define\s*\('".$key."',\s*(TRUE|FALSE)\);/",
                                    "define('".$key."', ".$value.");",
                                    $this->buffer,
                                    1);
            } elseif ('WAP_PDF_SUPPORT' === $key){
                $this->buffer = preg_replace(
                                    "/define\s*\('".$key."',\s*(TRUE|FALSE)\);/",
                                    "define('".$key."', ".$value.");",
                                    $this->buffer,
                                    1);
            } elseif ('COPYRIGHT' === $key){
                $this->buffer = preg_replace(
                                    "/define\s*\('".$key."',\s*\".*\"\);/",
                                    "define('".$key."', \"".$value."\");",
                                    $this->buffer,
                                    1);
            } else {
                $this->buffer = preg_replace(
                                    "/define\s*\('".$key."',\s*'.*'\);/",
                                    "define('".$key."', '".$value."');",
                                    $this->buffer,
                                    1);
            }
        } // foreach ($this->values as $key=>$value)

        $filename = BASE_DIR.'sns_config.php';
        $handle = fopen($filename, 'w');
        if (!is_resource($handle)) {
            return false;
        }
        $result = fwrite($handle, $this->buffer);
        fclose($handle);

        return true;
    }


    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (empty($_POST['manip'])){
            return false;
        }

        if (!$this->do_validate()){
            return false;
        }

        $filename = BASE_DIR.'sns_config.php';

        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'r');
        if (!is_resource($handle)) {
            return false;
        }
        $this->buffer = fread($handle, filesize($filename));
        fclose($handle);
        
        return $this->replace_define();
    }
} // webapp
?>