<?php
/* ========================================================================
 - [modules/admin/inquire/sendmail.php]
 -      問合せ返信メール
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * メール送信ID
     * @var integer
     */
    var $id = null;

    /**
     * メール送信ID
     * @var integer
     */
    var $ref_inquire = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));
        
        $this->setTemplateFile('admin/inquire/sendmail.tpl');        

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_inquire');
        $this->Assign('ref_inquire', $this->ref_inquire);

        $this->setSafety('id');
        $this->Assign('id', $this->id);

        $this->set_inquire();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'inq_response');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->update_status();
            if ($this->sendmail()){
                header('Location: '.SSL_ACTION.'admin/inquire/browse/'.$this->ref_inquire.'/send/#response');
            } else {
                header('Location: '.SSL_ACTION.'admin/inquire/browse/'.$this->ref_inquire.'/complete/#response');
            }
            exit();
        }
        
        $this->set_froms();
        $statuses = array(
            STATAS_INQUIRE_PENDING=> STATAS_INQUIRE_LABEL_PENDING,
            STATAS_INQUIRE_RESPONDED=> STATAS_INQUIRE_LABEL_RESPONDED,
        );
        $this->Assign('statuses', $statuses);
    }

    /**
     * 送信元メールアドレス
     *
     * @access private
     * @return void
     */
    function set_froms()
    {
        $this->Assign('froms', WAP_ADMINISTRATOR);
    }

    /**
     * ステータスの更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_status()
    {
        $status = $this->objdb->quote($_POST['status']);
        $sql =
            'UPDATE '.
                DB_PREFIX.'inq_inquire '.
            'SET '.
                'status='.$status.' '.
            'WHERE '.
                'id = '.$this->ref_inquire;
        return $this->objdb->exec($sql);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $trigger = 'manip';
        $send    = 0;
        if (!empty($_POST['sendmail'])) {
            $trigger = 'sendmail';
            $send    = 1;
        }

        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('ref_inquire', $this->ref_inquire);
        $this->objmnp->setValue('send', $send);

        /* ステータス */
        $this->objmnp->validate('number', 'status', null, true);
        // $this->objmnp->setInput('status', $validate);


        // 更新しない項目名
        $skip = array(
            'regist_date',
            'ref_account',
        );
        $this->objmnp->catchInput($skip);

        return $this->objmnp->doManip($this,$trigger);
    }

    /**
     * フラグの更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_flag()
    {
        $sql =
            'UPDATE '.
                DB_PREFIX.'inq_inquire '.
            'SET '.
                'flag='.MESSAGE_FLAG_RETURN.' '.
            'WHERE '.
                'id = '.$this->ref_inquire;
        return $this->objdb->exec($sql);
    }

    /**
     * 参加者へメール送信
     *
     * @access private
     * @return boolean
     **/
    function sendmail()
    {
        if (empty($_REQUEST['sendmail'])){
            return false;
        }

        $sql = 
            'SELECT '.
                'id,'.
                'name,'.
                'email '.
            'FROM '.
                DB_PREFIX.'inq_inquire '.
            'WHERE '.
                'id = '.$this->ref_inquire;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result['email'])){
            return false;
        }
        $to = sql_query::decrypt($result['email']);

    	$subject   = $this->objmnp->getValue('subject');
    	$body      = $this->objmnp->getValue('body');
    	$body     .= "\r\n";

        $objmail = new sendmail('re_inquire');
        $objmail->Assign('body', $body);
        $objmail->send($to,$subject);
        
        $this->update_flag();

        return true;
    }

    /**
     * 問合せ内容の設定
     *
     * @access private
     * @return void
     */
    function set_inquire()
    {
        $sql = 
            'SELECT '.
                'inq.id as id,'.
                'inq.modify as modify,'.
                'inq.regist_date as regist_date,'.
                'cat.category as category,'.
                'inq.status as status,'.
                'inq.ref_account as ref_account,'.
                'inq.name as name,'.
                'inq.url as url,'.
                'inq.email as email,'.
                'inq.comment as comment '.
            'FROM '.
                DB_PREFIX.'inq_category cat,'.
                DB_PREFIX.'inq_inquire inq '.
            'WHERE '.
                'cat.id = inq.ref_category AND '.
                'inq.id = '.$this->ref_inquire;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('inquire',$result);
        $this->set_account($result['ref_account']);
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_account($ref_account)
    {
        if (empty($ref_account)){
            return ;
        }
        $sql=
            'SELECT '.
                'act.id as id,'.
                'act.last_login as last_login,'.
                'pht.filename as href,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = '.$ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();        
        
        $this->Assign('account', $result);
    }
} // webapp
?>
