<?php
/* ========================================================================
 - [modules/community/bbs/entrys.php]
 -      イベント参加メンバー一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/04] イベント参加インターフェースを変更
 -      [2006/08/29] 表示整形の不具合修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * トピックID
     * @var integer
     */
    var $id = 0;

    /**
     * 参加フラグ
     * @var integer
     */
    var $entry_flag = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/bbs/entrys.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('id', 1);
        $this->Assign('id', $this->id);

        /* メンバーではない */
        if (!$this->community['is_member']){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        }

        $this->set_entry_flag();
        /* イベント参加・不参加処理 */
        if ($this->query_entry()){
            header('Location: '.HTTP_ACTION.'community/bbs/entrys/'.$this->ref_community.'/'.$this->id.'/complete/');
            exit();
        }

        if (preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }

        $this->set_topic();
        $this->set_member();
    }

    /**
     * トピック一覧の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.regist_date as regist_date,'.
                'tpc.start_date as start_date,'.
                'tpc.deadline as deadline,'.
                'tpc.start_hour as start_hour,'.
                'tpc.start_minute as start_minute,'.
                'pro.nickname as nickname,'.
                'tpc.ref_account as ref_account,'.
                'tpc.status as status,'.
                'prf.prefecture as prefecture,'.
                'tpc.sub_locale as sub_locale,'.
                'tpc.topic as topic,'.
                'tpc.comment as comment '.
            'FROM '.
                DB_PREFIX.'com_topic tpc '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture prf '.
                    'ON prf.id = tpc.ref_prefecture,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $topic = array(
            'id'=> $result['id'],
            'regist_date'=> $result['regist_date'],
            'start_date'=> $result['start_date'],
            'deadline'=> (ereg('0000',$result['deadline']))?null:$result['deadline'],
            'start_hour'=> $result['start_hour'],
            'start_minute'=> $result['start_minute'],
            'nickname'=> $result['nickname'],
            'ref_account'=> $result['ref_account'],
            'status'=> $result['status'],
            'prefecture'=> $result['prefecture'],
            'sub_locale'=> $result['sub_locale'],
            'topic'=> $result['topic'],
            'comment'=> $result['comment'],
            'pictures'=> $this->get_picture($result['id'],STATUS_PICTURE_TOPIC),
            'count'=> $this->get_comment_num($result['id']),
            'entrys'=> $this->get_entry_num($result['id'])
        );

        $this->Assign('topic', $topic);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_topic
     * @param integer $status
     * @return mixed
     */
    function get_picture($ref_relation, $status)
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'status = '.$status.' AND '.
                'ref_relation = '.$ref_relation;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        return $result;
    }

    /**
     * コメント数の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return integer
     */
    function get_comment_num($ref_topic)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['ct'];
    }

    /**
     * 参加数の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return integer
     */
    function get_entry_num($ref_topic)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['ct'];
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_member()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_TILE);    // クラスの生成
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_entry ent '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = ent.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'ent.ref_topic = '.$this->id.' AND '.
                'ent.ref_community = '.$this->ref_community .' '.
            'ORDER BY '.
                'ent.modify ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        
        $list=array();
        $row=0;
        foreach ($result as $value){
            $value['src'] = empty($value['src'])?BASE_URL.NOPHOTO_SMALL:BASE_URL.$value['src'];
            $value['width'] = empty($value['width'])?PHOTO_SMALL_SIZE:$value['width'];
            $value['height'] = empty($value['height'])?PHOTO_SMALL_SIZE:$value['height'];

            $list[] = array(
                'id'=>            $value['id'],
                'nickname'=>      $value['nickname'],
                'friend_number'=> $value['friend_number'],
                'src'=>           $value['src'],
                'width'=>         $value['width'],
                'height'=>        $value['height']
            );
            $row++;
        }
        
        $inits = array (0,4,3,2,1);
        for ($row=$inits[$row%5]; $row; $row--){
            $list[] = array(
                'id'=> 0,
                'name'=> '',
                'friend_number'=>0,
                'src'=>    '',
                'width'=>  0,
                'height'=> 0
            );
        }
        $this->Assign('members', $this->shape_member($list));
    }

    /**
     * 会員情報の成形
     *
     * @access private
     * @return array
     */
    function shape_member($friends)
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($friends as $value){
            // 改行処理
            if ($column >= 5){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } // foreach ($result as $value)
        
        return $list;
    }

    /*********************************************************/
    /**
     * イベント参加フラグ
     *
     * @access private
     * @return integer  データ操作結果
     */
    function set_entry_flag()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->id.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 

        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
                
        $this->entry_flag = empty($result['id']);
        $this->Assign('entry_flag', $this->entry_flag);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return void
     */
    function query_entry()
    {
        if (empty($_POST['entry'])){
            return false;
        }
        
        $reslut = false;
        if ($this->entry_flag){
            $reslut = $this->insert_entry();
        } else {
            $reslut = $this->delete_entry();
        }
        
        return $reslut;
    }

    /**
     * イベント参加を新規登録
     *
     * @access private
     * @param integer $ref_item   選択肢ID
     * @return boolean  真偽値
     */
    function insert_entry()
    {
        $now = date('Y-m-d H:i:s');

        $sql =
            'INSERT INTO '.
                DB_PREFIX.'com_entry('.
                    'modify,'.
                    'regist_date,'.
                    'ref_community,'.
                    'ref_topic,'.
                    'ref_account'.
                ') VALUES ('.
                    "'".$now."',".
                    "'".$now."',".
                    $this->ref_community.','.
                    $this->id.','.
                    $this->account['id'].
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * イベント参加を削除
     *
     * @access private
     * @param integer $ref_item   選択肢ID
     * @return boolean  真偽値
     */
    function delete_entry()
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community ='.$this->ref_community.' AND '.
                'ref_topic ='.$this->id.' AND '.
                'ref_account ='.$this->account['id'];
        return $this->objdb->exec($sql);
    }
} // webapp
?>
