<?php
/* ========================================================================
 - [modules/private/message/browse.php]
 -      メッセージ閲覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/01/31] 画像添付の追加
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * メッセージID
     * @var integer
     */
    var $id = null;

    /**
     * ステータス
     * @var integer
     */
    var $status = 0;

    /**
     * Where 句
     * @var integer
     */
    var $where = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/message/browse.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        
        if (!$this->init_message()){
            header('Location: '.HTTP_ACTION.'private/message/list/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['return'])){
            header('Location: '.HTTP_ACTION.'private/message/send/'.WAP_URI_SEPARATOR.'ref_message='.$this->id);
            exit();
        }

        $statuses = array(
            MESSAGE_INBOX=> MESSAGE_LABEL_INBOX,
            MESSAGE_SENT=>  MESSAGE_LABEL_SENT,
            MESSAGE_DRAFT=> MESSAGE_LABEL_DRAFT,
            MESSAGE_TRASH=> MESSAGE_LABEL_TRASH,
        );
        $this->baseAssign('title', $statuses[$this->status]);
        $this->Assign('statuses', $statuses);

        $targets = array(
            MESSAGE_INBOX=> '送信者',
            MESSAGE_SENT=>  '受信者',
            MESSAGE_DRAFT=> '受信者',
            MESSAGE_TRASH=> '送信者',
        );
        $this->Assign('target', $targets[$this->status]);

        $icons = array(
            MESSAGE_FLAG_UNREAD=> 'unread',
            MESSAGE_FLAG_READ=>   'read',
            MESSAGE_FLAG_RETURN=> 'return',
        );
        $this->Assign('icons', $icons);

        /* メッセージ操作 */        
        if ($this->update_query()){
            header('Location: '.HTTP_ACTION.'private/message/list/'.$this->status.'/');
            exit();
        }
        if ($this->delete_query()){
            header('Location: '.HTTP_ACTION.'private/message/list/'.$this->status.'/');
            exit();
        }
        
        $this->update_flag();
        $this->set_message();
        $this->set_picture();
    }

    /**
     * メッセージ初期設定
     *
     * @access private
     * @return void
     */
    function init_message()
    {
        $sql=
            'SELECT '.
                'ref_to,'.
                'status '.
            'FROM '.
                DB_PREFIX.'fri_message '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result)){
            return false;
        }

        $this->status = $result['status'];
        $this->Assign('status', $this->status);

        $this->where = 'act.id = msg.ref_from AND ';
        if ($result['ref_to'] != $this->account['id']) {
            $this->where = 'act.id = msg.ref_to AND ';
        }
        return true;
    }

    /**
     * メッセージフラグの更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_flag()
    {
        $sql =
            'UPDATE '.
                DB_PREFIX.'fri_message '.
            ' SET '.
                'flag='.MESSAGE_FLAG_READ.' '.
            ' WHERE '.
                'flag = '.MESSAGE_FLAG_UNREAD.' AND '.
                'id = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * メッセージの設定
     *
     * @access private
     * @return void
     */
    function set_message()
    {
        $sql=
            'SELECT '.
                'msg.id as id,'.
                'act.id as ref_friend,'.
                'act.last_login as last_login,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'sex.sex as sex,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'msg.regist_date as regist_date,'.
                'msg.flag as flag,'.
                'msg.subject as subject,'.
                'msg.body as body '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_message msg '.
            'WHERE '.
                'sex.id = pro.ref_sex AND '.
                'act.id = pro.ref_account AND '.
                $this->where.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'msg.ref_account = '.$this->account['id']. ' AND '.
                'msg.id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('message', $result);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @return void
     */
    function set_picture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'fri_picture '.
            'WHERE '.
                'ref_message = '.$this->id.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('pictures', $result);
    }

    /**
     * メッセージボックスの移動
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function update_query()
    {
        if (empty($_POST['manip'])){
            return ;
        }

        $statuses = array(
            MESSAGE_INBOX,
            MESSAGE_SENT,
            MESSAGE_DRAFT,
            MESSAGE_TRASH,
        );
        $status = empty($_POST['status'])?MESSAGE_TRASH:$_POST['status'];        
        $status = in_array($status,$statuses)?$status:MESSAGE_TRASH;
        
        $where = '';
        if ($status == MESSAGE_INBOX){
            $where = 'ref_to='.$this->account['id'].' AND ';
        } elseif ($status == MESSAGE_SENT || $status == MESSAGE_DRAFT) {
            $where = 'ref_from='.$this->account['id'].' AND ';
        }

        $sql =
            'UPDATE '.
                DB_PREFIX.'fri_message '.
            ' SET '.
                'status='.$status.' '.
            ' WHERE '.
                $where.
                'id = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * メッセージの削除
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function delete_query()
    {
        if (empty($_POST['delete'])){
            return ;
        }
        
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_message '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_account ='.$this->account['id'];
        return $this->objdb->exec($sql);
    }
} // webapp
?>
