<?php
/* ========================================================================
 - [modules/private/review/item.php]
 -      レビュー対象商品検索
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'PEAR/Services/Amazon.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * キーワード
     * @var string
     */
    var $keyword = '';

    /**
     * カテゴリ
     * @var integer
     */
    var $ref_category = 0;

    /**
     * カテゴリコード格納
     * @var array
     */
    var $codes = array();

    /**
     * 表示ページ
     * @var integer
     */
    var $page = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('private/review/item.tpl');

        if (!empty($_POST['search'])){
            header('Location: '.HTTP_ACTION.'private/review/item/'.WAP_URI_SEPARATOR.http_build_query($_POST));
            exit();
        }

        $this->setSafety('keyword', '_REQUEST', 'string');
        $this->setSafety('ref_category');
        $this->setSafety('page', '_REQUEST');
        
        $this->set_category();
        $this->set_list();

        $this->Assign('keyword', $this->keyword);
        $this->Assign('ref_category',$this->ref_category);
        $this->Assign('page',    $this->page);
    }

    /**
     * カテゴリリストの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'code,'.
                'category '.
            'FROM '.
                DB_PREFIX.'rev_category '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
            $this->codes[$value['id']] = $value['code'];
        }
        
        $this->Assign('categorys', $list);
    }

    /**
     * コメントリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $this->ref_category = empty($this->ref_category)?1:$this->ref_category;
        $this->page     = empty($this->page)?1:$this->page;

        $amazon = &new Services_Amazon(AMAZON_TOKEN, AMAZON_ASSOCIATEID, AMAZON_LOCALE, AMAZON_BASEURL);

        $products = $amazon->searchKeyword($this->keyword, $this->codes[$this->ref_category], $this->page);
        if (PEAR::isError($products)) {
            // error_log('Services_Amazon::searchKeyword'."\t".$products->message."\r\n", 3, ERROR_LOG_FILE);
            return false;
        }

        /* ページ設定 */
        $this->set_page($products);
        
        $list = array();
        for ($row=0; $row<LIMIT_REVIEW; $row++) {
            if (!isset($products[$row])){
                break;
            }

            $product = $products[$row];
            $product['authors'] = empty($product['authors'])?null:$product['authors'];
            $product['artists'] = empty($product['artists'])?null:$product['artists'];


            if (is_array($product['authors'])) {
                $product['creator'] = implode(', ', $product['authors']);
            } elseif (is_array($product['artists'])) {
                $product['creator'] = implode(', ', $product['artists']);
            }

            $ourprice = empty($product['ourprice'])?null:$product['ourprice'];
            $product['listprice'] = empty($product['listprice'])?$ourprice:$product['listprice'];
            $product['ourprice']  = empty($product['ourprice'])?$product['listprice']:$product['ourprice'];
            if ($product['listprice'] != $product['ourprice']) {
                $product['price'] = $product['listprice'] .'('. $product['ourprice'].')';
            } else {
                $product['price'] = $product['listprice'];
            }

            $list[] = $product;
        }

        $this->Assign('list', $list);
    }

    /**
     * ページの設定
     *
     * @access private
     * @return void
     **/
    function set_page($products)
    {
        /* ページ設定 */
        $prev = 0;
        $next = 0;
        if ($products['page'] > 1) {
            $prev = $products['page'] -1;
        }
        if($products['page'] < $products['pages']) {
            $next = $products['page'] +1;
        }
        $this->Assign('pages', $products['pages']);
        $this->Assign('page',  $products['page']);
        $this->Assign('prev',  $prev);
        $this->Assign('next',  $next);        
    }
} // webapp
?>
