<?php
/* ========================================================================
 - [modules/public/login/login.php]
 -      ログイン
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/03/11] 連続リダイレクトの修正（トップからログインできない）
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 自動ログインフラグ
     * @var integer
     */
    var $autologin = null;
    
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        /* URL引数の取得 */
        $this->setSafety('autologin','_POST');

        /* ログイン後のデフォルトジャンプ先 */
        $jumps = array(
            WAP_ACC_ADMIN=>  HTTP_ACTION.'admin/inquire/list/',
            WAP_ACC_MEMBER=> HTTP_ACTION.'private/home/',
            WAP_ACC_GUEST=>  HTTP_ACTION.'public/login/entrance/',
        );

        $session_id = empty($_REQUEST['sid'])?null:$_REQUEST['sid'];

        $objauth = new RKT_auth($session_id);
        if (!$objauth->logIn()){
            $url = HTTP_ACTION.'public/login/entrance/'.WAP_URI_SEPARATOR.'mismatch=1&email='.urlencode($_REQUEST['logname']);
            header('Location: '.$url);
            exit();
        }
        $status = $objauth->account->getStatus();
        $url = empty($_REQUEST['url'])? $jumps[$status]:$_REQUEST['url'];

        if (!empty($_POST['autologin'])){
            $objauth->setAutoLogin();
        }
        header('Location: '.$url);
        exit();
    }
} // webapp
?>
