<?php
/* SVN FILE: $Id: view.php 578 2008-06-11 22:26:15Z bb_yujiro $ */
/**
 * 動画の表示
 *
 * PHP versions 5
 *
 *      Xoops ModuleのCinemaruをhitSujiプラグインに移植したものです。
 *      Xoops用の本家は http://cinemaru.jp/ を参照下さい。
 *
 * Licensed under The GNU General Public License v2
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        Plugin
 * @package         Cinemaru hitSuji Plugin
 * @copyright       Copyright (c) 2008 Cinemaru Project
 * @link            http://cinemaru.jp/
 * @author          時田正彦 <BQB04357@nifty.ne.jp>
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 578 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-12 07:26:15 +0900 (木, 12 6 2008) $
 * @license         http://www.gnu.org/licenses/gpl-2.0.txt The GPLv2
 */


/**
 * Controllerクラス
 *
 * @category        Plugin
 * @package         Cinemaru hitSuji Plugin
 * @copyright       Copyright (c) 2008 Cinemaru Project
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 578 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-12 07:26:15 +0900 (木, 12 6 2008) $
 * @license         http://www.gnu.org/licenses/gpl-2.0.txt The GPLv2
 */
class Controller extends Plugin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'cinemaru_movie',
            'cinemaru_comment',
        ),
        'view'=> array(
            'cinemaru_comment',
        ),            
    );

    /**
     * cinemaru_movie モデルオブジェクト
     * @var object 
     */
    public $cinemaru_movie = null;

    /**
     * cinemaru_comment モデルオブジェクト
     * @var object 
     */
    public $cinemaru_comment = null;

    /**
     * cinemaru_comment モデルオブジェクト
     * @var object 
     */
    public $v_cinemaru_comment = null;

    /**
     * 画像ID
     * @var integer
     */
    protected $id = null;

    /**
     * コメントID
     * @var integer
     */
    protected $ref_comment = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->cinemaru_movie->setCurId($this->id);
        $this->cinemaru_comment->setCurId($this->ref_comment);

        $this->v_cinemaru_comment->setValue('ref_movie', $this->id);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->cinemaru_movie->viewCounter();

        if ($this->checked_nonce && !empty($this->ref_comment)){
            $this->cinemaru_comment->setDelete();
            $this->cinemaru_comment->manip();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'ref_comment'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
