<?php
/* SVN FILE: $Id: movie_comment_post.php 578 2008-06-11 22:26:15Z bb_yujiro $ */
/**
 * 動画コメントの登録
 *
 * PHP versions 5
 *
 *      Xoops ModuleのCinemaruをhitSujiプラグインに移植したものです。
 *      Xoops用の本家は http://cinemaru.jp/ を参照下さい。
 *
 * Licensed under The GNU General Public License v2
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        Plugin
 * @package         Cinemaru hitSuji Plugin
 * @copyright       Copyright (c) 2008 Cinemaru Project
 * @link            http://cinemaru.jp/
 * @author          時田正彦 <BQB04357@nifty.ne.jp>
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 578 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-12 07:26:15 +0900 (木, 12 6 2008) $
 * @license         http://www.gnu.org/licenses/gpl-2.0.txt The GPLv2
 */

require dirname(__FILE__).'/../../../config.php';
require LIB_DIR.'rkt_functions.php';
require LIB_DIR.'rkt_db.php';
require LIB_DIR.'rkt_crypt.php';
require LIB_DIR.'rkt_session.php';
require LIB_DIR.'rkt_account.php';
require LIB_DIR.'rkt_request.php';
require LIB_DIR.'rkt_model.php';
require LIB_DIR.'rkt_plugin.php';

require LIB_DIR.'rktModel'.DS.'Manip.php';
require PLUGIN_DIR.'cinemaru'.DS.'player'.DS.'models'.DS.'manips'.DS.'cinemaru_comment.php';

/* セッションハンドル設定 */
RKT_session::setSaveHandler();

/* 値の初期化 */
$ref_account  = RKT_account::exec()->getAccountID();
$now          = date('Y-m-d H:i:s');
$domanip      = true;

/* リクエストオブジェクト */
$objrqt = RKT_Request::getInstance('_GET');

/* 画像IDの取得 */
$condition = array(
    'type'=>     'number',
    'option'=>   array(),            
    'required'=> true,
);
if ($objrqt->catchValidate('id', $condition)){
    $ref_movie = $objrqt->getRequest('id');
} else {
    $domanip = false;
}
/* 挿入時間の取得 */
$condition = array(
    'type'=>     'number',
    'option'=>   array('decimal'=>'.'),
    'required'=> true,
);
if ($objrqt->catchValidate('time', $condition)){
    $comment_time = $objrqt->getRequest('time');
    $comment_time = intval($comment_time * 1000);
} else {
    $domanip = false;
}
/* 挿入時間の取得 */
$condition = array(
    'type'=>     'string',
    'option'=>   array(''),
    'required'=> true,
);
if ($objrqt->catchValidate('comment', $condition)){
    $comment = $objrqt->getRequest('comment');
} else {
    $domanip = false;
}

/* コメントをDBへ挿入 */
if ($domanip){
    $objcmt = new cinemaru_comment();

    $objcmt->setValue('modified ',    $now);
    $objcmt->setValue('ref_movie',    $ref_movie);
    $objcmt->setValue('ref_author',   $ref_account);
    $objcmt->setValue('comment_time', $comment_time);
    $objcmt->setValue('comment',      $comment);

    $objcmt->manip();
}
?>